export declare enum LRUCacheEvent {
    Hit = "hit",
    Miss = "miss",
    Set = "set"
}
/**
 * LRU cache with EventEmitter implementation
 *
 * Uses node-lru-cache library under the hood ( see docs. https://github.com/isaacs/node-lru-cache#readme )
 */
export declare class LRUCache<TKey extends {}, TValue extends {}> {
    private cache;
    private emitter;
    constructor({ maxSize, maxAgeMs, updateAgeOnGet }: {
        maxSize: number;
        maxAgeMs?: number;
        updateAgeOnGet?: boolean;
    });
    get(key: TKey): TValue | undefined;
    set(key: TKey, value: TValue): void;
    on(event: LRUCacheEvent, listener: (...args: any[]) => void): void;
}
