import { Options as AmqplibOptions } from 'amqplib';
import IMessageOptions from './IMessageOptions';
import IConsumeOptions from './IConsumeOptions';
import { ExchangeType } from './Exchange';
import INackOptions from './INackOptions';
export type ICancelConsumption = () => Promise<void>;
export interface IBinding {
    exchangeName: string;
    /** persistent=false means that binding is removed when consumption is canceled */
    persistent: boolean;
    routingKey?: string;
    routingHeaders?: {
        'x-match': 'all' | 'any';
        [key: string]: any;
    };
}
export interface IGotMessage {
    message: any;
    headers: object;
    ack: () => void;
    nack: (nackOptions?: INackOptions) => void;
}
export default IChannel;
interface IChannel<TMessage> {
    assertExchange(exchangeName: string, type: ExchangeType, exchangeOptions?: AmqplibOptions.AssertExchange): Promise<void>;
    send(message: TMessage, messageOptions: IMessageOptions, headers: object, exchangeName: string, routingKey: string): Promise<void>;
    sendExpectingResponse<TResponseMessage>(message: TMessage, messageOptions: IMessageOptions, headers: object, exchangeName: string, routingKey: string, responseTimeout?: number): Promise<TResponseMessage>;
    assertRejectableQueue(queueName: string, consumeOptions?: IConsumeOptions): Promise<void>;
    consumeSimple<TResponseMessage>(queueName: string, bindings: IBinding[], onMessage: (message: any, headers: object) => Promise<TResponseMessage>, consumeOptions?: IConsumeOptions, onEnded?: () => void): Promise<ICancelConsumption>;
    consume<TResponseMessage>(queueName: string, bindings: IBinding[], onMessage: (message: any, headers: object, ack: () => void, nack: () => void) => Promise<TResponseMessage>, consumeOptions?: IConsumeOptions, onEnded?: () => void): Promise<ICancelConsumption>;
    unbind(queueName: string, binding: IBinding): Promise<void>;
    get(queueName: string): Promise<IGotMessage | null>;
    purge(queueName: string): Promise<void>;
    delete(queueName: string): Promise<void>;
    close(): Promise<void>;
}
