import { ProprietaryTimerType } from '@signageos/common-types/dist/Device/Timer/ProprietaryTimerType';
import IAction from '../../IAction';
import TimerType from './TimerType';
import { TimerLevel } from '@signageos/common-types/dist/Device/Timer/TimerLevel';
import { NativeTimerType } from '@signageos/common-types/dist/Device/Timer/NativeTimerType';
import { ShortWeekdayEnum } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
export type SetDeviceTimerSettingsType = 'Device.Timer.SyncTimerSettings';
export declare const SetDeviceTimerSettings: SetDeviceTimerSettingsType;
export type SetDeviceTimerSettings = SetDeviceNativeTimerSettings | SetDeviceProprietaryTimerSettings;
export interface SetDeviceNativeTimerSettings extends IAction<SetDeviceTimerSettingsType> {
    level: TimerLevel.Native;
    uid: string;
    timerType: NativeTimerType;
    volume: number;
    weekdays: ShortWeekdayEnum[];
    timeOn: string | null;
    timeOff: string | null;
}
export interface SetDeviceProprietaryTimerSettings extends IAction<SetDeviceTimerSettingsType> {
    level: TimerLevel.Proprietary;
    uid: string;
    timerType: ProprietaryTimerType;
    weekdays: ShortWeekdayEnum[];
    timeOn: string | null;
    timeOff: string | null;
}
export type SetDeviceTimerSettingsSucceededType = 'Device.Timer.SyncTimerSettingsSucceed';
export declare const SetDeviceTimerSettingsSucceeded: SetDeviceTimerSettingsSucceededType;
export interface SetDeviceTimerSettingsSucceeded extends IAction<SetDeviceTimerSettingsSucceededType> {
    uid: string;
}
export type SetDeviceTimerSettingsFailedType = 'Device.Timer.SyncTimerSettingsFailed';
export declare const SetDeviceTimerSettingsFailed: SetDeviceTimerSettingsFailedType;
export interface SetDeviceTimerSettingsFailed extends IAction<SetDeviceTimerSettingsFailedType> {
    uid: string;
}
export interface IOldDeviceTimerSettings {
    id: number;
    deviceId: number;
    createdAt: Date;
    type: TimerType;
    level: TimerLevel;
    timeOn: string | null;
    timeOff: string | null;
    sun: boolean;
    mon: boolean;
    tue: boolean;
    wed: boolean;
    thu: boolean;
    fri: boolean;
    sat: boolean;
    volume: number;
    onAtHoliday: boolean;
    offAtHoliday: boolean;
}
