import IAction from '../../IAction';
export declare enum TestCase {
    INFO = "info",
    DISPLAY = "display",
    AUDIO = "audio",
    VIDEO = "video",
    BATTERY = "battery",
    DATE_TIME = "date_time",
    FILE_SYSTEM = "file_system",
    REMOTE_CONTROL = "remote_control",
    HTML5 = "html5",
    CACHE = "cache",
    DEBUG = "debug",
    WEINRE = "weinre"
}
export type ItemResult = {
    title: string;
    skipped: boolean;
    failed: boolean;
    duration: number;
    reason?: string;
};
export type TestCaseResult = {
    beforeEach: ItemResult[];
    test: ItemResult;
    afterEach: ItemResult[];
};
export type TestResult = {
    title: string;
    total: number;
    successful: number;
    skipped: number;
    failed: number;
    duration: number;
    describe: TestResult[];
    test: TestCaseResult[];
    before: ItemResult[];
    after: ItemResult[];
};
interface IdentifiedTestResult extends IAction<string> {
    uid: string;
    identifier: string;
    result?: TestResult;
}
export declare const StartTestSuite = "Device.Test.StartTestSuite";
export interface StartTestSuite extends IAction<typeof StartTestSuite> {
    uid: string;
    tests: string[];
}
export declare const TestSucceeded = "Device.Test.TestSucceeded";
export interface TestSucceeded extends IdentifiedTestResult {
}
export declare const TestFailed = "Device.Test.TestFailed";
export interface TestFailed extends IdentifiedTestResult {
}
export declare const TestSkipped = "Device.Test.TestSkipped";
export interface TestSkipped extends IdentifiedTestResult {
}
export declare const SaveHTML5TestResult = "Device.Test.SaveHTML5TestResult";
export interface SaveHTML5TestResult extends IAction<typeof SaveHTML5TestResult> {
    testResult: any;
}
export {};
