import IAction from '../../IAction';
import PowerActionType from './PowerActionType';
import Weekday from '../../Misc/Weekday';
export declare const PerformPowerAction = "Device.Power.PerformPowerAction";
export interface PerformPowerAction extends IAction<typeof PerformPowerAction> {
    id: string;
    powerType: PowerActionType;
}
export declare const PerformPowerActionSucceed = "Device.Power.PerformPowerActionSucceed";
export interface PerformPowerActionSucceed extends IAction<typeof PerformPowerActionSucceed> {
    id: string;
}
export declare const PerformPowerActionFailed = "Device.Power.PerformPowerActionFailed";
export interface PerformPowerActionFailed extends IAction<typeof PerformPowerActionFailed> {
    id: string;
}
export declare const SchedulePowerAction = "Device.Power.SchedulePowerAction";
export interface SchedulePowerAction extends IAction<typeof SchedulePowerAction> {
    uid: string;
    powerType: PowerActionType;
    weekdays: Weekday[];
    time: string;
}
export declare const SchedulePowerActionSucceed = "Device.Power.SchedulePowerActionSucceed";
export interface SchedulePowerActionSucceed extends IAction<typeof SchedulePowerActionSucceed> {
    uid: string;
}
export declare const SchedulePowerActionFailed = "Device.Power.SchedulePowerActionFailed";
export interface SchedulePowerActionFailed extends IAction<typeof SchedulePowerActionFailed> {
    uid: string;
}
export declare const CancelScheduledPowerAction = "Device.Power.CancelScheduledPowerAction";
export interface CancelScheduledPowerAction extends IAction<typeof CancelScheduledPowerAction> {
    uid: string;
    scheduledPowerActionUid: string;
}
export declare const CancelScheduledPowerActionSucceed = "Device.Power.CancelScheduledPowerActionSucceed";
export interface CancelScheduledPowerActionSucceed extends IAction<typeof CancelScheduledPowerActionSucceed> {
    uid: string;
}
export declare const CancelScheduledPowerActionFailed = "Device.Power.CancelScheduledPowerActionFailed";
export interface CancelScheduledPowerActionFailed extends IAction<typeof CancelScheduledPowerActionFailed> {
    uid: string;
}
