import IAction from '../../IAction';
import { InstalledPackages } from '@signageos/common-types/dist/Device/Package/DevicePackageInstalled';
import { DevicePackageInstallation } from '@signageos/common-types/dist/Device/Package/DevicePackageInstallation';
import { DevicePackageInstallationFromUri } from '@signageos/common-types/dist/Device/Package/DevicePackageInstallationFromUri';
import { DevicePackageUninstallation } from '@signageos/common-types/dist/Device/Package/DevicePackageUninstallation';
import { DevicePackageStart } from '@signageos/common-types/dist/Device/Package/DevicePackageStart';
import { RenameProperty } from '@signageos/lib/dist/TypeScript/object';
import { AndroidInstalledSpecs } from '@signageos/common-types/dist/Package/Android/specs';
export declare const InstallPackage = "Device.Package.InstallPackage";
export type InstallPackage = RenameProperty<DevicePackageInstallation, 'applicationType', 'application'> & IAction<typeof InstallPackage> & {
    uid: string;
};
export type AndroidInstallPackage = Extract<InstallPackage, {
    application: 'android';
}>;
export declare const InstallPackageSucceeded = "Device.Package.InstallPackageSucceeded";
export interface InstallPackageSucceeded extends IAction<typeof InstallPackageSucceeded> {
    uid: string;
}
export declare const InstallPackageFailed = "Device.Package.InstallPackageFailed";
export interface InstallPackageFailed extends IAction<typeof InstallPackageFailed> {
    uid: string;
}
export declare const InstallPackageFromUri = "Device.Package.InstallPackageFromUri";
export type InstallPackageFromUri = IAction<typeof InstallPackageFromUri> & DevicePackageInstallationFromUri & {
    uid: string;
};
export declare const InstallPackageFromUriSucceeded = "Device.Package.InstallPackageFromUriSucceeded";
export interface InstallPackageFromUriSucceeded extends IAction<typeof InstallPackageFromUriSucceeded> {
    uid: string;
}
export declare const InstallPackageFromUriFailed = "Device.Package.InstallPackageFromUriFailed";
export interface InstallPackageFromUriFailed extends IAction<typeof InstallPackageFromUriFailed> {
    uid: string;
}
export declare const StartPackage = "Device.Package.StartPackage";
export interface StartPackage extends IAction<typeof StartPackage>, DevicePackageStart {
    uid: string;
}
export type AndroidStartPackage = Extract<StartPackage, {
    applicationType: 'android';
}>;
export declare const StartPackageSucceeded = "Device.Package.StartPackageSucceeded";
export interface StartPackageSucceeded extends IAction<typeof StartPackageSucceeded> {
    uid: string;
}
export declare const StartPackageFailed = "Device.Package.StartPackageFailed";
export interface StartPackageFailed extends IAction<typeof StartPackageFailed> {
    uid: string;
}
export declare const UninstallPackage = "Device.Package.UninstallPackage";
export interface UninstallPackage extends IAction<typeof UninstallPackage>, DevicePackageUninstallation {
    uid: string;
}
export type AndroidUninstallPackage = Extract<UninstallPackage, {
    applicationType: 'android';
}>;
export declare const UninstallPackageSucceeded = "Device.Package.UninstallPackageSucceeded";
export interface UninstallPackageSucceeded extends IAction<typeof UninstallPackageSucceeded> {
    uid: string;
}
export declare const UninstallPackageFailed = "Device.Package.UninstallPackageFailed";
export interface UninstallPackageFailed extends IAction<typeof UninstallPackageFailed> {
    uid: string;
}
export declare const NotifyInstalledPackages = "Device.Package.NotifyInstalledPackages";
export interface NotifyInstalledPackages extends IAction<typeof NotifyInstalledPackages>, InstalledPackages {
}
export type AndroidNotifyInstalledPackages = Extract<NotifyInstalledPackages, {
    applicationType: 'android';
}>;
/** @deprecated Use {@link AndroidInstalledSpecs} instead */
export type IAndroidInstalledSpecs = AndroidInstalledSpecs;
