import IAction from '../../IAction';
export declare const SetDeviceLockMode = "Device.RemoteControl.SyncRemoteControlSettings";
export interface SetDeviceLockMode extends IAction<typeof SetDeviceLockMode> {
    uid: string;
    /** @deprecated use `uid` instead */
    id?: string;
    /**
     * @deprecated use `mode` instead.
     * This value is redundant and will be unused in the future.
     * It can be derived from `mode === LockMode.Unlocked`.
     * This property can never be removed because old devices still use it.
     */
    enabled: boolean;
    /**
     * Once the mode is used everywhere, the `enabled` property will always be derived from the `mode` property.
     */
    mode?: LockMode;
}
export declare const SetDeviceLockModeSucceeded = "Device.RemoteControl.SyncRemoteControlSettingsSucceed";
export interface SetDeviceLockModeSucceeded extends IAction<typeof SetDeviceLockModeSucceeded> {
    uid: string;
    /** @deprecated use `uid` instead */
    id?: string;
}
export declare const SetDeviceLockModeFailed = "Device.RemoteControl.SyncRemoteControlSettingsFailed";
export interface SetDeviceLockModeFailed extends IAction<typeof SetDeviceLockModeFailed> {
    uid: string;
    /** @deprecated use `uid` instead */
    id?: string;
}
