import IAction from '../../IAction';
import { CustomScript, CustomScriptResult } from '@signageos/common-types/dist/CustomScript/CustomScript';
/**
 * Executes a custom script on the device.
 */
export declare const ExecuteCustomScript = "Device.CustomScript.ExecuteCustomScript";
export interface ExecuteCustomScript extends IAction<typeof ExecuteCustomScript> {
    uid: string;
    customScript: CustomScript;
    frontAppletVersion?: string;
    configuration: Record<string, any>;
    /** Keys in configuration which are encrypted with device public key */
    encryptedConfigurationFields?: string[];
}
/**
 * Reports the success of executing a custom script on the device.
 * The script itself could fail internally and that is based on internal logic of a specific runtime (i.e. PowerShell & Bash uses exitCode).
 * So the success of this action means that the script was successfully delivered to the device and executed.
 */
export declare const ExecuteCustomScriptSucceeded = "Device.CustomScript.ExecuteCustomScriptSucceeded";
export interface ExecuteCustomScriptSucceeded extends IAction<typeof ExecuteCustomScriptSucceeded> {
    uid: string;
    result: CustomScriptResult;
}
/**
 * Reports the failure during delivering or an unexpected error during executing a custom script on the device.
 */
export declare const ExecuteCustomScriptFailed = "Device.CustomScript.ExecuteCustomScriptFailed";
export interface ExecuteCustomScriptFailed extends IAction<typeof ExecuteCustomScriptFailed> {
    uid: string;
    error?: string;
}
