import IAction from "../IAction";
import ICredentials from "./ICredentials";
import AuthenticationType from "./AuthenticationType";
import AuthenticationFailReason from "./AuthenticationFailReason";
import AuthenticationSource from "./AuthenticationSource";
export declare const AuthenticateDevice = "Authentication.AuthenticateDevice";
export interface AuthenticateDevice extends IAction<typeof AuthenticateDevice> {
    credentials: ICredentials;
    authenticationType: AuthenticationType;
}
export declare const AuthenticateAccount = "Authentication.AuthenticateAccount";
export interface AuthenticateAccount extends IAction<typeof AuthenticateAccount> {
    credentials: ICredentials;
    authenticationType: AuthenticationType;
}
export declare const AuthenticationSucceed = "Authentication.AuthenticationSucceed";
export interface AuthenticationSucceed extends IAction<typeof AuthenticationSucceed> {
    sessionUid: string;
    source: AuthenticationSource;
}
export declare const AuthenticationFailed = "Authentication.AuthenticationFailed";
export interface AuthenticationFailed extends IAction<typeof AuthenticationFailed> {
    reason: AuthenticationFailReason;
}
export declare const NewSessionStored = "Authentication.NewSessionStored";
export interface NewSessionStored extends IAction<typeof NewSessionStored> {
}
export declare const SessionCreated = "Authentication.SessionCreated";
export interface SessionCreated extends IAction<typeof SessionCreated> {
    uid: string;
}
export declare const RevokeDevice = "Authentication.RevokeDevice";
export interface RevokeDevice extends IAction<typeof RevokeDevice> {
}
export declare const RevokeSucceed = "Authentication.RevokeSucceed";
export interface RevokeSucceed extends IAction<typeof RevokeSucceed> {
}
export interface IAccount {
    id: number;
}
export declare const AccountAuthenticated = "Authentication.AccountAuthenticated";
export interface AccountAuthenticated<TAccount extends IAccount> extends IAction<typeof AccountAuthenticated> {
    account: TAccount;
}
