(function(){eval('/*\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * "License"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n//----------------------------------------------------------------------------\n// an implementation of the require() function as specified for use with\n// CommonJS Modules - see http://commonjs.org/specs/modules/1.0.html\n//----------------------------------------------------------------------------\n\n//----------------------------------------------------------------------------\n// inspired from David Flanagan\'s require() function documented here:\n// http://www.davidflanagan.com/2009/11/a-module-loader.html\n//----------------------------------------------------------------------------\n\n//----------------------------------------------------------------------------\n// only supports "preloaded" modules ala define() (AMD)\n//    http://wiki.commonjs.org/wiki/Modules/AsynchronousDefinition\n// but the id parameter is required\n//----------------------------------------------------------------------------\n\n//----------------------------------------------------------------------------\n// function wrapper\n//----------------------------------------------------------------------------\n(function(){\n\n//----------------------------------------------------------------------------\n// some constants\n//----------------------------------------------------------------------------\nvar PROGRAM = "modjewel"\nvar VERSION = "2.0.0"\nvar global  = this\n\n//----------------------------------------------------------------------------\n// if require() is already defined, leave\n//----------------------------------------------------------------------------\nif (global.modjewel) {\n    log("modjewel global variable already defined")\n    return\n}\n\nglobal.modjewel = null\n\n//----------------------------------------------------------------------------\n// "globals" (local to this function scope though)\n//----------------------------------------------------------------------------\nvar ModuleStore\nvar ModulePreloadStore\nvar MainModule\nvar WarnOnRecursiveRequire = false\n\n//----------------------------------------------------------------------------\n// the require function\n//----------------------------------------------------------------------------\nfunction get_require(currentModule) {\n    var result = function require(moduleId) {\n\n        if (moduleId.match(/^\\.{1,2}\\//)) {\n            moduleId = normalize(currentModule, moduleId)\n        }\n\n        if (hop(ModuleStore, moduleId)) {\n            var module = ModuleStore[moduleId]\n            if (module.__isLoading) {\n                if (WarnOnRecursiveRequire) {\n                    var fromModule = currentModule ? currentModule.id : "<root>"\n                    console.log("module \'" + moduleId + "\' recursively require()d from \'" + fromModule + "\', problem?")\n                }\n            }\n\n            currentModule.moduleIdsRequired.push(moduleId)\n\n            return module.exports\n        }\n\n        if (!hop(ModulePreloadStore, moduleId)) {\n            var fromModule = currentModule ? currentModule.id : "<root>"\n            error("module \'" + moduleId + "\' not found from \'" + fromModule + "\', must be define()\'d first")\n        }\n\n        var factory = ModulePreloadStore[moduleId][0]\n        var prereqs = ModulePreloadStore[moduleId][1]\n\n        var module = create_module(moduleId)\n\n        var newRequire = get_require(module)\n\n        ModuleStore[moduleId] = module\n\n        module.__isLoading = true\n        try {\n            currentModule.moduleIdsRequired.push(moduleId)\n\n            var prereqModules = []\n            for (var i=0; i<prereqs.length; i++) {\n                var prereqId = prereqs[i]\n                var prereqModule\n\n                if      (prereqId == "require") prereqModule = newRequire\n                else if (prereqId == "exports") prereqModule = module.exports\n                else if (prereqId == "module")  prereqModule = module\n                else                            prereqModule = newRequire(prereqId)\n\n                prereqModules.push(prereqModule)\n            }\n\n            if (typeof factory == "function") {\n                var result = factory.apply(null, prereqModules)\n                if (result) {\n                    module.exports = result\n                }\n            }\n            else {\n                module.exports = factory\n            }\n        }\n        finally {\n            module.__isLoading = false\n        }\n\n        return module.exports\n    }\n\n    result.define         = require_define\n    result.implementation = PROGRAM\n    result.version        = VERSION\n\n    return result\n}\n\n//----------------------------------------------------------------------------\n// shorter version of hasOwnProperty\n//----------------------------------------------------------------------------\nfunction hop(object, name) {\n    return Object.prototype.hasOwnProperty.call(object, name)\n}\n\n//----------------------------------------------------------------------------\n// create a new module\n//----------------------------------------------------------------------------\nfunction create_module(id) {\n    return {\n        id:                id,\n        uri:               id,\n        exports:           {},\n        prereqIds:         [],\n        moduleIdsRequired: []\n    }\n}\n\n//----------------------------------------------------------------------------\n// reset the stores\n//----------------------------------------------------------------------------\nfunction require_reset() {\n    ModuleStore        = {}\n    ModulePreloadStore = {}\n    MainModule         = create_module(null)\n\n    var require = get_require(MainModule)\n    var define  = require_define\n    \n    define("modjewel", modjewel_module)\n\n    global.modjewel            = require("modjewel")\n    global.modjewel.require    = require\n    global.modjewel.define     = define\n    global.modjewel.define.amd = {implementation: PROGRAM, version: VERSION}\n}\n\n//----------------------------------------------------------------------------\n// used by pre-built modules that can be included via <script src=>\n// a simplification of\n//    http://wiki.commonjs.org/wiki/Modules/AsynchronousDefinition\n// where id is required\n//----------------------------------------------------------------------------\nfunction require_define(moduleId, prereqs, factory) {\n    var rem = ["require", "exports", "module"]\n\n    if (typeof moduleId != "string") {\n        console.log("modjewel.define(): first parameter must be a string; was: " + moduleId)\n        return\n    }\n\n    if (arguments.length == 2) {\n        factory = prereqs\n        prereqs = null\n    }\n\n    if (!prereqs || prereqs.length == 0) {\n        prereqs = rem\n    }\n\n    if (typeof factory != "function") {\n        if (factory) {\n            ModulePreloadStore[moduleId] = [factory, prereqs]\n            return\n        }\n\n        console.log("modjewel.define(): factory was falsy: " + factory)\n        return\n    }\n\n    if (moduleId.match(/^\\./)) {\n        console.log("modjewel.define(): moduleId must not start with \'.\': \'" + moduleName + "\'")\n        return\n    }\n\n    if (hop(ModulePreloadStore, moduleId)) {\n        console.log("modjewel.define(): module \'" + moduleId + "\' has already been defined")\n        return\n    }\n\n    ModulePreloadStore[moduleId] = [factory, prereqs]\n}\n\n//----------------------------------------------------------------------------\n// get the path of a module\n//----------------------------------------------------------------------------\nfunction getModulePath(module) {\n    if (!module || !module.id) return ""\n\n    var parts = module.id.split("/")\n\n    return parts.slice(0, parts.length-1).join("/")\n}\n\n//----------------------------------------------------------------------------\n// normalize a \'file name\' with . and .. with a \'directory name\'\n//----------------------------------------------------------------------------\nfunction normalize(module, file) {\n    var modulePath = getModulePath(module)\n    var dirParts   = ("" == modulePath) ? [] : modulePath.split("/")\n    var fileParts  = file.split("/")\n\n    for (var i=0; i<fileParts.length; i++) {\n        var filePart = fileParts[i]\n\n        if (filePart == ".") {\n        }\n\n        else if (filePart == "..") {\n            if (dirParts.length > 0) {\n                dirParts.pop()\n            }\n            else {\n                // error("error normalizing \'" + module + "\' and \'" + file + "\'")\n                // eat non-valid .. paths\n            }\n        }\n\n        else {\n            dirParts.push(filePart)\n        }\n    }\n\n    return dirParts.join("/")\n}\n\n//----------------------------------------------------------------------------\n// throw an error\n//----------------------------------------------------------------------------\nfunction error(message) {\n    throw new Error(PROGRAM + ": " + message)\n}\n\n//----------------------------------------------------------------------------\n// get a list of loaded modules\n//----------------------------------------------------------------------------\nfunction modjewel_getLoadedModuleIds() {\n    var result = []\n\n    for (moduleId in ModuleStore) {\n        result.push(moduleId)\n    }\n\n    return result\n}\n\n//----------------------------------------------------------------------------\n// get a list of the preloaded module ids\n//----------------------------------------------------------------------------\nfunction modjewel_getPreloadedModuleIds() {\n    var result = []\n\n    for (moduleId in ModulePreloadStore) {\n        result.push(moduleId)\n    }\n\n    return result\n}\n\n//----------------------------------------------------------------------------\n// get a module by module id\n//----------------------------------------------------------------------------\nfunction modjewel_getModule(moduleId) {\n    if (null == moduleId) return MainModule\n\n    return ModuleStore[moduleId]\n}\n\n//----------------------------------------------------------------------------\n// get a list of module ids which have been required by the specified module id\n//----------------------------------------------------------------------------\nfunction modjewel_getModuleIdsRequired(moduleId) {\n    var module = modjewel_getModule(moduleId)\n    if (null == module) return null\n\n    return module.moduleIdsRequired.slice()\n}\n\n//----------------------------------------------------------------------------\n// set the WarnOnRecursiveRequireFlag\n// - if you make use of "module.exports =" in your code, you will want this on\n//----------------------------------------------------------------------------\nfunction modjewel_warnOnRecursiveRequire(value) {\n    if (arguments.length == 0) return WarnOnRecursiveRequire\n    WarnOnRecursiveRequire = !!value\n}\n\n//----------------------------------------------------------------------------\n// the modjewel module\n//----------------------------------------------------------------------------\nfunction modjewel_module(require, exports, module) {\n    exports.VERSION                = VERSION\n    exports.require                = null // filled in later\n    exports.define                 = null // filled in later\n    exports.getLoadedModuleIds     = modjewel_getLoadedModuleIds\n    exports.getPreloadedModuleIds  = modjewel_getPreloadedModuleIds\n    exports.getModule              = modjewel_getModule\n    exports.getModuleIdsRequired   = modjewel_getModuleIdsRequired\n    exports.warnOnRecursiveRequire = modjewel_warnOnRecursiveRequire\n}\n\n//----------------------------------------------------------------------------\n// log a message\n//----------------------------------------------------------------------------\nfunction log(message) {\n    console.log("modjewel: " + message)\n}\n\n//----------------------------------------------------------------------------\n// make the require function a global\n//----------------------------------------------------------------------------\nrequire_reset()\n\n//----------------------------------------------------------------------------\n})();\n\n//@ sourceURL=modjewel.js'),modjewel.require("modjewel").warnOnRecursiveRequire(!0),eval(';modjewel.define("weinre/common/Binding", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Binding, Ex;\n\nEx = require(\'./Ex\');\n\nmodule.exports = Binding = (function() {\n  function Binding(receiver, method) {\n    if (!receiver) {\n      throw new Ex(arguments, "receiver argument for Binding constructor was null");\n    }\n    if (typeof method === "string") {\n      method = receiver[method];\n    }\n    if (typeof method === !"function") {\n      throw new Ex(arguments, "method argument didn\'t specify a function");\n    }\n    return function() {\n      return method.apply(receiver, [].slice.call(arguments));\n    };\n  }\n\n  return Binding;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/Binding.amd.js'),eval(';modjewel.define("weinre/common/Callback", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Callback, CallbackIndex, CallbackTable, ConnectorChannel, Ex;\n\nEx = require(\'./Ex\');\n\nCallbackTable = {};\n\nCallbackIndex = 1;\n\nConnectorChannel = "???";\n\nmodule.exports = Callback = (function() {\n  function Callback() {\n    throw new Ex(arguments, "this class is not intended to be instantiated");\n  }\n\n  Callback.setConnectorChannel = function(connectorChannel) {\n    return ConnectorChannel = "" + connectorChannel;\n  };\n\n  Callback.register = function(callback) {\n    var data, func, index, receiver;\n    if (typeof callback === "function") {\n      callback = [null, callback];\n    }\n    if (typeof callback.slice !== "function") {\n      throw new Ex(arguments, "callback must be an array or function");\n    }\n    receiver = callback[0];\n    func = callback[1];\n    data = callback.slice(2);\n    if (typeof func === "string") {\n      func = receiver[func];\n    }\n    if (typeof func !== "function") {\n      throw new Ex(arguments, "callback function was null or not found");\n    }\n    index = ConnectorChannel + "::" + CallbackIndex;\n    CallbackIndex++;\n    if (CallbackIndex >= 65536 * 65536) {\n      CallbackIndex = 1;\n    }\n    CallbackTable[index] = [receiver, func, data];\n    return index;\n  };\n\n  Callback.deregister = function(index) {\n    return delete CallbackTable[index];\n  };\n\n  Callback.invoke = function(index, args) {\n    var callback, e, func, funcName, receiver;\n    callback = CallbackTable[index];\n    if (!callback) {\n      throw new Ex(arguments, "callback " + index + " not registered or already invoked");\n    }\n    receiver = callback[0];\n    func = callback[1];\n    args = callback[2].concat(args);\n    try {\n      return func.apply(receiver, args);\n    } catch (_error) {\n      e = _error;\n      funcName = func.name || func.signature;\n      if (!funcName) {\n        funcName = "<unnamed>";\n      }\n      return require("./Weinre").logError(arguments.callee.signature + (" exception invoking callback: " + funcName + "(" + (args.join(\',\')) + "): ") + e);\n    } finally {\n      Callback.deregister(index);\n    }\n  };\n\n  return Callback;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/Callback.amd.js'),eval(';modjewel.define("weinre/common/Debug", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Debug;\n\nmodule.exports = new (Debug = (function() {\n  function Debug() {\n    this._printCalledArgs = {};\n  }\n\n  Debug.prototype.log = function(message) {\n    var console;\n    console = window.console.__original || window.console;\n    return console.log("" + (this.timeStamp()) + ": " + message);\n  };\n\n  Debug.prototype.logCall = function(context, intf, method, args, message) {\n    var printArgs, signature;\n    if (message) {\n      message = ": " + message;\n    } else {\n      message = "";\n    }\n    signature = this.signature(intf, method);\n    printArgs = this._printCalledArgs[signature];\n    if (printArgs) {\n      args = JSON.stringify(args, null, 4);\n    } else {\n      args = "";\n    }\n    return this.log("" + context + " " + signature + "(" + args + ")" + message);\n  };\n\n  Debug.prototype.logCallArgs = function(intf, method) {\n    return this._printCalledArgs[this.signature(intf, method)] = true;\n  };\n\n  Debug.prototype.signature = function(intf, method) {\n    return "" + intf + "." + method;\n  };\n\n  Debug.prototype.timeStamp = function() {\n    var date, mins, secs;\n    date = new Date();\n    mins = "" + (date.getMinutes());\n    secs = "" + (date.getSeconds());\n    if (mins.length === 1) {\n      mins = "0" + mins;\n    }\n    if (secs.length === 1) {\n      secs = "0" + secs;\n    }\n    return "" + mins + ":" + secs;\n  };\n\n  return Debug;\n\n})());\n\n});\n\n//@ sourceURL=weinre/common/Debug.amd.js'),eval(';modjewel.define("weinre/common/EventListeners", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar EventListeners, Ex, Weinre;\n\nEx = require(\'./Ex\');\n\nWeinre = require(\'./Weinre\');\n\nmodule.exports = EventListeners = (function() {\n  function EventListeners() {\n    this.listeners = [];\n  }\n\n  EventListeners.prototype.add = function(listener, useCapture) {\n    return this.listeners.push([listener, useCapture]);\n  };\n\n  EventListeners.prototype.remove = function(listener, useCapture) {\n    var listeners, _i, _len, _listener;\n    listeners = this.listeners.slice();\n    for (_i = 0, _len = listeners.length; _i < _len; _i++) {\n      _listener = listeners[_i];\n      if (_listener[0] !== listener) {\n        continue;\n      }\n      if (_listener[1] !== useCapture) {\n        continue;\n      }\n      this._listeners.splice(i, 1);\n      return;\n    }\n  };\n\n  EventListeners.prototype.fire = function(event) {\n    var e, listener, listeners, _i, _len, _results;\n    listeners = this.listeners.slice();\n    _results = [];\n    for (_i = 0, _len = listeners.length; _i < _len; _i++) {\n      listener = listeners[_i];\n      listener = listener[0];\n      if (typeof listener === "function") {\n        try {\n          listener.call(null, event);\n        } catch (_error) {\n          e = _error;\n          Weinre.logError("" + arguments.callee.name + " invocation exception: " + e);\n        }\n        continue;\n      }\n      if (typeof (listener != null ? listener.handleEvent : void 0) !== "function") {\n        throw new Ex(arguments, "listener does not implement the handleEvent() method");\n      }\n      try {\n        _results.push(listener.handleEvent.call(listener, event));\n      } catch (_error) {\n        e = _error;\n        _results.push(Weinre.logError("" + arguments.callee.name + " invocation exception: " + e));\n      }\n    }\n    return _results;\n  };\n\n  return EventListeners;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/EventListeners.amd.js'),eval(';modjewel.define("weinre/common/Ex", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Ex, StackTrace, prefix;\n\nStackTrace = require(\'./StackTrace\');\n\nmodule.exports = Ex = (function() {\n  Ex.catching = function(func) {\n    var e;\n    try {\n      return func.call(this);\n    } catch (_error) {\n      e = _error;\n      console.log("runtime error: " + e);\n      return StackTrace.dump(arguments);\n    }\n  };\n\n  function Ex(args, message) {\n    if (!args || !args.callee) {\n      throw Ex(arguments, "first parameter must be an Arguments object");\n    }\n    StackTrace.dump(args);\n    if (message instanceof Error) {\n      message = "threw error: " + message;\n    }\n    message = prefix(args, message);\n    message;\n  }\n\n  return Ex;\n\n})();\n\nprefix = function(args, string) {\n  if (args.callee.signature) {\n    return args.callee.signature + ": " + string;\n  }\n  if (args.callee.displayName) {\n    return args.callee.displayName + ": " + string;\n  }\n  if (args.callee.name) {\n    return args.callee.name + ": " + string;\n  }\n  return "<anonymous>" + ": " + string;\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/Ex.amd.js'),eval(';modjewel.define("weinre/common/HookLib", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar HookLib, HookSite, HookSites, IgnoreHooks, callAfterHooks, callBeforeHooks, callExceptHooks, getHookSite, getHookedFunction;\n\nHookLib = exports;\n\nHookSites = [];\n\nIgnoreHooks = 0;\n\nmodule.exports = HookLib = (function() {\n  function HookLib() {}\n\n  HookLib.addHookSite = function(object, property) {\n    return getHookSite(object, property, true);\n  };\n\n  HookLib.getHookSite = function(object, property) {\n    return getHookSite(object, property, false);\n  };\n\n  HookLib.ignoreHooks = function(func) {\n    var result;\n    try {\n      IgnoreHooks++;\n      result = func.call();\n    } finally {\n      IgnoreHooks--;\n    }\n    return result;\n  };\n\n  return HookLib;\n\n})();\n\ngetHookSite = function(object, property, addIfNotFound) {\n  var hookSite, i, _i, _len;\n  i = 0;\n  for (_i = 0, _len = HookSites.length; _i < _len; _i++) {\n    hookSite = HookSites[_i];\n    if (hookSite.object !== object) {\n      continue;\n    }\n    if (hookSite.property !== property) {\n      continue;\n    }\n    return hookSite;\n  }\n  if (!addIfNotFound) {\n    return null;\n  }\n  hookSite = new HookSite(object, property);\n  HookSites.push(hookSite);\n  return hookSite;\n};\n\nHookSite = (function() {\n  function HookSite(object, property) {\n    var hookedFunction;\n    this.object = object;\n    this.property = property;\n    this.target = object[property];\n    this.hookss = [];\n    if (typeof this.target === \'undefined\') {\n      return;\n    } else {\n      hookedFunction = getHookedFunction(this.target, this);\n      if (!(navigator.userAgent.match(/MSIE/i) && (object === localStorage || object === sessionStorage))) {\n        object[property] = hookedFunction;\n      }\n    }\n  }\n\n  HookSite.prototype.addHooks = function(hooks) {\n    return this.hookss.push(hooks);\n  };\n\n  HookSite.prototype.removeHooks = function(hooks) {\n    var i, _i, _ref;\n    for (i = _i = 0, _ref = this.hookss.length; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {\n      if (this.hookss[i] === hooks) {\n        this.hookss.splice(i, 1);\n        return;\n      }\n    }\n  };\n\n  return HookSite;\n\n})();\n\ngetHookedFunction = function(func, hookSite) {\n  var hookedFunction;\n  hookedFunction = function() {\n    var e, result;\n    callBeforeHooks(hookSite, this, arguments);\n    try {\n      result = func.apply(this, arguments);\n    } catch (_error) {\n      e = _error;\n      callExceptHooks(hookSite, this, arguments, e);\n      throw e;\n    } finally {\n      callAfterHooks(hookSite, this, arguments, result);\n    }\n    return result;\n  };\n  hookedFunction.displayName = func.displayName || func.name;\n  return hookedFunction;\n};\n\ncallBeforeHooks = function(hookSite, receiver, args) {\n  var hooks, _i, _len, _ref, _results;\n  if (IgnoreHooks > 0) {\n    return;\n  }\n  _ref = hookSite.hookss;\n  _results = [];\n  for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n    hooks = _ref[_i];\n    if (hooks.before) {\n      _results.push(hooks.before.call(hooks, receiver, args));\n    } else {\n      _results.push(void 0);\n    }\n  }\n  return _results;\n};\n\ncallAfterHooks = function(hookSite, receiver, args, result) {\n  var hooks, _i, _len, _ref, _results;\n  if (IgnoreHooks > 0) {\n    return;\n  }\n  _ref = hookSite.hookss;\n  _results = [];\n  for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n    hooks = _ref[_i];\n    if (hooks.after) {\n      _results.push(hooks.after.call(hooks, receiver, args, result));\n    } else {\n      _results.push(void 0);\n    }\n  }\n  return _results;\n};\n\ncallExceptHooks = function(hookSite, receiver, args, e) {\n  var hooks, _i, _len, _ref, _results;\n  if (IgnoreHooks > 0) {\n    return;\n  }\n  _ref = hookSite.hookss;\n  _results = [];\n  for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n    hooks = _ref[_i];\n    if (hooks.except) {\n      _results.push(hooks.except.call(hooks, receiver, args, e));\n    } else {\n      _results.push(void 0);\n    }\n  }\n  return _results;\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/HookLib.amd.js'),eval(';modjewel.define("weinre/common/IDGenerator", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar IDGenerator, idName, nextId, nextIdValue;\n\nnextIdValue = 1;\n\nidName = "__weinre__id";\n\nmodule.exports = IDGenerator = (function() {\n  function IDGenerator() {}\n\n  IDGenerator.checkId = function(object) {\n    return object[idName];\n  };\n\n  IDGenerator.getId = function(object, map) {\n    var id;\n    id = IDGenerator.checkId(object);\n    if (!id) {\n      id = nextId();\n      object[idName] = id;\n    }\n    if (map) {\n      map[id] = object;\n    }\n    return id;\n  };\n\n  IDGenerator.next = function() {\n    return nextId();\n  };\n\n  return IDGenerator;\n\n})();\n\nnextId = function() {\n  var result;\n  result = nextIdValue;\n  nextIdValue += 1;\n  return result;\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/IDGenerator.amd.js'),eval(';modjewel.define("weinre/common/IDLTools", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Callback, Ex, IDLTools, IDLs, getProxyMethod;\n\nEx = require(\'./Ex\');\n\nCallback = require(\'./Callback\');\n\nIDLs = {};\n\nmodule.exports = IDLTools = (function() {\n  function IDLTools() {\n    throw new Ex(arguments, "this class is not intended to be instantiated");\n  }\n\n  IDLTools.addIDLs = function(idls) {\n    var idl, intf, _i, _len, _results;\n    _results = [];\n    for (_i = 0, _len = idls.length; _i < _len; _i++) {\n      idl = idls[_i];\n      _results.push((function() {\n        var _j, _len1, _ref, _results1;\n        _ref = idl.interfaces;\n        _results1 = [];\n        for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {\n          intf = _ref[_j];\n          IDLs[intf.name] = intf;\n          _results1.push(intf.module = idl.name);\n        }\n        return _results1;\n      })());\n    }\n    return _results;\n  };\n\n  IDLTools.getIDL = function(name) {\n    return IDLs[name];\n  };\n\n  IDLTools.getIDLsMatching = function(regex) {\n    var intf, intfName, results;\n    results = [];\n    for (intfName in IDLs) {\n      intf = IDLs[intfName];\n      if (intfName.match(regex)) {\n        results.push(intf);\n      }\n    }\n    return results;\n  };\n\n  IDLTools.validateAgainstIDL = function(klass, interfaceName) {\n    var classMethod, error, errors, intf, intfMethod, messagePrefix, printName, propertyName, _i, _j, _len, _len1, _ref, _results;\n    intf = IDLTools.getIDL(interfaceName);\n    messagePrefix = "IDL validation for " + interfaceName + ": ";\n    if (null === intf) {\n      throw new Ex(arguments, messagePrefix + ("idl not found: \'" + interfaceName + "\'"));\n    }\n    errors = [];\n    _ref = intf.methods;\n    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n      intfMethod = _ref[_i];\n      classMethod = klass.prototype[intfMethod.name];\n      printName = klass.name + "::" + intfMethod.name;\n      if (null === classMethod) {\n        errors.push(messagePrefix + ("method not implemented: \'" + printName + "\'"));\n        continue;\n      }\n      if (classMethod.length !== intfMethod.parameters.length) {\n        if (classMethod.length !== intfMethod.parameters.length + 1) {\n          errors.push(messagePrefix + ("wrong number of parameters: \'" + printName + "\'"));\n          continue;\n        }\n      }\n    }\n    for (propertyName in klass.prototype) {\n      if (klass.prototype.hasOwnProperty(propertyName)) {\n        continue;\n      }\n      if (propertyName.match(/^_.*/)) {\n        continue;\n      }\n      printName = klass.name + "::" + propertyName;\n      if (!intf.methods[propertyName]) {\n        errors.push(messagePrefix + ("method should not be implemented: \'" + printName + "\'"));\n        continue;\n      }\n    }\n    if (!errors.length) {\n      return;\n    }\n    _results = [];\n    for (_j = 0, _len1 = errors.length; _j < _len1; _j++) {\n      error = errors[_j];\n      _results.push(require("./Weinre").logError(error));\n    }\n    return _results;\n  };\n\n  IDLTools.buildProxyForIDL = function(proxyObject, interfaceName) {\n    var intf, intfMethod, messagePrefix, _i, _len, _ref, _results;\n    intf = IDLTools.getIDL(interfaceName);\n    messagePrefix = "building proxy for IDL " + interfaceName + ": ";\n    if (null === intf) {\n      throw new Ex(arguments, messagePrefix + ("idl not found: \'" + interfaceName + "\'"));\n    }\n    _ref = intf.methods;\n    _results = [];\n    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n      intfMethod = _ref[_i];\n      _results.push(proxyObject[intfMethod.name] = getProxyMethod(intf, intfMethod));\n    }\n    return _results;\n  };\n\n  return IDLTools;\n\n})();\n\ngetProxyMethod = function(intf, method) {\n  var proxyMethod, result;\n  result = proxyMethod = function() {\n    var args, callbackId;\n    callbackId = null;\n    args = [].slice.call(arguments);\n    if (args.length > 0) {\n      if (typeof args[args.length - 1] === "function") {\n        callbackId = Callback.register(args[args.length - 1]);\n        args = args.slice(0, args.length - 1);\n      }\n    }\n    while (args.length < method.parameters.length) {\n      args.push(null);\n    }\n    args.push(callbackId);\n    return this.__invoke(intf.name, method.name, args);\n  };\n  result.displayName = intf.name + "__" + method.name;\n  return result;\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/IDLTools.amd.js'),eval(';modjewel.define("weinre/common/MessageDispatcher", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Binding, Callback, Ex, IDLTools, InspectorBackend, MessageDispatcher, Verbose, WebSocketXhr, Weinre,\n  __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };\n\nWeinre = require(\'./Weinre\');\n\nWebSocketXhr = require(\'./WebSocketXhr\');\n\nIDLTools = require(\'./IDLTools\');\n\nBinding = require(\'./Binding\');\n\nEx = require(\'./Ex\');\n\nCallback = require(\'./Callback\');\n\nVerbose = false;\n\nInspectorBackend = null;\n\nmodule.exports = MessageDispatcher = (function() {\n  function MessageDispatcher(url, id) {\n    if (!id) {\n      id = "anonymous";\n    }\n    this._url = url;\n    this._id = id;\n    this.error = null;\n    this._opening = false;\n    this._opened = false;\n    this._closed = false;\n    this._interfaces = {};\n    this._open();\n  }\n\n  MessageDispatcher.setInspectorBackend = function(inspectorBackend) {\n    return InspectorBackend = inspectorBackend;\n  };\n\n  MessageDispatcher.verbose = function(value) {\n    if (arguments.length >= 1) {\n      Verbose = !!value;\n    }\n    return Verbose;\n  };\n\n  MessageDispatcher.prototype._open = function() {\n    if (this._opened || this._opening) {\n      return;\n    }\n    if (this._closed) {\n      throw new Ex(arguments, "socket has already been closed");\n    }\n    this._opening = true;\n    this._socket = new WebSocketXhr(this._url, this._id);\n    this._socket.addEventListener("open", Binding(this, "_handleOpen"));\n    this._socket.addEventListener("error", Binding(this, "_handleError"));\n    this._socket.addEventListener("message", Binding(this, "_handleMessage"));\n    return this._socket.addEventListener("close", Binding(this, "_handleClose"));\n  };\n\n  MessageDispatcher.prototype.close = function() {\n    if (this._closed) {\n      return;\n    }\n    this._opened = false;\n    this._closed = true;\n    return this._socket.close();\n  };\n\n  MessageDispatcher.prototype.send = function(data) {\n    return this._socket.send(data);\n  };\n\n  MessageDispatcher.prototype.getWebSocket = function() {\n    return this._socket;\n  };\n\n  MessageDispatcher.prototype.registerInterface = function(intfName, intf, validate) {\n    if (validate) {\n      IDLTools.validateAgainstIDL(intf.constructor, intfName);\n    }\n    if (this._interfaces[intfName]) {\n      throw new Ex(arguments, "interface " + intfName + " has already been registered");\n    }\n    return this._interfaces[intfName] = intf;\n  };\n\n  MessageDispatcher.prototype.createProxy = function(intfName) {\n    var proxy, self, __invoke;\n    proxy = {};\n    IDLTools.buildProxyForIDL(proxy, intfName);\n    self = this;\n    proxy.__invoke = __invoke = function(intfName, methodName, args) {\n      return self._sendMethodInvocation(intfName, methodName, args);\n    };\n    return proxy;\n  };\n\n  MessageDispatcher.prototype._sendMethodInvocation = function(intfName, methodName, args) {\n    var data;\n    if (typeof intfName !== "string") {\n      throw new Ex(arguments, "expecting intf parameter to be a string");\n    }\n    if (typeof methodName !== "string") {\n      throw new Ex(arguments, "expecting method parameter to be a string");\n    }\n    data = {\n      "interface": intfName,\n      method: methodName,\n      args: args\n    };\n    data = JSON.stringify(data);\n    this._socket.send(data);\n    if (Verbose) {\n      return Weinre.logDebug(this.constructor.name + ("[" + this._url + "]: send " + intfName + "." + methodName + "(" + (JSON.stringify(args)) + ")"));\n    }\n  };\n\n  MessageDispatcher.prototype.getState = function() {\n    if (this._opening) {\n      return "opening";\n    }\n    if (this._opened) {\n      return "opened";\n    }\n    if (this._closed) {\n      return "closed";\n    }\n    return "unknown";\n  };\n\n  MessageDispatcher.prototype.isOpen = function() {\n    return this._opened === true;\n  };\n\n  MessageDispatcher.prototype._handleOpen = function(event) {\n    this._opening = false;\n    this._opened = true;\n    this.channel = event.channel;\n    Callback.setConnectorChannel(this.channel);\n    if (Verbose) {\n      return Weinre.logDebug(this.constructor.name + ("[" + this._url + "]: opened"));\n    }\n  };\n\n  MessageDispatcher.prototype._handleError = function(message) {\n    this.error = message;\n    this.close();\n    if (Verbose) {\n      return Weinre.logDebug(this.constructor.name + ("[" + this._url + "]: error: ") + message);\n    }\n  };\n\n  MessageDispatcher.prototype._handleMessage = function(message) {\n    var args, data, e, intf, intfName, method, methodName, methodSignature, skipErrorForMethods;\n    skipErrorForMethods = [\'domContentEventFired\', \'loadEventFired\', \'childNodeRemoved\'];\n    try {\n      data = JSON.parse(message.data);\n    } catch (_error) {\n      e = _error;\n      throw new Ex(arguments, "invalid JSON data received: " + e + ": \'" + message.data + "\'");\n    }\n    intfName = data["interface"];\n    methodName = data.method;\n    args = data.args;\n    methodSignature = "" + intfName + "." + methodName + "()";\n    intf = this._interfaces.hasOwnProperty(intfName) && this._interfaces[intfName];\n    if (!intf && InspectorBackend && intfName.match(/.*Notify/)) {\n      intf = InspectorBackend.getRegisteredDomainDispatcher(intfName.substr(0, intfName.length - 6));\n    }\n    if (!intf) {\n      Weinre.notImplemented("weinre: request for non-registered interface: " + methodSignature);\n      return;\n    }\n    methodSignature = intf.constructor.name + ("." + methodName + "()");\n    method = intf[methodName];\n    if (typeof method !== "function") {\n      Weinre.notImplemented(methodSignature);\n      return;\n    }\n    try {\n      method.apply(intf, args);\n    } catch (_error) {\n      e = _error;\n      if (__indexOf.call(skipErrorForMethods, methodName) < 0) {\n        Weinre.logError(("weinre: invocation exception on " + methodSignature + ": ") + e);\n      }\n    }\n    if (Verbose) {\n      return Weinre.logDebug(this.constructor.name + ("[" + this._url + "]: recv " + intfName + "." + methodName + "(" + (JSON.stringify(args)) + ")"));\n    }\n  };\n\n  MessageDispatcher.prototype._handleClose = function() {\n    this._reallyClosed = true;\n    if (Verbose) {\n      return Weinre.logDebug(this.constructor.name + ("[" + this._url + "]: closed"));\n    }\n  };\n\n  return MessageDispatcher;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/MessageDispatcher.amd.js'),eval(';modjewel.define("weinre/common/MethodNamer", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar MethodNamer,\n  __hasProp = {}.hasOwnProperty;\n\nmodule.exports = MethodNamer = (function() {\n  function MethodNamer() {}\n\n  MethodNamer.setNamesForClass = function(aClass) {\n    var key, val, _ref, _results;\n    for (key in aClass) {\n      if (!__hasProp.call(aClass, key)) continue;\n      val = aClass[key];\n      if (typeof val === "function") {\n        val.signature = "" + aClass.name + "::" + key;\n        val.displayName = key;\n        val.name = key;\n      }\n    }\n    _ref = aClass.prototype;\n    _results = [];\n    for (key in _ref) {\n      if (!__hasProp.call(_ref, key)) continue;\n      val = _ref[key];\n      if (typeof val === "function") {\n        val.signature = "" + aClass.name + "." + key;\n        val.displayName = key;\n        _results.push(val.name = key);\n      } else {\n        _results.push(void 0);\n      }\n    }\n    return _results;\n  };\n\n  return MethodNamer;\n\n})();\n\nMethodNamer.setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/MethodNamer.amd.js'),eval(';modjewel.define("weinre/common/StackTrace", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar StackTrace, getTrace;\n\nmodule.exports = StackTrace = (function() {\n  function StackTrace(args) {\n    if (!args || !args.callee) {\n      throw Error("first parameter to " + arguments.callee.signature + " must be an Arguments object");\n    }\n    this.trace = getTrace(args);\n  }\n\n  StackTrace.dump = function(args) {\n    var stackTrace;\n    args = args || arguments;\n    stackTrace = new StackTrace(args);\n    return stackTrace.dump();\n  };\n\n  StackTrace.prototype.dump = function() {\n    var frame, _i, _len, _ref, _results;\n    console.log("StackTrace:");\n    _ref = this.trace;\n    _results = [];\n    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n      frame = _ref[_i];\n      _results.push(console.log("    " + frame));\n    }\n    return _results;\n  };\n\n  return StackTrace;\n\n})();\n\ngetTrace = function(args) {\n  var err, func, result, visitedFuncs;\n  result = [];\n  visitedFuncs = [];\n  func = args.callee;\n  while (func) {\n    if (func.signature) {\n      result.push(func.signature);\n    } else if (func.displayName) {\n      result.push(func.displayName);\n    } else if (func.name) {\n      result.push(func.name);\n    } else {\n      result.push("<anonymous>");\n    }\n    if (-1 !== visitedFuncs.indexOf(func)) {\n      result.push("... recursion");\n      return result;\n    }\n    visitedFuncs.push(func);\n    try {\n      func = func.caller;\n    } catch (_error) {\n      err = _error;\n      func = null;\n    }\n  }\n  return result;\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/StackTrace.amd.js'),eval(';modjewel.define("weinre/common/WebSocketXhr", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar EventListeners, Ex, HookLib, WebSocketXhr, Weinre, _xhrEventHandler;\n\nEx = require(\'./Ex\');\n\nWeinre = require(\'./Weinre\');\n\nHookLib = require(\'./HookLib\');\n\nEventListeners = require(\'./EventListeners\');\n\nmodule.exports = WebSocketXhr = (function() {\n  WebSocketXhr.CONNECTING = 0;\n\n  WebSocketXhr.OPEN = 1;\n\n  WebSocketXhr.CLOSING = 2;\n\n  WebSocketXhr.CLOSED = 3;\n\n  function WebSocketXhr(url, id) {\n    this.initialize(url, id);\n  }\n\n  WebSocketXhr.prototype.initialize = function(url, id) {\n    if (!id) {\n      id = "anonymous";\n    }\n    this.readyState = WebSocketXhr.CONNECTING;\n    this._url = url;\n    this._id = id;\n    this._urlChannel = null;\n    this._queuedSends = [];\n    this._sendInProgress = true;\n    this._listeners = {\n      open: new EventListeners(),\n      message: new EventListeners(),\n      error: new EventListeners(),\n      close: new EventListeners()\n    };\n    return this._getChannel();\n  };\n\n  WebSocketXhr.prototype._getChannel = function() {\n    var body;\n    body = JSON.stringify({\n      id: this._id\n    });\n    return this._xhr(this._url, "POST", body, this._handleXhrResponseGetChannel);\n  };\n\n  WebSocketXhr.prototype._handleXhrResponseGetChannel = function(xhr) {\n    var e, object;\n    if (xhr.status !== 200) {\n      return this._handleXhrResponseError(xhr);\n    }\n    try {\n      object = JSON.parse(xhr.responseText);\n    } catch (_error) {\n      e = _error;\n      this._fireEventListeners("error", {\n        message: "non-JSON response from channel open request"\n      });\n      this.close();\n      return;\n    }\n    if (!object.channel) {\n      this._fireEventListeners("error", {\n        message: "channel open request did not include a channel"\n      });\n      this.close();\n      return;\n    }\n    this._urlChannel = this._url + "/" + object.channel;\n    this.readyState = WebSocketXhr.OPEN;\n    this._fireEventListeners("open", {\n      message: "open",\n      channel: object.channel\n    });\n    this._sendInProgress = false;\n    this._sendQueued();\n    return this._readLoop();\n  };\n\n  WebSocketXhr.prototype._readLoop = function() {\n    if (this.readyState === WebSocketXhr.CLOSED) {\n      return;\n    }\n    if (this.readyState === WebSocketXhr.CLOSING) {\n      return;\n    }\n    return this._xhr(this._urlChannel, "GET", "", this._handleXhrResponseGet);\n  };\n\n  WebSocketXhr.prototype._handleXhrResponseGet = function(xhr) {\n    var data, datum, e, self, _i, _len, _results;\n    self = this;\n    if (xhr.status !== 200) {\n      return this._handleXhrResponseError(xhr);\n    }\n    try {\n      datum = JSON.parse(xhr.responseText);\n    } catch (_error) {\n      e = _error;\n      this.readyState = WebSocketXhr.CLOSED;\n      this._fireEventListeners("error", {\n        message: "non-JSON response from read request"\n      });\n      return;\n    }\n    HookLib.ignoreHooks(function() {\n      return setTimeout((function() {\n        return self._readLoop();\n      }), 0);\n    });\n    _results = [];\n    for (_i = 0, _len = datum.length; _i < _len; _i++) {\n      data = datum[_i];\n      _results.push(self._fireEventListeners("message", {\n        data: data\n      }));\n    }\n    return _results;\n  };\n\n  WebSocketXhr.prototype.send = function(data) {\n    if (typeof data !== "string") {\n      throw new Ex(arguments, this.constructor.name + ".send");\n    }\n    this._queuedSends.push(data);\n    if (this._sendInProgress) {\n      return;\n    }\n    return this._sendQueued();\n  };\n\n  WebSocketXhr.prototype._sendQueued = function() {\n    var datum;\n    if (this._queuedSends.length === 0) {\n      return;\n    }\n    if (this.readyState === WebSocketXhr.CLOSED) {\n      return;\n    }\n    if (this.readyState === WebSocketXhr.CLOSING) {\n      return;\n    }\n    datum = JSON.stringify(this._queuedSends);\n    this._queuedSends = [];\n    this._sendInProgress = true;\n    return this._xhr(this._urlChannel, "POST", datum, this._handleXhrResponseSend);\n  };\n\n  WebSocketXhr.prototype._handleXhrResponseSend = function(xhr) {\n    var httpSocket;\n    httpSocket = this;\n    if (xhr.status !== 200) {\n      return this._handleXhrResponseError(xhr);\n    }\n    this._sendInProgress = false;\n    return HookLib.ignoreHooks(function() {\n      return setTimeout((function() {\n        return httpSocket._sendQueued();\n      }), 0);\n    });\n  };\n\n  WebSocketXhr.prototype.close = function() {\n    this._sendInProgress = true;\n    this.readyState = WebSocketXhr.CLOSING;\n    this._fireEventListeners("close", {\n      message: "closing",\n      wasClean: true\n    });\n    return this.readyState = WebSocketXhr.CLOSED;\n  };\n\n  WebSocketXhr.prototype.addEventListener = function(type, listener, useCapture) {\n    return this._getListeners(type).add(listener, useCapture);\n  };\n\n  WebSocketXhr.prototype.removeEventListener = function(type, listener, useCapture) {\n    return this._getListeners(type).remove(listener, useCapture);\n  };\n\n  WebSocketXhr.prototype._fireEventListeners = function(type, event) {\n    if (this.readyState === WebSocketXhr.CLOSED) {\n      return;\n    }\n    event.target = this;\n    return this._getListeners(type).fire(event);\n  };\n\n  WebSocketXhr.prototype._getListeners = function(type) {\n    var listeners;\n    listeners = this._listeners[type];\n    if (null === listeners) {\n      throw new Ex(arguments, "invalid event listener type: \'" + type + "\'");\n    }\n    return listeners;\n  };\n\n  WebSocketXhr.prototype._handleXhrResponseError = function(xhr) {\n    if (xhr.status === 404) {\n      this.close();\n      return;\n    }\n    this._fireEventListeners("error", {\n      target: this,\n      status: xhr.status,\n      message: "error from XHR invocation: " + xhr.statusText\n    });\n    return Weinre.logError(("error from XHR invocation: " + xhr.status + ": ") + xhr.statusText);\n  };\n\n  WebSocketXhr.prototype._xhr = function(url, method, data, handler) {\n    var xhr;\n    if (null === handler) {\n      throw new Ex(arguments, "handler must not be null");\n    }\n    xhr = (XMLHttpRequest.noConflict ? new XMLHttpRequest.noConflict() : new XMLHttpRequest());\n    xhr.httpSocket = this;\n    xhr.httpSocketHandler = handler;\n    xhr.onreadystatechange = function() {\n      return _xhrEventHandler(xhr);\n    };\n    HookLib.ignoreHooks(function() {\n      return xhr.open(method, url, true);\n    });\n    xhr.setRequestHeader("Content-Type", "text/plain");\n    return HookLib.ignoreHooks(function() {\n      return xhr.send(data);\n    });\n  };\n\n  return WebSocketXhr;\n\n})();\n\n_xhrEventHandler = function(xhr) {\n  if (xhr.readyState !== 4) {\n    return;\n  }\n  return xhr.httpSocketHandler.call(xhr.httpSocket, xhr);\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/WebSocketXhr.amd.js'),eval(';modjewel.define("weinre/common/Weinre", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar ConsoleLogger, Ex, IDLTools, StackTrace, Weinre, consoleLogger, getLogger, logger, _notImplemented, _showNotImplemented;\n\nEx = require(\'./Ex\');\n\nIDLTools = require(\'./IDLTools\');\n\nStackTrace = require(\'./StackTrace\');\n\n_notImplemented = {};\n\n_showNotImplemented = false;\n\nlogger = null;\n\nmodule.exports = Weinre = (function() {\n  function Weinre() {\n    throw new Ex(arguments, "this class is not intended to be instantiated");\n  }\n\n  Weinre.addIDLs = function(idls) {\n    return IDLTools.addIDLs(idls);\n  };\n\n  Weinre.deprecated = function() {\n    return StackTrace.dump(arguments);\n  };\n\n  Weinre.notImplemented = function(thing) {\n    if (_notImplemented[thing]) {\n      return;\n    }\n    _notImplemented[thing] = true;\n    if (!_showNotImplemented) {\n      return;\n    }\n    return Weinre.logWarning(thing + " not implemented");\n  };\n\n  Weinre.showNotImplemented = function() {\n    var key, _results;\n    _showNotImplemented = true;\n    _results = [];\n    for (key in _notImplemented) {\n      _results.push(Weinre.logWarning(key + " not implemented"));\n    }\n    return _results;\n  };\n\n  Weinre.logError = function(message) {\n    return getLogger().logError(message);\n  };\n\n  Weinre.logWarning = function(message) {\n    return getLogger().logWarning(message);\n  };\n\n  Weinre.logInfo = function(message) {\n    return getLogger().logInfo(message);\n  };\n\n  Weinre.logDebug = function(message) {\n    return getLogger().logDebug(message);\n  };\n\n  return Weinre;\n\n})();\n\nConsoleLogger = (function() {\n  function ConsoleLogger() {}\n\n  ConsoleLogger.prototype.logError = function(message) {\n    return console.log("error: " + message);\n  };\n\n  ConsoleLogger.prototype.logWarning = function(message) {\n    return console.log("warning: " + message);\n  };\n\n  ConsoleLogger.prototype.logInfo = function(message) {\n    return console.log("info: " + message);\n  };\n\n  ConsoleLogger.prototype.logDebug = function(message) {\n    return console.log("debug: " + message);\n  };\n\n  return ConsoleLogger;\n\n})();\n\nconsoleLogger = new ConsoleLogger();\n\ngetLogger = function() {\n  if (logger) {\n    return logger;\n  }\n  if (Weinre.client) {\n    logger = Weinre.WeinreClientCommands;\n    return logger;\n  }\n  if (Weinre.target) {\n    logger = Weinre.WeinreTargetCommands;\n    return logger;\n  }\n  return consoleLogger;\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/common/Weinre.amd.js'),eval(';modjewel.define("weinre/target/BrowserHacks", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar BrowserHacks;\n\nBrowserHacks = function() {\n  if (typeof document.addEventListener === "undefined") {\n    alert("Oops. It seems the page runs in compatibility mode. Please fix it and try again.");\n    return;\n  }\n  if (typeof window.Element === "undefined") {\n    window.Element = function() {};\n  }\n  if (typeof window.Node === "undefined") {\n    window.Node = function() {};\n  }\n  if (!Object.getPrototypeOf) {\n    Object.getPrototypeOf = function(object) {\n      if (!object.__proto__) {\n        throw new Error("This vm does not support __proto__ and getPrototypeOf. Script requires any of them to operate correctly.");\n      }\n      return object.__proto__;\n    };\n  }\n};\n\nBrowserHacks();\n\n});\n\n//@ sourceURL=weinre/target/BrowserHacks.amd.js'),eval(';modjewel.define("weinre/target/CheckForProblems", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar CheckForProblems, checkForOldPrototypeVersion;\n\nmodule.exports = CheckForProblems = (function() {\n  function CheckForProblems() {}\n\n  CheckForProblems.check = function() {\n    return checkForOldPrototypeVersion();\n  };\n\n  return CheckForProblems;\n\n})();\n\ncheckForOldPrototypeVersion = function() {\n  var badVersion;\n  badVersion = false;\n  if (typeof Prototype === "undefined") {\n    return;\n  }\n  if (!Prototype.Version) {\n    return;\n  }\n  if (Prototype.Version.match(/^1\\.5.*/)) {\n    badVersion = true;\n  }\n  if (Prototype.Version.match(/^1\\.6.*/)) {\n    badVersion = true;\n  }\n  if (badVersion) {\n    return alert("Sorry, weinre is not support in versions of Prototype earlier than 1.7");\n  }\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/CheckForProblems.amd.js'),eval(";modjewel.define(\"weinre/target/Console\", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Console, MessageLevel, MessageSource, MessageType, OriginalConsole, RemoteConsole, Timeline, UsingRemote, Weinre;\n\nWeinre = require('../common/Weinre');\n\nTimeline = require('../target/Timeline');\n\nUsingRemote = false;\n\nRemoteConsole = null;\n\nOriginalConsole = null;\n\nMessageSource = {\n  HTML: 0,\n  WML: 1,\n  XML: 2,\n  JS: 3,\n  CSS: 4,\n  Other: 5\n};\n\nMessageType = {\n  Log: 0,\n  Object: 1,\n  Trace: 2,\n  StartGroup: 3,\n  StartGroupCollapsed: 4,\n  EndGroup: 5,\n  Assert: 6,\n  UncaughtException: 7,\n  Result: 8\n};\n\nMessageLevel = {\n  Tip: 0,\n  Log: 1,\n  Warning: 2,\n  Error: 3,\n  Debug: 4\n};\n\nmodule.exports = Console = (function() {\n  function Console() {}\n\n  Object.defineProperty(Console, 'original', {\n    get: function() {\n      return OriginalConsole;\n    }\n  });\n\n  Console.useRemote = function(value) {\n    var oldValue;\n    if (arguments.length === 0) {\n      return UsingRemote;\n    }\n    oldValue = UsingRemote;\n    UsingRemote = !!value;\n    if (UsingRemote) {\n      window.console = RemoteConsole;\n    } else {\n      window.console = OriginalConsole;\n    }\n    return oldValue;\n  };\n\n  Console.prototype._generic = function(level, messageParts) {\n    var message, messagePart, parameters, payload, _i, _len;\n    message = messageParts[0].toString();\n    parameters = [];\n    for (_i = 0, _len = messageParts.length; _i < _len; _i++) {\n      messagePart = messageParts[_i];\n      parameters.push(Weinre.injectedScript.wrapObjectForConsole(messagePart, true));\n    }\n    payload = {\n      source: MessageSource.JS,\n      type: MessageType.Log,\n      level: level,\n      message: message,\n      parameters: parameters\n    };\n    return Weinre.wi.ConsoleNotify.addConsoleMessage(payload);\n  };\n\n  Console.prototype.log = function() {\n    return this._generic(MessageLevel.Log, [].slice.call(arguments));\n  };\n\n  Console.prototype.debug = function() {\n    return this._generic(MessageLevel.Debug, [].slice.call(arguments));\n  };\n\n  Console.prototype.error = function() {\n    return this._generic(MessageLevel.Error, [].slice.call(arguments));\n  };\n\n  Console.prototype.info = function() {\n    return this._generic(MessageLevel.Log, [].slice.call(arguments));\n  };\n\n  Console.prototype.warn = function() {\n    return this._generic(MessageLevel.Warning, [].slice.call(arguments));\n  };\n\n  Console.prototype.dir = function() {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.dirxml = function() {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.trace = function() {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.assert = function(condition) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.count = function() {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.markTimeline = function(message) {\n    return Timeline.addRecord_Mark(message);\n  };\n\n  Console.prototype.lastWMLErrorMessage = function() {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.profile = function(title) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.profileEnd = function(title) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.time = function(title) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.timeEnd = function(title) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.group = function() {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.groupCollapsed = function() {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  Console.prototype.groupEnd = function() {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  return Console;\n\n})();\n\nRemoteConsole = new Console();\n\nOriginalConsole = window.console || {};\n\nRemoteConsole.__original = OriginalConsole;\n\nOriginalConsole.__original = OriginalConsole;\n\nrequire(\"../common/MethodNamer\").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/Console.amd.js"),eval(';modjewel.define("weinre/target/CSSStore", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar CSSStore, IDGenerator, Weinre, _elementMatchesSelector, _fallbackMatchesSelector, _getMappableId, _getMappableObject, _mozMatchesSelector, _msMatchesSelector, _webkitMatchesSelector;\n\nIDGenerator = require(\'../common/IDGenerator\');\n\nWeinre = require(\'../common/Weinre\');\n\n_elementMatchesSelector = null;\n\nmodule.exports = CSSStore = (function() {\n  function CSSStore() {\n    this.styleSheetMap = {};\n    this.styleRuleMap = {};\n    this.styleDeclMap = {};\n    this.testElement = document.createElement("div");\n  }\n\n  CSSStore.prototype.getInlineStyle = function(node) {\n    var cssProperty, styleObject, _i, _len, _ref;\n    styleObject = this._buildMirrorForStyle(node.style, true);\n    _ref = styleObject.cssProperties;\n    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n      cssProperty = _ref[_i];\n      cssProperty.status = "style";\n    }\n    return styleObject;\n  };\n\n  CSSStore.prototype.getComputedStyle = function(node) {\n    var styleObject;\n    if (!node) {\n      return {};\n    }\n    if (node.nodeType !== Node.ELEMENT_NODE) {\n      return {};\n    }\n    styleObject = this._buildMirrorForStyle(window.getComputedStyle(node), false);\n    return styleObject;\n  };\n\n  CSSStore.prototype.getMatchedCSSRules = function(node) {\n    var cssRule, err, object, result, styleSheet, _i, _j, _len, _len1, _ref, _ref1;\n    result = [];\n    try {\n      _ref = document.styleSheets;\n      for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n        styleSheet = _ref[_i];\n        if (!styleSheet.cssRules) {\n          continue;\n        }\n        _ref1 = styleSheet.cssRules;\n        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {\n          cssRule = _ref1[_j];\n          if (!_elementMatchesSelector(node, cssRule.selectorText)) {\n            continue;\n          }\n          object = {};\n          object.ruleId = this._getStyleRuleId(cssRule);\n          object.selectorText = cssRule.selectorText;\n          object.style = this._buildMirrorForStyle(cssRule.style, true);\n          result.push(object);\n        }\n      }\n    } catch (_error) {\n      err = _error;\n      return result;\n    }\n    return result;\n  };\n\n  CSSStore.prototype.getStyleAttributes = function(node) {\n    var result;\n    result = {};\n    return result;\n  };\n\n  CSSStore.prototype.getPseudoElements = function(node) {\n    var result;\n    result = [];\n    return result;\n  };\n\n  CSSStore.prototype.setPropertyText = function(styleId, propertyIndex, text, overwrite) {\n    var compare, i, key, mirror, properties, propertyIndices, propertyMirror, styleDecl;\n    styleDecl = Weinre.cssStore._getStyleDecl(styleId);\n    if (!styleDecl) {\n      Weinre.logWarning("requested style not available: " + styleId);\n      return null;\n    }\n    mirror = styleDecl.__weinre__mirror;\n    if (!mirror) {\n      Weinre.logWarning("requested mirror not available: " + styleId);\n      return null;\n    }\n    properties = mirror.cssProperties;\n    propertyMirror = this._parseProperty(text);\n    if (null === propertyMirror) {\n      this._removePropertyFromMirror(mirror, propertyIndex);\n      properties = mirror.cssProperties;\n    } else {\n      this._removePropertyFromMirror(mirror, propertyIndex);\n      properties = mirror.cssProperties;\n      propertyIndices = {};\n      i = 0;\n      while (i < properties.length) {\n        propertyIndices[properties[i].name] = i;\n        i++;\n      }\n      i = 0;\n      while (i < propertyMirror.cssProperties.length) {\n        if (propertyIndices[propertyMirror.cssProperties[i].name] != null) {\n          properties[propertyIndices[propertyMirror.cssProperties[i].name]] = propertyMirror.cssProperties[i];\n        } else {\n          properties.push(propertyMirror.cssProperties[i]);\n        }\n        i++;\n      }\n      for (key in propertyMirror.shorthandValues) {\n        mirror.shorthandValues[key] = propertyMirror.shorthandValues[key];\n      }\n    }\n    properties.sort(compare = function(p1, p2) {\n      if (p1.name < p2.name) {\n        return -1;\n      } else if (p1.name > p2.name) {\n        return 1;\n      } else {\n        return 0;\n      }\n    });\n    this._setStyleFromMirror(styleDecl);\n    return mirror;\n  };\n\n  CSSStore.prototype._removePropertyFromMirror = function(mirror, index) {\n    var i, newProperties, properties, property;\n    properties = mirror.cssProperties;\n    if (index >= properties.length) {\n      return;\n    }\n    property = properties[index];\n    properties[index] = null;\n    if (mirror.shorthandValues[property.name]) {\n      delete mirror.shorthandValues[property.name];\n      i = 0;\n      while (i < properties.length) {\n        if (properties[i]) {\n          if (properties[i].shorthandName === property.name) {\n            properties[i] = null;\n          }\n        }\n        i++;\n      }\n    }\n    newProperties = [];\n    i = 0;\n    while (i < properties.length) {\n      if (properties[i]) {\n        newProperties.push(properties[i]);\n      }\n      i++;\n    }\n    return mirror.cssProperties = newProperties;\n  };\n\n  CSSStore.prototype.toggleProperty = function(styleId, propertyIndex, disable) {\n    var cssProperty, mirror, styleDecl;\n    styleDecl = Weinre.cssStore._getStyleDecl(styleId);\n    if (!styleDecl) {\n      Weinre.logWarning("requested style not available: " + styleId);\n      return null;\n    }\n    mirror = styleDecl.__weinre__mirror;\n    if (!mirror) {\n      Weinre.logWarning("requested mirror not available: " + styleId);\n      return null;\n    }\n    cssProperty = mirror.cssProperties[propertyIndex];\n    if (!cssProperty) {\n      Weinre.logWarning(("requested property not available: " + styleId + ": ") + propertyIndex);\n      return null;\n    }\n    if (disable) {\n      cssProperty.status = "disabled";\n    } else {\n      cssProperty.status = "active";\n    }\n    this._setStyleFromMirror(styleDecl);\n    return mirror;\n  };\n\n  CSSStore.prototype._setStyleFromMirror = function(styleDecl) {\n    var cssProperties, cssText, property, _i, _len;\n    cssText = [];\n    cssProperties = styleDecl.__weinre__mirror.cssProperties;\n    cssText = "";\n    for (_i = 0, _len = cssProperties.length; _i < _len; _i++) {\n      property = cssProperties[_i];\n      if (!property.parsedOk) {\n        continue;\n      }\n      if (property.status === "disabled") {\n        continue;\n      }\n      if (property.shorthandName) {\n        continue;\n      }\n      cssText += property.name + ": " + property.value;\n      if (property.priority === "important") {\n        cssText += " !important; ";\n      } else {\n        cssText += "; ";\n      }\n    }\n    return styleDecl.cssText = cssText;\n  };\n\n  CSSStore.prototype._buildMirrorForStyle = function(styleDecl, bind) {\n    var i, name, properties, property, result, shorthandName;\n    result = {\n      properties: {},\n      cssProperties: []\n    };\n    if (!styleDecl) {\n      return result;\n    }\n    if (bind) {\n      result.styleId = this._getStyleDeclId(styleDecl);\n      styleDecl.__weinre__mirror = result;\n    }\n    result.properties.width = styleDecl.getPropertyValue("width") || "";\n    result.properties.height = styleDecl.getPropertyValue("height") || "";\n    result.cssText = styleDecl.cssText;\n    result.shorthandValues = {};\n    properties = [];\n    if (styleDecl) {\n      i = 0;\n      while (i < styleDecl.length) {\n        property = {};\n        name = styleDecl.item(i);\n        property.name = name;\n        property.priority = styleDecl.getPropertyPriority(name);\n        property.implicit = typeof styleDecl.isPropertyImplicit !== "undefined" ? styleDecl.isPropertyImplicit(name) : true;\n        property.shorthandName = typeof styleDecl.getPropertyShorthand !== "undefined" ? styleDecl.getPropertyShorthand(name) || "" : "";\n        property.status = (property.shorthandName ? "style" : "active");\n        property.parsedOk = true;\n        property.value = styleDecl.getPropertyValue(name);\n        properties.push(property);\n        if (property.shorthandName) {\n          shorthandName = property.shorthandName;\n          if (!result.shorthandValues[shorthandName]) {\n            result.shorthandValues[shorthandName] = styleDecl.getPropertyValue(shorthandName);\n            property = {};\n            property.name = shorthandName;\n            property.priority = styleDecl.getPropertyPriority(shorthandName);\n            property.implicit = styleDecl.isPropertyImplicit(shorthandName);\n            property.shorthandName = "";\n            property.status = "active";\n            property.parsedOk = true;\n            property.value = styleDecl.getPropertyValue(name);\n            properties.push(property);\n          }\n        }\n        i++;\n      }\n    }\n    properties.sort(function(p1, p2) {\n      if (p1.name < p2.name) {\n        return -1;\n      } else if (p1.name > p2.name) {\n        return 1;\n      } else {\n        return 0;\n      }\n    });\n    result.cssProperties = properties;\n    return result;\n  };\n\n  CSSStore.prototype._parseProperty = function(string) {\n    var match, property, propertyPattern, result, testStyleDecl;\n    testStyleDecl = this.testElement.style;\n    try {\n      testStyleDecl.cssText = string;\n      if (testStyleDecl.cssText !== "") {\n        return this._buildMirrorForStyle(testStyleDecl, false);\n      }\n    } catch (_error) {}\n    propertyPattern = /\\s*(.+)\\s*:\\s*(.+)\\s*(!important)?\\s*;/;\n    match = propertyPattern.exec(string);\n    if (!match) {\n      return null;\n    }\n    match[3] = (match[3] === "!important" ? "important" : "");\n    property = {};\n    property.name = match[1];\n    property.priority = match[3];\n    property.implicit = true;\n    property.shorthandName = "";\n    property.status = "inactive";\n    property.parsedOk = false;\n    property.value = match[2];\n    result = {};\n    result.width = 0;\n    result.height = 0;\n    result.shorthandValues = 0;\n    result.cssProperties = [property];\n    return result;\n  };\n\n  CSSStore.prototype._getStyleSheet = function(id) {\n    return _getMappableObject(id, this.styleSheetMap);\n  };\n\n  CSSStore.prototype._getStyleSheetId = function(styleSheet) {\n    return _getMappableId(styleSheet, this.styleSheetMap);\n  };\n\n  CSSStore.prototype._getStyleRule = function(id) {\n    return _getMappableObject(id, this.styleRuleMap);\n  };\n\n  CSSStore.prototype._getStyleRuleId = function(styleRule) {\n    return _getMappableId(styleRule, this.styleRuleMap);\n  };\n\n  CSSStore.prototype._getStyleDecl = function(id) {\n    return _getMappableObject(id, this.styleDeclMap);\n  };\n\n  CSSStore.prototype._getStyleDeclId = function(styleDecl) {\n    return _getMappableId(styleDecl, this.styleDeclMap);\n  };\n\n  return CSSStore;\n\n})();\n\n_getMappableObject = function(id, map) {\n  return map[id];\n};\n\n_getMappableId = function(object, map) {\n  return IDGenerator.getId(object, map);\n};\n\n_mozMatchesSelector = function(element, selector) {\n  if (!element.mozMatchesSelector) {\n    return false;\n  }\n  return element.mozMatchesSelector(selector);\n};\n\n_webkitMatchesSelector = function(element, selector) {\n  if (!element.webkitMatchesSelector) {\n    return false;\n  }\n  return element.webkitMatchesSelector(selector);\n};\n\n_msMatchesSelector = function(element, selector) {\n  if (!element.msMatchesSelector) {\n    return false;\n  }\n  return element.msMatchesSelector(selector);\n};\n\n_fallbackMatchesSelector = function(element, selector) {\n  return false;\n};\n\nif (Element.prototype.webkitMatchesSelector) {\n  _elementMatchesSelector = _webkitMatchesSelector;\n} else if (Element.prototype.mozMatchesSelector) {\n  _elementMatchesSelector = _mozMatchesSelector;\n} else if (Element.prototype.msMatchesSelector) {\n  _elementMatchesSelector = _msMatchesSelector;\n} else {\n  _elementMatchesSelector = _fallbackMatchesSelector;\n}\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/CSSStore.amd.js'),eval(';modjewel.define("weinre/target/ElementHighlighter", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar ElementHighlighter, canvasAvailable, currentHighlighterElement, fromPx, getMetricsForElement, highlighterClass, supportsCanvas;\n\ncanvasAvailable = null;\n\nhighlighterClass = null;\n\ncurrentHighlighterElement = null;\n\nmodule.exports = ElementHighlighter = (function() {\n  ElementHighlighter.create = function() {\n    if (highlighterClass == null) {\n      highlighterClass = require(\'./ElementHighlighterDivs2\');\n    }\n    return new highlighterClass();\n  };\n\n  function ElementHighlighter() {\n    this.hElement = this.createHighlighterElement();\n    this.hElement.__weinreHighlighter = true;\n    this.hElement.style.display = "none";\n    this.hElement.style.zIndex = 10 * 1000 * 1000;\n    if (currentHighlighterElement) {\n      document.body.removeChild(currentHighlighterElement);\n    }\n    currentHighlighterElement = this.hElement;\n    document.body.appendChild(this.hElement);\n  }\n\n  ElementHighlighter.prototype.on = function(element) {\n    if (null === element) {\n      return;\n    }\n    if (element.nodeType !== Node.ELEMENT_NODE) {\n      return;\n    }\n    this.redraw(getMetricsForElement(element));\n    return this.hElement.style.display = "block";\n  };\n\n  ElementHighlighter.prototype.off = function() {\n    return this.hElement.style.display = "none";\n  };\n\n  return ElementHighlighter;\n\n})();\n\ngetMetricsForElement = function(element) {\n  var cStyle, el, left, metrics, top;\n  metrics = {};\n  left = 0;\n  top = 0;\n  el = element;\n  while (true) {\n    left += el.offsetLeft;\n    top += el.offsetTop;\n    if (!(el = el.offsetParent)) {\n      break;\n    }\n  }\n  metrics.x = left;\n  metrics.y = top;\n  cStyle = document.defaultView.getComputedStyle(element);\n  metrics.width = element.offsetWidth;\n  metrics.height = element.offsetHeight;\n  metrics.marginLeft = fromPx(cStyle["margin-left"] || cStyle["marginLeft"]);\n  metrics.marginRight = fromPx(cStyle["margin-right"] || cStyle["marginRight"]);\n  metrics.marginTop = fromPx(cStyle["margin-top"] || cStyle["marginTop"]);\n  metrics.marginBottom = fromPx(cStyle["margin-bottom"] || cStyle["marginBottom"]);\n  metrics.borderLeft = fromPx(cStyle["border-left-width"] || cStyle["borderLeftWidth"]);\n  metrics.borderRight = fromPx(cStyle["border-right-width"] || cStyle["borderRightWidth"]);\n  metrics.borderTop = fromPx(cStyle["border-top-width"] || cStyle["borderTopWidth"]);\n  metrics.borderBottom = fromPx(cStyle["border-bottom-width"] || cStyle["borderBottomWidth"]);\n  metrics.paddingLeft = fromPx(cStyle["padding-left"] || cStyle["paddingLeft"]);\n  metrics.paddingRight = fromPx(cStyle["padding-right"] || cStyle["paddingRight"]);\n  metrics.paddingTop = fromPx(cStyle["padding-top"] || cStyle["paddingTop"]);\n  metrics.paddingBottom = fromPx(cStyle["padding-bottom"] || cStyle["paddingBottom"]);\n  metrics.x -= metrics.marginLeft;\n  metrics.y -= metrics.marginTop;\n  return metrics;\n};\n\nfromPx = function(string) {\n  return parseInt(string.replace(/px$/, ""));\n};\n\nsupportsCanvas = function() {\n  var element;\n  element = document.createElement(\'canvas\');\n  if (!element.getContext) {\n    return false;\n  }\n  if (element.getContext(\'2d\')) {\n    return true;\n  }\n  return false;\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/ElementHighlighter.amd.js'),eval(";modjewel.define(\"weinre/target/ElementHighlighterDivs2\", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar ColorBorder, ColorContent, ColorMargin, ColorPadding, ElementHighlighter, ElementHighlighterDivs2, px,\n  __hasProp = {}.hasOwnProperty,\n  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };\n\nElementHighlighter = require('./ElementHighlighter');\n\nColorMargin = 'rgba(246, 178, 107, 0.66)';\n\nColorBorder = 'rgba(255, 229, 153, 0.66)';\n\nColorPadding = 'rgba(147, 196, 125, 0.55)';\n\nColorContent = 'rgba(111, 168, 220, 0.66)';\n\nColorBorder = 'rgba(255, 255, 153, 0.40)';\n\nColorPadding = 'rgba(  0, 255,   0, 0.20)';\n\nColorContent = 'rgba(  0,   0, 255, 0.30)';\n\nmodule.exports = ElementHighlighterDivs2 = (function(_super) {\n  __extends(ElementHighlighterDivs2, _super);\n\n  function ElementHighlighterDivs2() {\n    return ElementHighlighterDivs2.__super__.constructor.apply(this, arguments);\n  }\n\n  ElementHighlighterDivs2.prototype.createHighlighterElement = function() {\n    this.hElement1 = document.createElement(\"weinreHighlighter\");\n    this.hElement1.style.position = 'absolute';\n    this.hElement1.style.overflow = 'hidden';\n    this.hElement2 = document.createElement(\"weinreHighlighter\");\n    this.hElement2.style.position = 'absolute';\n    this.hElement2.style.display = 'block';\n    this.hElement2.style.overflow = 'hidden';\n    this.hElement1.appendChild(this.hElement2);\n    this.hElement1.style.borderTopStyle = 'solid';\n    this.hElement1.style.borderLeftStyle = 'solid';\n    this.hElement1.style.borderBottomStyle = 'solid';\n    this.hElement1.style.borderRightStyle = 'solid';\n    this.hElement1.style.borderTopColor = ColorMargin;\n    this.hElement1.style.borderLeftColor = ColorMargin;\n    this.hElement1.style.borderBottomColor = ColorMargin;\n    this.hElement1.style.borderRightColor = ColorMargin;\n    this.hElement1.style.backgroundColor = ColorBorder;\n    this.hElement2.style.borderTopStyle = 'solid';\n    this.hElement2.style.borderLeftStyle = 'solid';\n    this.hElement2.style.borderBottomStyle = 'solid';\n    this.hElement2.style.borderRightStyle = 'solid';\n    this.hElement2.style.borderTopColor = ColorPadding;\n    this.hElement2.style.borderLeftColor = ColorPadding;\n    this.hElement2.style.borderBottomColor = ColorPadding;\n    this.hElement2.style.borderRightColor = ColorPadding;\n    this.hElement2.style.backgroundColor = ColorContent;\n    this.hElement1.style.outline = 'black solid thin';\n    return this.hElement1;\n  };\n\n  ElementHighlighterDivs2.prototype.redraw = function(metrics) {\n    this.hElement1.style.top = px(metrics.y);\n    this.hElement1.style.left = px(metrics.x);\n    this.hElement1.style.height = px(metrics.height);\n    this.hElement1.style.width = px(metrics.width);\n    this.hElement1.style.borderTopWidth = px(metrics.marginTop);\n    this.hElement1.style.borderLeftWidth = px(metrics.marginLeft);\n    this.hElement1.style.borderBottomWidth = px(metrics.marginBottom);\n    this.hElement1.style.borderRightWidth = px(metrics.marginRight);\n    this.hElement2.style.top = px(metrics.borderTop);\n    this.hElement2.style.left = px(metrics.borderLeft);\n    this.hElement2.style.bottom = px(metrics.borderBottom);\n    this.hElement2.style.right = px(metrics.borderRight);\n    this.hElement2.style.borderTopWidth = px(metrics.paddingTop);\n    this.hElement2.style.borderLeftWidth = px(metrics.paddingLeft);\n    this.hElement2.style.borderBottomWidth = px(metrics.paddingBottom);\n    return this.hElement2.style.borderRightWidth = px(metrics.paddingRight);\n  };\n\n  return ElementHighlighterDivs2;\n\n})(ElementHighlighter);\n\npx = function(value) {\n  return \"\" + value + \"px\";\n};\n\nrequire(\"../common/MethodNamer\").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/ElementHighlighterDivs2.amd.js"),eval(';modjewel.define("weinre/target/HookSites", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar HookLib, HookSites;\n\nHookLib = require(\'../common/HookLib\');\n\nmodule.exports = HookSites = (function() {\n  function HookSites() {}\n\n  return HookSites;\n\n})();\n\nHookSites.window_clearInterval = HookLib.addHookSite(window, "clearInterval");\n\nHookSites.window_clearTimeout = HookLib.addHookSite(window, "clearTimeout");\n\nHookSites.window_setInterval = HookLib.addHookSite(window, "setInterval");\n\nHookSites.window_setTimeout = HookLib.addHookSite(window, "setTimeout");\n\nHookSites.window_addEventListener = HookLib.addHookSite(window, "addEventListener");\n\nHookSites.Node_addEventListener = HookLib.addHookSite(Node.prototype, "addEventListener");\n\nHookSites.XMLHttpRequest_open = HookLib.addHookSite(XMLHttpRequest.prototype, "open");\n\nHookSites.XMLHttpRequest_send = HookLib.addHookSite(XMLHttpRequest.prototype, "send");\n\nHookSites.XMLHttpRequest_addEventListener = HookLib.addHookSite(XMLHttpRequest.prototype, "addEventListener");\n\nif (window.openDatabase) {\n  HookSites.window_openDatabase = HookLib.addHookSite(window, "openDatabase");\n}\n\nif (window.localStorage) {\n  HookSites.LocalStorage_setItem = HookLib.addHookSite(window.localStorage, "setItem");\n  HookSites.LocalStorage_removeItem = HookLib.addHookSite(window.localStorage, "removeItem");\n  HookSites.LocalStorage_clear = HookLib.addHookSite(window.localStorage, "clear");\n}\n\nif (window.sessionStorage) {\n  HookSites.SessionStorage_setItem = HookLib.addHookSite(window.sessionStorage, "setItem");\n  HookSites.SessionStorage_removeItem = HookLib.addHookSite(window.sessionStorage, "removeItem");\n  HookSites.SessionStorage_clear = HookLib.addHookSite(window.sessionStorage, "clear");\n}\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/HookSites.amd.js'),eval('var injectedScriptConstructor = \n/*\n * Copyright (C) 2007 Apple Inc.  All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n(function (InjectedScriptHost, inspectedWindow, injectedScriptId) {\n\nfunction bind(thisObject, memberFunction)\n{\n    var func = memberFunction;\n    var args = Array.prototype.slice.call(arguments, 2);\n    function bound()\n    {\n        return func.apply(thisObject, args.concat(Array.prototype.slice.call(arguments, 0)));\n    }\n    bound.toString = function() {\n        return "bound: " + func;\n    };\n    return bound;\n}\n\nvar InjectedScript = function()\n{\n    this._lastBoundObjectId = 1;\n    this._idToWrappedObject = {};\n    this._objectGroups = {};\n}\n\nInjectedScript.prototype = {\n    wrapObjectForConsole: function(object, canAccessInspectedWindow)\n    {\n        if (canAccessInspectedWindow)\n            return this._wrapObject(object, "console");\n        var result = {};\n        result.type = typeof object;\n        result.description = this._toString(object);\n        return result;\n    },\n\n    _wrapObject: function(object, objectGroupName, abbreviate)\n    {\n        try {\n            var objectId;\n            if (typeof object === "object" || typeof object === "function" || this._isHTMLAllCollection(object)) {\n                var id = this._lastBoundObjectId++;\n                this._idToWrappedObject[id] = object;\n    \n                var group = this._objectGroups[objectGroupName];\n                if (!group) {\n                    group = [];\n                    this._objectGroups[objectGroupName] = group;\n                }\n                group.push(id);\n                objectId = { injectedScriptId: injectedScriptId,\n                             id: id,\n                             groupName: objectGroupName };\n            }\n            return InjectedScript.RemoteObject.fromObject(object, objectId, abbreviate);\n        } catch (e) {\n            return InjectedScript.RemoteObject.fromObject("[ Exception: " + e.toString() + " ]");\n        }\n    },\n\n    _parseObjectId: function(objectId)\n    {\n        return eval("(" + objectId + ")");\n    },\n\n    releaseWrapperObjectGroup: function(objectGroupName)\n    {\n        var group = this._objectGroups[objectGroupName];\n        if (!group)\n            return;\n        for (var i = 0; i < group.length; i++)\n            delete this._idToWrappedObject[group[i]];\n        delete this._objectGroups[objectGroupName];\n    },\n\n    dispatch: function(methodName, args)\n    {\n        var argsArray = eval("(" + args + ")");\n        var result = this[methodName].apply(this, argsArray);\n        if (typeof result === "undefined") {\n            inspectedWindow.console.error("Web Inspector error: InjectedScript.%s returns undefined", methodName);\n            result = null;\n        }\n        return result;\n    },\n\n    getProperties: function(objectId, ignoreHasOwnProperty, abbreviate)\n    {\n        var parsedObjectId = this._parseObjectId(objectId);\n        var object = this._objectForId(parsedObjectId);\n\n        if (!this._isDefined(object))\n            return false;\n        var properties = [];\n        var propertyNames;\n\n        // IE returns \'Invalid calling object\' for some of the prototypes, so return the object itself\n        if (window.navigator.userAgent.indexOf("MSIE") != -1 ) {\n            propertyNames = this._getPropertyNames(object);\n        } else\n            propertyNames = ignoreHasOwnProperty ? this._getPropertyNames(object) : Object.getOwnPropertyNames(object);\n\n\n        if (!ignoreHasOwnProperty && object.__proto__)\n            propertyNames.push("__proto__");\n    \n        // Go over properties, prepare results.\n        for (var i = 0; i < propertyNames.length; ++i) {\n            var propertyName = propertyNames[i];\n    \n            var property = {};\n            property.name = propertyName + "";\n            var isGetter = object["__lookupGetter__"] && object.__lookupGetter__(propertyName);\n            if (!isGetter) {\n                try {\n                    property.value = this._wrapObject(object[propertyName], parsedObjectId.groupName, abbreviate);\n                } catch(e) {\n                    property.value = new InjectedScript.RemoteObject.fromException(e);\n                }\n            } else {\n                // FIXME: this should show something like "getter" (bug 16734).\n                property.value = new InjectedScript.RemoteObject.fromObject("\\u2014"); // em dash\n                property.isGetter = true;\n            }\n            properties.push(property);\n        }\n        return properties;\n    },\n\n    setPropertyValue: function(objectId, propertyName, expression)\n    {\n        var parsedObjectId = this._parseObjectId(objectId);\n        var object = this._objectForId(parsedObjectId);\n        if (!this._isDefined(object))\n            return false;\n    \n        var expressionLength = expression.length;\n        if (!expressionLength) {\n            delete object[propertyName];\n            return !(propertyName in object);\n        }\n    \n        try {\n            // Surround the expression in parenthesis so the result of the eval is the result\n            // of the whole expression not the last potential sub-expression.\n    \n            // There is a regression introduced here: eval is now happening against global object,\n            // not call frame while on a breakpoint.\n            // TODO: bring evaluation against call frame back.\n            var result = inspectedWindow.eval("(" + expression + ")");\n            // Store the result in the property.\n            object[propertyName] = result;\n            return true;\n        } catch(e) {\n            try {\n                var result = inspectedWindow.eval("\\"" + expression.replace(/"/g, "\\\\\\"") + "\\"");\n                object[propertyName] = result;\n                return true;\n            } catch(e) {\n                return false;\n            }\n        }\n    },\n\n    _populatePropertyNames: function(object, resultSet)\n    {\n        for (var o = object; o; o = Object.getPrototypeOf(o)) {\n            try {\n                var names = Object.getOwnPropertyNames(o);\n                for (var i = 0; i < names.length; ++i)\n                    resultSet[names[i]] = true;\n            } catch (e) {\n            }\n        }\n    },\n\n    _getPropertyNames: function(object, resultSet)\n    {\n        var propertyNameSet = {};\n        this._populatePropertyNames(object, propertyNameSet);\n        return Object.keys(propertyNameSet);\n    },\n\n    getCompletions: function(expression, includeCommandLineAPI)\n    {\n        var props = {};\n        try {\n            if (!expression)\n                expression = "this";\n            var expressionResult = this._evaluateOn(inspectedWindow.eval, inspectedWindow, expression, false, false);\n\n            if (typeof expressionResult === "object")\n                this._populatePropertyNames(expressionResult, props);\n\n            if (includeCommandLineAPI) {\n                for (var prop in CommandLineAPI.members_)\n                    props[CommandLineAPI.members_[prop]] = true;\n            }\n        } catch(e) {\n        }\n        return props;\n    },\n\n    getCompletionsOnCallFrame: function(callFrameId, expression, includeCommandLineAPI)\n    {\n        var props = {};\n        try {\n            var callFrame = this._callFrameForId(callFrameId);\n            if (!callFrame)\n                return props;\n\n            if (expression) {\n                var expressionResult = this._evaluateOn(callFrame.evaluate, callFrame, expression, true, false);\n                if (typeof expressionResult === "object")\n                    this._populatePropertyNames(expressionResult, props);\n            } else {\n                // Evaluate into properties in scope of the selected call frame.\n                var scopeChain = callFrame.scopeChain;\n                for (var i = 0; i < scopeChain.length; ++i)\n                    this._populatePropertyNames(scopeChain[i], props);\n            }\n    \n            if (includeCommandLineAPI) {\n                for (var prop in CommandLineAPI.members_)\n                    props[CommandLineAPI.members_[prop]] = true;\n            }\n        } catch(e) {\n        }\n        return props;\n    },\n\n    evaluate: function(expression, objectGroup, injectCommandLineAPI)\n    {\n        return this._evaluateAndWrap(inspectedWindow.eval, inspectedWindow, expression, objectGroup, false, injectCommandLineAPI);\n    },\n\n    _evaluateAndWrap: function(evalFunction, object, expression, objectGroup, isEvalOnCallFrame, injectCommandLineAPI)\n    {\n        try {\n            return this._wrapObject(this._evaluateOn(evalFunction, object, expression, isEvalOnCallFrame, injectCommandLineAPI), objectGroup);\n        } catch (e) {\n            return InjectedScript.RemoteObject.fromException(e);\n        }\n    },\n\n    _evaluateOn: function(evalFunction, object, expression, isEvalOnCallFrame, injectCommandLineAPI)\n    {\n        // Only install command line api object for the time of evaluation.\n        // Surround the expression in with statements to inject our command line API so that\n        // the window object properties still take more precedent than our API functions.\n\n        try {\n            if (injectCommandLineAPI && inspectedWindow.console) {\n                inspectedWindow.console._commandLineAPI = new CommandLineAPI(this._commandLineAPIImpl, isEvalOnCallFrame ? object : null);\n                expression = "with ((window && window.console && window.console._commandLineAPI) || {}) {\\n" + expression + "\\n}";\n            }\n\n            var value = evalFunction.call(object, expression);\n\n            // When evaluating on call frame error is not thrown, but returned as a value.\n            if (this._type(value) === "error")\n                throw value.toString();\n\n            return value;\n        } finally {\n            if (injectCommandLineAPI && inspectedWindow.console)\n                delete inspectedWindow.console._commandLineAPI;\n        }\n    },\n\n    getNodeId: function(node)\n    {\n        return InjectedScriptHost.pushNodePathToFrontend(node, false, false);\n    },\n\n    callFrames: function()\n    {\n        var callFrame = InjectedScriptHost.currentCallFrame();\n        if (!callFrame)\n            return false;\n    \n        injectedScript.releaseWrapperObjectGroup("backtrace");\n        var result = [];\n        var depth = 0;\n        do {\n            result.push(new InjectedScript.CallFrameProxy(depth++, callFrame));\n            callFrame = callFrame.caller;\n        } while (callFrame);\n        return result;\n    },\n\n    evaluateOnCallFrame: function(callFrameId, expression, objectGroup, injectCommandLineAPI)\n    {\n        var callFrame = this._callFrameForId(callFrameId);\n        if (!callFrame)\n            return false;\n        return this._evaluateAndWrap(callFrame.evaluate, callFrame, expression, objectGroup, true, injectCommandLineAPI);\n    },\n\n    _callFrameForId: function(callFrameId)\n    {\n        var parsedCallFrameId = eval("(" + callFrameId + ")");\n        var ordinal = parsedCallFrameId.ordinal;\n        var callFrame = InjectedScriptHost.currentCallFrame();\n        while (--ordinal >= 0 && callFrame)\n            callFrame = callFrame.caller;\n        return callFrame;\n    },\n\n    _nodeForId: function(nodeId)\n    {\n        if (!nodeId)\n            return null;\n        return InjectedScriptHost.nodeForId(nodeId);\n    },\n\n    _objectForId: function(objectId)\n    {\n        return this._idToWrappedObject[objectId.id];\n    },\n\n    resolveNode: function(nodeId)\n    {\n        var node = this._nodeForId(nodeId);\n        if (!node)\n            return false;\n        // FIXME: receive the object group from client.\n        return this._wrapObject(node, "prototype");\n    },\n\n    getNodeProperties: function(nodeId, properties)\n    {\n        var node = this._nodeForId(nodeId);\n        if (!node)\n            return false;\n        properties = eval("(" + properties + ")");\n        var result = {};\n        for (var i = 0; i < properties.length; ++i)\n            result[properties[i]] = node[properties[i]];\n        return result;\n    },\n\n    getNodePrototypes: function(nodeId)\n    {\n        this.releaseWrapperObjectGroup("prototypes");\n        var node = this._nodeForId(nodeId);\n        if (!node)\n            return false;\n\n        var result = [];\n        var prototype = node;\n\n//        if (window.navigator.userAgent.indexOf("MSIE") != -1 )\n//        {\n//            result.push(this._wrapObject(prototype, "prototypes"));\n//            return result;\n//        }\n\n        do {\n            result.push(this._wrapObject(prototype, "prototypes"));\n            prototype = Object.getPrototypeOf(prototype);\n        } while (prototype)\n        return result;\n    },\n\n    pushNodeToFrontend: function(objectId)\n    {\n        var parsedObjectId = this._parseObjectId(objectId);\n        var object = this._objectForId(parsedObjectId);\n        if (!object || this._type(object) !== "node")\n            return false;\n        return InjectedScriptHost.pushNodePathToFrontend(object, false, false);\n    },\n\n    evaluateOnSelf: function(funcBody, args)\n    {\n        var func = eval("(" + funcBody + ")");\n        return func.apply(this, eval("(" + args + ")") || []);\n    },\n\n    _isDefined: function(object)\n    {\n        return object || this._isHTMLAllCollection(object);\n    },\n\n    _isHTMLAllCollection: function(object)\n    {\n        // document.all is reported as undefined, but we still want to process it.\n        return (typeof object === "undefined") && inspectedWindow.HTMLAllCollection && object instanceof inspectedWindow.HTMLAllCollection;\n    },\n\n    _type: function(obj)\n    {\n        if (obj === null)\n            return "null";\n\n        var type = typeof obj;\n        if (type !== "object" && type !== "function") {\n            // FIXME(33716): typeof document.all is always \'undefined\'.\n            if (this._isHTMLAllCollection(obj))\n                return "array";\n            return type;\n        }\n\n        // If owning frame has navigated to somewhere else window properties will be undefined.\n        // In this case just return result of the typeof.\n        if (!inspectedWindow.document)\n            return type;\n\n        if (obj instanceof inspectedWindow.Node) {\n\n            try {\n                return (obj.nodeType === undefined ? type : "node");\n            } catch (ex) {} // for IE there could be \'Invalid calling object\' exception\n\n            return obj.toString();\n        }\n\n        if (obj instanceof inspectedWindow.String)\n            return "string";\n        if (obj instanceof inspectedWindow.Array)\n            return "array";\n        if (obj instanceof inspectedWindow.Boolean)\n            return "boolean";\n        if (obj instanceof inspectedWindow.Number)\n            return "number";\n        if (obj instanceof inspectedWindow.Date)\n            return "date";\n        if (obj instanceof inspectedWindow.RegExp)\n            return "regexp";\n        // FireBug\'s array detection.\n        if (isFinite(obj.length) && typeof obj.splice === "function")\n            return "array";\n        if (isFinite(obj.length) && typeof obj.callee === "function") // arguments.\n            return "array";\n        if (obj instanceof inspectedWindow.NodeList)\n            return "array";\n        if (obj instanceof inspectedWindow.HTMLCollection)\n            return "array";\n        if (obj instanceof inspectedWindow.Error)\n            return "error";\n        return type;\n    },\n\n    _describe: function(obj, abbreviated)\n    {\n        var type = this._type(obj);\n\n        switch (type) {\n        case "object":\n        case "node":\n            var result = InjectedScriptHost.internalConstructorName(obj);\n            if (result === "Object") {\n                // In Chromium DOM wrapper prototypes will have Object as their constructor name,\n                // get the real DOM wrapper name from the constructor property.\n                var constructorName = obj.constructor && obj.constructor.name;\n                if (constructorName)\n                    return constructorName;\n            }\n            return result;\n        case "array":\n            var className = InjectedScriptHost.internalConstructorName(obj);\n            if (typeof obj.length === "number")\n                className += "[" + obj.length + "]";\n            return className;\n        case "string":\n            if (!abbreviated)\n                return obj;\n            if (obj.length > 100)\n                return "\\"" + obj.substring(0, 100) + "\\u2026\\"";\n            return "\\"" + obj + "\\"";\n        case "function":\n            var objectText = this._toString(obj);\n            if (abbreviated)\n                objectText = /.*/.exec(objectText)[0].replace(/ +$/g, "");\n            return objectText;\n        default:\n            return this._toString(obj);\n        }\n    },\n\n    _toString: function(obj)\n    {\n        // We don\'t use String(obj) because inspectedWindow.String is undefined if owning frame navigated to another page.\n        return "" + obj;\n    }\n}\n\nvar injectedScript = new InjectedScript();\n\nInjectedScript.RemoteObject = function(objectId, type, description, hasChildren)\n{\n    this.objectId = objectId;\n    this.type = type;\n    this.description = description;\n    this.hasChildren = hasChildren;\n}\n\nInjectedScript.RemoteObject.fromException = function(e)\n{\n    return new InjectedScript.RemoteObject(null, "error", e.toString());\n}\n\nInjectedScript.RemoteObject.fromObject = function(object, objectId, abbreviate)\n{\n    var type = injectedScript._type(object);\n    var rawType = typeof object;\n    var hasChildren = (rawType === "object" && object !== null && (Object.getOwnPropertyNames(object).length || !!Object.getPrototypeOf(object))) || rawType === "function";\n    var description = "";\n    try {\n        var description = injectedScript._describe(object, abbreviate);\n        return new InjectedScript.RemoteObject(objectId, type, description, hasChildren);\n    } catch (e) {\n        return InjectedScript.RemoteObject.fromException(e);\n    }\n}\n\nInjectedScript.CallFrameProxy = function(ordinal, callFrame)\n{\n    this.id = { ordinal: ordinal, injectedScriptId: injectedScriptId };\n    this.type = callFrame.type;\n    this.functionName = (this.type === "function" ? callFrame.functionName : "");\n    this.sourceID = callFrame.sourceID;\n    this.line = callFrame.line;\n    this.column = callFrame.column;\n    this.scopeChain = this._wrapScopeChain(callFrame);\n}\n\nInjectedScript.CallFrameProxy.prototype = {\n    _wrapScopeChain: function(callFrame)\n    {\n        var GLOBAL_SCOPE = 0;\n        var LOCAL_SCOPE = 1;\n        var WITH_SCOPE = 2;\n        var CLOSURE_SCOPE = 3;\n        var CATCH_SCOPE = 4;\n    \n        var scopeChain = callFrame.scopeChain;\n        var scopeChainProxy = [];\n        var foundLocalScope = false;\n        for (var i = 0; i < scopeChain.length; i++) {\n            var scopeType = callFrame.scopeType(i);\n            var scopeObject = scopeChain[i];\n            var scopeObjectProxy = injectedScript._wrapObject(scopeObject, "backtrace", true);\n\n            switch(scopeType) {\n                case LOCAL_SCOPE: {\n                    foundLocalScope = true;\n                    scopeObjectProxy.isLocal = true;\n                    scopeObjectProxy.thisObject = injectedScript._wrapObject(callFrame.thisObject, "backtrace", true);\n                    break;\n                }\n                case CLOSURE_SCOPE: {\n                    scopeObjectProxy.isClosure = true;\n                    break;\n                }\n                case WITH_SCOPE:\n                case CATCH_SCOPE: {\n                    if (foundLocalScope && scopeObject instanceof inspectedWindow.Element)\n                        scopeObjectProxy.isElement = true;\n                    else if (foundLocalScope && scopeObject instanceof inspectedWindow.Document)\n                        scopeObjectProxy.isDocument = true;\n                    else\n                        scopeObjectProxy.isWithBlock = true;\n                    break;\n                }\n            }\n            scopeChainProxy.push(scopeObjectProxy);\n        }\n        return scopeChainProxy;\n    }\n}\n\nfunction CommandLineAPI(commandLineAPIImpl, callFrame)\n{\n    function inScopeVariables(member)\n    {\n        if (!callFrame)\n            return false;\n\n        var scopeChain = callFrame.scopeChain;\n        for (var i = 0; i < scopeChain.length; ++i) {\n            if (member in scopeChain[i])\n                return true;\n        }\n        return false;\n    }\n\n    for (var i = 0; i < CommandLineAPI.members_.length; ++i) {\n        var member = CommandLineAPI.members_[i];\n        if (member in inspectedWindow || inScopeVariables(member))\n            continue;\n\n        this[member] = bind(commandLineAPIImpl, commandLineAPIImpl[member]);\n    }\n\n    for (var i = 0; i < 5; ++i) {\n        var member = "$" + i;\n        if (member in inspectedWindow || inScopeVariables(member))\n            continue;\n\n        // fix for non-webkit browsers\n        //this.__defineGetter__("$" + i, bind(commandLineAPIImpl, commandLineAPIImpl._inspectedNode, i));\n        Object.defineProperty(this, "$" + i, {\n            get: bind(commandLineAPIImpl, commandLineAPIImpl._inspectedNode, i)\n        });\n    }\n}\n\nCommandLineAPI.members_ = [\n    "$", "$$", "$x", "dir", "dirxml", "keys", "values", "profile", "profileEnd",\n    "monitorEvents", "unmonitorEvents", "inspect", "copy", "clear"\n];\n\nfunction CommandLineAPIImpl()\n{\n}\n\nCommandLineAPIImpl.prototype = {\n    $: function()\n    {\n        return document.getElementById.apply(document, arguments)\n    },\n\n    $$: function()\n    {\n        return document.querySelectorAll.apply(document, arguments)\n    },\n\n    $x: function(xpath, context)\n    {\n        var nodes = [];\n        try {\n            var doc = (context && context.ownerDocument) || inspectedWindow.document;\n            var results = doc.evaluate(xpath, context || doc, null, XPathResult.ANY_TYPE, null);\n            var node;\n            while (node = results.iterateNext())\n                nodes.push(node);\n        } catch (e) {\n        }\n        return nodes;\n    },\n\n    dir: function()\n    {\n        return console.dir.apply(console, arguments)\n    },\n\n    dirxml: function()\n    {\n        return console.dirxml.apply(console, arguments)\n    },\n\n    keys: function(object)\n    {\n        return Object.keys(object);\n    },\n\n    values: function(object)\n    {\n        var result = [];\n        for (var key in object)\n            result.push(object[key]);\n        return result;\n    },\n\n    profile: function()\n    {\n        return console.profile.apply(console, arguments)\n    },\n\n    profileEnd: function()\n    {\n        return console.profileEnd.apply(console, arguments)\n    },\n\n    monitorEvents: function(object, types)\n    {\n        if (!object || !object.addEventListener || !object.removeEventListener)\n            return;\n        types = this._normalizeEventTypes(types);\n        for (var i = 0; i < types.length; ++i) {\n            object.removeEventListener(types[i], this._logEvent, false);\n            object.addEventListener(types[i], this._logEvent, false);\n        }\n    },\n\n    unmonitorEvents: function(object, types)\n    {\n        if (!object || !object.addEventListener || !object.removeEventListener)\n            return;\n        types = this._normalizeEventTypes(types);\n        for (var i = 0; i < types.length; ++i)\n            object.removeEventListener(types[i], this._logEvent, false);\n    },\n\n    inspect: function(object)\n    {\n        if (arguments.length === 0)\n            return;\n\n        inspectedWindow.console.log(object);\n        if (injectedScript._type(object) === "node")\n            InjectedScriptHost.pushNodePathToFrontend(object, false, true);\n        else {\n            switch (injectedScript._describe(object)) {\n                case "Database":\n                    InjectedScriptHost.selectDatabase(object);\n                    break;\n                case "Storage":\n                    InjectedScriptHost.selectDOMStorage(object);\n                    break;\n            }\n        }\n    },\n\n    copy: function(object)\n    {\n        if (injectedScript._type(object) === "node")\n            object = object.outerHTML;\n        InjectedScriptHost.copyText(object);\n    },\n\n    clear: function()\n    {\n        InjectedScriptHost.clearConsoleMessages();\n    },\n\n    _inspectedNode: function(num)\n    {\n        var nodeId = InjectedScriptHost.inspectedNode(num);\n        return injectedScript._nodeForId(nodeId);\n    },\n\n    _normalizeEventTypes: function(types)\n    {\n        if (typeof types === "undefined")\n            types = [ "mouse", "key", "load", "unload", "abort", "error", "select", "change", "submit", "reset", "focus", "blur", "resize", "scroll" ];\n        else if (typeof types === "string")\n            types = [ types ];\n\n        var result = [];\n        for (var i = 0; i < types.length; i++) {\n            if (types[i] === "mouse")\n                result.splice(0, 0, "mousedown", "mouseup", "click", "dblclick", "mousemove", "mouseover", "mouseout");\n            else if (types[i] === "key")\n                result.splice(0, 0, "keydown", "keyup", "keypress");\n            else\n                result.push(types[i]);\n        }\n        return result;\n    },\n\n    _logEvent: function(event)\n    {\n        console.log(event.type, event);\n    }\n}\n\ninjectedScript._commandLineAPIImpl = new CommandLineAPIImpl();\nreturn injectedScript;\n})\n//@ sourceURL=weinre/target/InjectedScript.js'),eval(';modjewel.define("weinre/target/InjectedScriptHostImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar InjectedScriptHostImpl, Weinre;\n\nWeinre = require(\'../common/Weinre\');\n\nmodule.exports = InjectedScriptHostImpl = (function() {\n  function InjectedScriptHostImpl() {}\n\n  InjectedScriptHostImpl.prototype.clearConsoleMessages = function(callback) {\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  InjectedScriptHostImpl.prototype.nodeForId = function(nodeId, callback) {\n    return Weinre.nodeStore.getNode(nodeId);\n  };\n\n  InjectedScriptHostImpl.prototype.pushNodePathToFrontend = function(node, withChildren, selectInUI, callback) {\n    var children, nodeId;\n    nodeId = Weinre.nodeStore.getNodeId(node);\n    children = Weinre.nodeStore.serializeNode(node, 1);\n    Weinre.wi.DOMNotify.setChildNodes(nodeId, children);\n    if (callback) {\n      Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n    if (selectInUI) {\n      return Weinre.wi.InspectorNotify.updateFocusedNode(nodeId);\n    }\n  };\n\n  InjectedScriptHostImpl.prototype.inspectedNode = function(num, callback) {\n    var nodeId;\n    nodeId = Weinre.nodeStore.getInspectedNode(num);\n    return nodeId;\n  };\n\n  InjectedScriptHostImpl.prototype.internalConstructorName = function(object) {\n    var ctor, ctorName, match, pattern;\n    ctor = object.constructor;\n    ctorName = ctor.fullClassName || ctor.displayName || ctor.name;\n    if (ctorName && (ctorName !== "Object")) {\n      return ctorName;\n    }\n    pattern = /\\[object (.*)\\]/;\n    match = pattern.exec(object.toString());\n    if (match) {\n      return match[1];\n    }\n    return "Object";\n  };\n\n  return InjectedScriptHostImpl;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/InjectedScriptHostImpl.amd.js'),eval(';modjewel.define("weinre/target/NetworkRequest", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Ex, HookLib, HookSites, IDGenerator, Loader, NetworkRequest, StackTrace, Weinre, getFormData, getHeaders, getRequest, getResponse, getXhrEventHandler, splitContentType, trim;\n\nStackTrace = require(\'../common/StackTrace\');\n\nIDGenerator = require(\'../common/IDGenerator\');\n\nHookLib = require(\'../common/HookLib\');\n\nWeinre = require(\'../common/Weinre\');\n\nEx = require(\'../common/Ex\');\n\nHookSites = require(\'./HookSites\');\n\nLoader = {\n  url: window.location.href,\n  frameId: 0,\n  loaderId: 0\n};\n\nmodule.exports = NetworkRequest = (function() {\n  function NetworkRequest(xhr, id, method, url, stackTrace) {\n    this.xhr = xhr;\n    this.id = id;\n    this.method = method;\n    this.url = url;\n    this.stackTrace = stackTrace;\n  }\n\n  NetworkRequest.prototype.handleSend = function(data) {\n    var redirectResponse, request, time;\n    Weinre.wi.NetworkNotify.identifierForInitialRequest(this.id, this.url, Loader, this.stackTrace);\n    time = Date.now() / 1000.0;\n    request = getRequest(this.url, this.method, this.xhr, data);\n    redirectResponse = {\n      isNull: true\n    };\n    return Weinre.wi.NetworkNotify.willSendRequest(this.id, time, request, redirectResponse);\n  };\n\n  NetworkRequest.prototype.handleHeadersReceived = function() {\n    var response, time;\n    time = Date.now() / 1000.0;\n    response = getResponse(this.xhr);\n    return Weinre.wi.NetworkNotify.didReceiveResponse(this.id, time, "XHR", response);\n  };\n\n  NetworkRequest.prototype.handleLoading = function() {};\n\n  NetworkRequest.prototype.handleDone = function() {\n    var description, e, sourceString, status, statusText, success, time;\n    sourceString = "";\n    try {\n      sourceString = this.xhr.responseText;\n    } catch (_error) {\n      e = _error;\n    }\n    Weinre.wi.NetworkNotify.setInitialContent(this.id, sourceString, "XHR");\n    time = Date.now() / 1000.0;\n    status = this.xhr.status;\n    if (status === 0) {\n      status = 200;\n    }\n    statusText = this.xhr.statusText;\n    success = status >= 200 && status < 300;\n    if (success) {\n      return Weinre.wi.NetworkNotify.didFinishLoading(this.id, time);\n    } else {\n      description = "" + status + " - " + statusText;\n      return Weinre.wi.NetworkNotify.didFailLoading(this.id, time, description);\n    }\n  };\n\n  NetworkRequest.installNativeHooks = function() {\n    HookSites.XMLHttpRequest_open.addHooks({\n      before: function(receiver, args) {\n        var frame, id, method, rawStackTrace, stackTrace, url, xhr, _i, _len;\n        xhr = receiver;\n        method = args[0];\n        url = args[1];\n        id = IDGenerator.next();\n        rawStackTrace = new StackTrace(args).trace.slice(1);\n        stackTrace = [];\n        for (_i = 0, _len = rawStackTrace.length; _i < _len; _i++) {\n          frame = rawStackTrace[_i];\n          stackTrace.push({\n            functionName: frame\n          });\n        }\n        xhr.__weinreNetworkRequest__ = new NetworkRequest(xhr, id, method, url, stackTrace);\n        return HookLib.ignoreHooks(function() {\n          return xhr.addEventListener("readystatechange", getXhrEventHandler(xhr), false);\n        });\n      }\n    });\n    return HookSites.XMLHttpRequest_send.addHooks({\n      before: function(receiver, args) {\n        var data, nr, xhr;\n        xhr = receiver;\n        data = args[0];\n        nr = xhr.__weinreNetworkRequest__;\n        if (!nr) {\n          return;\n        }\n        return nr.handleSend(data);\n      }\n    });\n  };\n\n  return NetworkRequest;\n\n})();\n\ngetRequest = function(url, method, xhr, data) {\n  return {\n    url: url,\n    httpMethod: method,\n    httpHeaderFields: {},\n    requestFormData: getFormData(url, data)\n  };\n};\n\ngetResponse = function(xhr) {\n  var contentLength, contentType, encoding, headers, result, _ref;\n  contentType = xhr.getResponseHeader("Content-Type");\n  contentType || (contentType = \'application/octet-stream\');\n  _ref = splitContentType(contentType), contentType = _ref[0], encoding = _ref[1];\n  headers = getHeaders(xhr);\n  result = {\n    mimeType: contentType,\n    textEncodingName: encoding,\n    httpStatusCode: xhr.status,\n    httpStatusText: xhr.statusText,\n    httpHeaderFields: headers,\n    connectionReused: false,\n    connectionID: 0,\n    wasCached: false\n  };\n  contentLength = xhr.getResponseHeader("Content-Length");\n  contentLength = parseInt(contentLength);\n  if (!isNaN(contentLength)) {\n    result.expectedContentLength = contentLength;\n  }\n  return result;\n};\n\ngetHeaders = function(xhr) {\n  var key, line, lines, result, string, val, _i, _len, _ref;\n  string = xhr.getAllResponseHeaders();\n  lines = string.split(\'\\r\\n\');\n  result = {};\n  for (_i = 0, _len = lines.length; _i < _len; _i++) {\n    line = lines[_i];\n    line = trim(line);\n    if (line === "") {\n      break;\n    }\n    _ref = line.split(\':\', 2), key = _ref[0], val = _ref[1];\n    result[trim(key)] = trim(val);\n  }\n  return result;\n};\n\ntrim = function(string) {\n  return string.replace(/^\\s+|\\s+$/g, \'\');\n};\n\ngetFormData = function(url, data) {\n  var match, pattern;\n  if (data) {\n    return data;\n  }\n  pattern = /.*?\\?(.*?)(#.*)?$/;\n  match = url.match(pattern);\n  if (match) {\n    return match[1];\n  }\n  return "";\n};\n\nsplitContentType = function(contentType) {\n  var match, pattern;\n  pattern = /\\s*(.*?)\\s*(;\\s*(.*))?\\s*$/;\n  match = contentType.match(pattern);\n  if (!match) {\n    return [contentType, ""];\n  }\n  return [match[1], match[3]];\n};\n\ngetXhrEventHandler = function(xhr) {\n  return function() {\n    var e, nr;\n    nr = xhr.__weinreNetworkRequest__;\n    if (!nr) {\n      return;\n    }\n    try {\n      switch (xhr.readyState) {\n        case 2:\n          return nr.handleHeadersReceived();\n        case 3:\n          return nr.handleLoading();\n        case 4:\n          return nr.handleDone();\n      }\n    } catch (_error) {\n      e = _error;\n    }\n  };\n};\n\n});\n\n//@ sourceURL=weinre/target/NetworkRequest.amd.js'),eval(';modjewel.define("weinre/target/NodeStore", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Debug, IDGenerator, NodeStore, Weinre, handleDOMAttrModified, handleDOMCharacterDataModified, handleDOMNodeInserted, handleDOMNodeRemoved, handleDOMSubtreeModified;\n\nWeinre = require(\'../common/Weinre\');\n\nIDGenerator = require(\'../common/IDGenerator\');\n\nDebug = require(\'../common/Debug\');\n\nmodule.exports = NodeStore = (function() {\n  function NodeStore() {\n    this._nodeMap = {};\n    this._childrenSent = {};\n    this._inspectedNodes = [];\n    document.addEventListener("DOMSubtreeModified", handleDOMSubtreeModified, false);\n    document.addEventListener("DOMNodeInserted", handleDOMNodeInserted, false);\n    document.addEventListener("DOMNodeRemoved", handleDOMNodeRemoved, false);\n    document.addEventListener("DOMAttrModified", handleDOMAttrModified, false);\n    document.addEventListener("DOMCharacterDataModified", handleDOMCharacterDataModified, false);\n  }\n\n  NodeStore.prototype.addInspectedNode = function(nodeId) {\n    this._inspectedNodes.unshift(nodeId);\n    if (this._inspectedNodes.length > 5) {\n      return this._inspectedNodes = this._inspectedNodes.slice(0, 5);\n    }\n  };\n\n  NodeStore.prototype.getInspectedNode = function(index) {\n    return this._inspectedNodes[index];\n  };\n\n  NodeStore.prototype.getNode = function(nodeId) {\n    return this._nodeMap[nodeId];\n  };\n\n  NodeStore.prototype.checkNodeId = function(node) {\n    return IDGenerator.checkId(node);\n  };\n\n  NodeStore.prototype.getNodeId = function(node) {\n    var id;\n    id = this.checkNodeId(node);\n    if (id) {\n      return id;\n    }\n    return IDGenerator.getId(node, this._nodeMap);\n  };\n\n  NodeStore.prototype.getNodeData = function(nodeId, depth) {\n    return this.serializeNode(this.getNode(nodeId), depth);\n  };\n\n  NodeStore.prototype.getPreviousSiblingId = function(node) {\n    var id, sib;\n    while (true) {\n      sib = node.previousSibling;\n      if (!sib) {\n        return 0;\n      }\n      id = this.checkNodeId(sib);\n      if (id) {\n        return id;\n      }\n      node = sib;\n    }\n  };\n\n  NodeStore.prototype.nextNodeId = function() {\n    return "" + IDGenerator.next();\n  };\n\n  NodeStore.prototype.serializeNode = function(node, depth) {\n    var children, i, id, localName, nodeData, nodeName, nodeValue;\n    nodeName = "";\n    nodeValue = null;\n    localName = null;\n    id = this.getNodeId(node);\n    switch (node.nodeType) {\n      case Node.TEXT_NODE:\n      case Node.COMMENT_NODE:\n      case Node.CDATA_SECTION_NODE:\n        nodeValue = node.nodeValue;\n        break;\n      case Node.ATTRIBUTE_NODE:\n        localName = node.localName;\n        break;\n      case Node.DOCUMENT_FRAGMENT_NODE:\n        break;\n      default:\n        nodeName = node.nodeName;\n        localName = node.localName;\n    }\n    nodeData = {\n      id: id,\n      nodeType: node.nodeType,\n      nodeName: nodeName,\n      localName: localName,\n      nodeValue: nodeValue\n    };\n    if (node.nodeType === Node.ELEMENT_NODE || node.nodeType === Node.DOCUMENT_NODE || node.nodeType === Node.DOCUMENT_FRAGMENT_NODE) {\n      nodeData.childNodeCount = this.childNodeCount(node);\n      children = this.serializeNodeChildren(node, depth);\n      if (children.length) {\n        nodeData.children = children;\n      }\n      if (node.nodeType === Node.ELEMENT_NODE) {\n        nodeData.attributes = [];\n        i = 0;\n        while (i < node.attributes.length) {\n          nodeData.attributes.push(node.attributes[i].nodeName);\n          nodeData.attributes.push(node.attributes[i].nodeValue);\n          i++;\n        }\n      } else {\n        if (node.nodeType === Node.DOCUMENT_NODE) {\n          nodeData.documentURL = window.location.href;\n        }\n      }\n    } else if (node.nodeType === Node.DOCUMENT_TYPE_NODE) {\n      nodeData.publicId = node.publicId;\n      nodeData.systemId = node.systemId;\n      nodeData.internalSubset = node.internalSubset;\n    } else if (node.nodeType === Node.ATTRIBUTE_NODE) {\n      nodeData.name = node.nodeName;\n      nodeData.value = node.nodeValue;\n    }\n    return nodeData;\n  };\n\n  NodeStore.prototype.serializeNodeChildren = function(node, depth) {\n    var childIds, childNode, i, result;\n    result = [];\n    childIds = this.childNodeIds(node);\n    if (depth === 0) {\n      if (childIds.length === 1) {\n        childNode = this.getNode(childIds[0]);\n        if (childNode.nodeType === Node.TEXT_NODE) {\n          result.push(this.serializeNode(childNode));\n        }\n      }\n      return result;\n    }\n    depth--;\n    i = 0;\n    while (i < childIds.length) {\n      result.push(this.serializeNode(this.getNode(childIds[i]), depth));\n      i++;\n    }\n    return result;\n  };\n\n  NodeStore.prototype.childNodeCount = function(node) {\n    return this.childNodeIds(node).length;\n  };\n\n  NodeStore.prototype.childNodeIds = function(node) {\n    var childNode, i, ids, _i, _len, _ref;\n    ids = [];\n    i = 0;\n    _ref = node.childNodes;\n    for (_i = 0, _len = _ref.length; _i < _len; _i++) {\n      childNode = _ref[_i];\n      if (this.isToBeSkipped(childNode)) {\n        continue;\n      }\n      ids.push(this.getNodeId(childNode));\n    }\n    return ids;\n  };\n\n  NodeStore.prototype.isToBeSkipped = function(node) {\n    if (!node) {\n      return true;\n    }\n    if (node.__weinreHighlighter) {\n      return true;\n    }\n    if (node.nodeType !== Node.TEXT_NODE) {\n      return false;\n    }\n    return !!node.nodeValue.match(/^\\s*$/);\n  };\n\n  return NodeStore;\n\n})();\n\nhandleDOMSubtreeModified = function(event) {\n  if (!event.attrChange) {\n    return;\n  }\n  return NodeStore.handleDOMAttrModified(event);\n};\n\nhandleDOMNodeInserted = function(event) {\n  var child, parentId, previous, targetId;\n  targetId = Weinre.nodeStore.checkNodeId(event.target);\n  parentId = Weinre.nodeStore.checkNodeId(event.relatedNode);\n  if (!parentId) {\n    return;\n  }\n  child = Weinre.nodeStore.serializeNode(event.target, 0);\n  previous = Weinre.nodeStore.getPreviousSiblingId(event.target);\n  return Weinre.wi.DOMNotify.childNodeInserted(parentId, previous, child);\n};\n\nhandleDOMNodeRemoved = function(event) {\n  var childCount, parentId, targetId;\n  targetId = Weinre.nodeStore.checkNodeId(event.target);\n  parentId = Weinre.nodeStore.checkNodeId(event.relatedNode);\n  if (!parentId) {\n    return;\n  }\n  if (targetId) {\n    if (parentId) {\n      return Weinre.wi.DOMNotify.childNodeRemoved(parentId, targetId);\n    }\n  } else {\n    childCount = Weinre.nodeStore.childNodeCount(event.relatedNode);\n    return Weinre.wi.DOMNotify.childNodeCountUpdated(parentId, childCount);\n  }\n};\n\nhandleDOMAttrModified = function(event) {\n  var attrs, i, targetId;\n  targetId = Weinre.nodeStore.checkNodeId(event.target);\n  if (!targetId) {\n    return;\n  }\n  attrs = [];\n  i = 0;\n  while (i < event.target.attributes.length) {\n    attrs.push(event.target.attributes[i].name);\n    attrs.push(event.target.attributes[i].value);\n    i++;\n  }\n  return Weinre.wi.DOMNotify.attributesUpdated(targetId, attrs);\n};\n\nhandleDOMCharacterDataModified = function(event) {\n  var targetId;\n  targetId = Weinre.nodeStore.checkNodeId(event.target);\n  if (!targetId) {\n    return;\n  }\n  return Weinre.wi.DOMNotify.characterDataModified(targetId, event.newValue);\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/NodeStore.amd.js'),eval(';modjewel.define("weinre/target/SqlStepper", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Binding, SqlStepper, executeSql, ourErrorCallback, runStep;\n\nBinding = require(\'../common/Binding\');\n\nmodule.exports = SqlStepper = (function() {\n  function SqlStepper(steps) {\n    var context;\n    if (!(this instanceof SqlStepper)) {\n      return new SqlStepper(steps);\n    }\n    this.__context = {};\n    context = this.__context;\n    context.steps = steps;\n  }\n\n  SqlStepper.prototype.run = function(db, errorCallback) {\n    var context;\n    context = this.__context;\n    if (context.hasBeenRun) {\n      throw new Ex(arguments, "stepper has already been run");\n    }\n    context.hasBeenRun = true;\n    context.db = db;\n    context.errorCallback = errorCallback;\n    context.nextStep = 0;\n    context.ourErrorCallback = new Binding(this, ourErrorCallback);\n    context.runStep = new Binding(this, runStep);\n    this.executeSql = new Binding(this, executeSql);\n    return db.transaction(context.runStep);\n  };\n\n  SqlStepper.example = function(db, id) {\n    var errorCb, step1, step2, stepper;\n    step1 = function() {\n      return this.executeSql("SELECT name FROM sqlite_master WHERE type=\'table\'");\n    };\n    step2 = function(resultSet) {\n      var i, name, result, rows;\n      rows = resultSet.rows;\n      result = [];\n      i = 0;\n      while (i < rows.length) {\n        name = rows.item(i).name;\n        if (name === "__WebKitDatabaseInfoTable__") {\n          i++;\n          continue;\n        }\n        result.push(name);\n        i++;\n      }\n      return console.log(("[" + this.id + "] table names: ") + result.join(", "));\n    };\n    errorCb = function(sqlError) {\n      return console.log(("[" + this.id + "] sql error:" + sqlError.code + ": ") + sqlError.message);\n    };\n    stepper = new SqlStepper([step1, step2]);\n    stepper.id = id;\n    return stepper.run(db, errorCb);\n  };\n\n  return SqlStepper;\n\n})();\n\nexecuteSql = function(statement, data) {\n  var context;\n  context = this.__context;\n  return context.tx.executeSql(statement, data, context.runStep, context.ourErrorCallback);\n};\n\nourErrorCallback = function(tx, sqlError) {\n  var context;\n  context = this.__context;\n  return context.errorCallback.call(this, sqlError);\n};\n\nrunStep = function(tx, resultSet) {\n  var context, step;\n  context = this.__context;\n  if (context.nextStep >= context.steps.length) {\n    return;\n  }\n  context.tx = tx;\n  context.currentStep = context.nextStep;\n  context.nextStep++;\n  step = context.steps[context.currentStep];\n  return step.call(this, resultSet);\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/SqlStepper.amd.js'),eval(';modjewel.define("weinre/target/Target", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Binding, CSSStore, Callback, CheckForProblems, ElementHighlighter, Ex, HookLib, InjectedScriptHostImpl, MessageDispatcher, NetworkRequest, NodeStore, Target, Weinre, WeinreExtraClientCommandsImpl, WeinreTargetEventsImpl, WiCSSImpl, WiConsoleImpl, WiDOMImpl, WiDOMStorageImpl, WiDatabaseImpl, WiInspectorImpl, WiRuntimeImpl, currentTime;\n\nrequire(\'./BrowserHacks\');\n\nEx = require(\'../common/Ex\');\n\nBinding = require(\'../common/Binding\');\n\nCallback = require(\'../common/Callback\');\n\nMessageDispatcher = require(\'../common/MessageDispatcher\');\n\nWeinre = require(\'../common/Weinre\');\n\nHookLib = require(\'../common/HookLib\');\n\nCheckForProblems = require(\'./CheckForProblems\');\n\nNodeStore = require(\'./NodeStore\');\n\nCSSStore = require(\'./CSSStore\');\n\nElementHighlighter = require(\'./ElementHighlighter\');\n\nInjectedScriptHostImpl = require(\'./InjectedScriptHostImpl\');\n\nNetworkRequest = require(\'./NetworkRequest\');\n\nWeinreTargetEventsImpl = require(\'./WeinreTargetEventsImpl\');\n\nWeinreExtraClientCommandsImpl = require(\'./WeinreExtraClientCommandsImpl\');\n\nWiConsoleImpl = require(\'./WiConsoleImpl\');\n\nWiCSSImpl = require(\'./WiCSSImpl\');\n\nWiDatabaseImpl = require(\'./WiDatabaseImpl\');\n\nWiDOMImpl = require(\'./WiDOMImpl\');\n\nWiDOMStorageImpl = require(\'./WiDOMStorageImpl\');\n\nWiInspectorImpl = require(\'./WiInspectorImpl\');\n\nWiRuntimeImpl = require(\'./WiRuntimeImpl\');\n\nmodule.exports = Target = (function() {\n  function Target() {}\n\n  Target.main = function() {\n    CheckForProblems.check();\n    Weinre.target = new Target();\n    return Weinre.target.initialize();\n  };\n\n  Target.prototype.setWeinreServerURLFromScriptSrc = function(element) {\n    var match, message, pattern;\n    if (window.WeinreServerURL) {\n      return;\n    }\n    if (element) {\n      pattern = /((https?:)?\\/\\/(.*?)\\/)/;\n      match = pattern.exec(element.src);\n      if (match) {\n        window.WeinreServerURL = match[1];\n        return;\n      }\n    }\n    message = "unable to calculate the weinre server url; explicity set the variable window.WeinreServerURL instead";\n    alert(message);\n    throw new Ex(arguments, message);\n  };\n\n  Target.prototype.setWeinreServerIdFromScriptSrc = function(element) {\n    var attempt, hash;\n    if (window.WeinreServerId) {\n      return;\n    }\n    element = this.getTargetScriptElement();\n    hash = "anonymous";\n    if (element) {\n      attempt = element.src.split("#")[1];\n      if (attempt) {\n        hash = attempt;\n      } else {\n        attempt = location.hash.split("#")[1];\n        if (attempt) {\n          hash = attempt;\n        }\n      }\n    }\n    return window.WeinreServerId = hash;\n  };\n\n  Target.prototype.getTargetScriptElement = function() {\n    var element, elements, i, j, scripts;\n    elements = document.getElementsByTagName("script");\n    scripts = ["target-script.js", "target-script-min.js"];\n    i = 0;\n    while (i < elements.length) {\n      element = elements[i];\n      j = 0;\n      while (j < scripts.length) {\n        if (-1 !== element.src.indexOf("/" + scripts[j])) {\n          return element;\n        }\n        j++;\n      }\n      i++;\n    }\n  };\n\n  Target.prototype.initialize = function() {\n    var element, injectedScriptHost, messageDispatcher;\n    element = this.getTargetScriptElement();\n    this.setWeinreServerURLFromScriptSrc(element);\n    this.setWeinreServerIdFromScriptSrc(element);\n    if (window.WeinreServerURL[window.WeinreServerURL.length - 1] !== "/") {\n      window.WeinreServerURL += "/";\n    }\n    injectedScriptHost = new InjectedScriptHostImpl();\n    Weinre.injectedScript = injectedScriptConstructor(injectedScriptHost, window, 0, "?");\n    window.addEventListener("load", Binding(this, "onLoaded"), false);\n    document.addEventListener("DOMContentLoaded", Binding(this, "onDOMContent"), false);\n    this._startTime = currentTime();\n    if (document.readyState === "loaded") {\n      HookLib.ignoreHooks((function(_this) {\n        return function() {\n          return setTimeout((function() {\n            return _this.onDOMContent();\n          }), 10);\n        };\n      })(this));\n    }\n    if (document.readyState === "complete") {\n      HookLib.ignoreHooks((function(_this) {\n        return function() {\n          setTimeout((function() {\n            return _this.onDOMContent();\n          }), 10);\n          return setTimeout((function() {\n            return _this.onLoaded();\n          }), 20);\n        };\n      })(this));\n    }\n    messageDispatcher = new MessageDispatcher(window.WeinreServerURL + "ws/target", window.WeinreServerId);\n    Weinre.messageDispatcher = messageDispatcher;\n    Weinre.wi = {};\n    Weinre.wi.Console = new WiConsoleImpl();\n    Weinre.wi.CSS = new WiCSSImpl();\n    Weinre.wi.Database = new WiDatabaseImpl();\n    Weinre.wi.DOM = new WiDOMImpl();\n    Weinre.wi.DOMStorage = new WiDOMStorageImpl();\n    Weinre.wi.Inspector = new WiInspectorImpl();\n    Weinre.wi.Runtime = new WiRuntimeImpl();\n    messageDispatcher.registerInterface("Console", Weinre.wi.Console, false);\n    messageDispatcher.registerInterface("CSS", Weinre.wi.CSS, false);\n    messageDispatcher.registerInterface("Database", Weinre.wi.Database, false);\n    messageDispatcher.registerInterface("DOM", Weinre.wi.DOM, false);\n    messageDispatcher.registerInterface("DOMStorage", Weinre.wi.DOMStorage, false);\n    messageDispatcher.registerInterface("Inspector", Weinre.wi.Inspector, false);\n    messageDispatcher.registerInterface("Runtime", Weinre.wi.Runtime, false);\n    messageDispatcher.registerInterface("WeinreExtraClientCommands", new WeinreExtraClientCommandsImpl(), true);\n    messageDispatcher.registerInterface("WeinreTargetEvents", new WeinreTargetEventsImpl(), true);\n    Weinre.wi.ApplicationCacheNotify = messageDispatcher.createProxy("ApplicationCacheNotify");\n    Weinre.wi.ConsoleNotify = messageDispatcher.createProxy("ConsoleNotify");\n    Weinre.wi.DOMNotify = messageDispatcher.createProxy("DOMNotify");\n    Weinre.wi.DOMStorageNotify = messageDispatcher.createProxy("DOMStorageNotify");\n    Weinre.wi.DatabaseNotify = messageDispatcher.createProxy("DatabaseNotify");\n    Weinre.wi.InspectorNotify = messageDispatcher.createProxy("InspectorNotify");\n    Weinre.wi.TimelineNotify = messageDispatcher.createProxy("TimelineNotify");\n    Weinre.wi.NetworkNotify = messageDispatcher.createProxy("NetworkNotify");\n    Weinre.WeinreTargetCommands = messageDispatcher.createProxy("WeinreTargetCommands");\n    Weinre.WeinreExtraTargetEvents = messageDispatcher.createProxy("WeinreExtraTargetEvents");\n    messageDispatcher.getWebSocket().addEventListener("open", Binding(this, this.cb_webSocketOpened));\n    Weinre.nodeStore = new NodeStore();\n    Weinre.cssStore = new CSSStore();\n    return NetworkRequest.installNativeHooks();\n  };\n\n  Target.prototype.cb_webSocketOpened = function() {\n    return Weinre.WeinreTargetCommands.registerTarget(window.location.href, Binding(this, this.cb_registerTarget));\n  };\n\n  Target.prototype.cb_registerTarget = function(targetDescription) {\n    return Weinre.targetDescription = targetDescription;\n  };\n\n  Target.prototype.onLoaded = function() {\n    if (!Weinre.wi.InspectorNotify) {\n      HookLib.ignoreHooks((function(_this) {\n        return function() {\n          return setTimeout((function() {\n            return _this.onLoaded();\n          }), 10);\n        };\n      })(this));\n      return;\n    }\n    return Weinre.wi.InspectorNotify.loadEventFired(currentTime() - this._startTime);\n  };\n\n  Target.prototype.onDOMContent = function() {\n    if (!Weinre.wi.InspectorNotify) {\n      HookLib.ignoreHooks((function(_this) {\n        return function() {\n          return setTimeout((function() {\n            return _this.onDOMContent();\n          }), 10);\n        };\n      })(this));\n      return;\n    }\n    return Weinre.wi.InspectorNotify.domContentEventFired(currentTime() - this._startTime);\n  };\n\n  Target.prototype.setDocument = function() {\n    var nodeData, nodeId;\n    if (!Weinre.elementHighlighter) {\n      Weinre.elementHighlighter = ElementHighlighter.create();\n    }\n    nodeId = Weinre.nodeStore.getNodeId(document);\n    nodeData = Weinre.nodeStore.getNodeData(nodeId, 2);\n    return Weinre.wi.DOMNotify.setDocument(nodeData);\n  };\n\n  Target.prototype.whenBodyReady = function(receiver, args, func) {\n    if (document.body) {\n      func.apply(receiver, args);\n      return;\n    }\n    return document.addEventListener("DOMContentLoaded", function() {\n      return func.apply(receiver, args);\n    }, false);\n  };\n\n  return Target;\n\n})();\n\ncurrentTime = function() {\n  return (new Date().getMilliseconds()) / 1000.0;\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/Target.amd.js'),eval(';modjewel.define("weinre/target/Timeline", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Ex, HookLib, HookSites, IDGenerator, Running, StackTrace, Timeline, TimelineRecordType, TimerIntervals, TimerTimeouts, Weinre, addStackTrace, addTimer, getXhrEventHandler, instrumentedTimerCode, removeTimer;\n\nEx = require(\'../common/Ex\');\n\nWeinre = require(\'../common/Weinre\');\n\nIDGenerator = require(\'../common/IDGenerator\');\n\nStackTrace = require(\'../common/StackTrace\');\n\nHookLib = require(\'../common/HookLib\');\n\nHookSites = require(\'./HookSites\');\n\nRunning = false;\n\nTimerTimeouts = {};\n\nTimerIntervals = {};\n\nTimelineRecordType = {\n  EventDispatch: 0,\n  Layout: 1,\n  RecalculateStyles: 2,\n  Paint: 3,\n  ParseHTML: 4,\n  TimerInstall: 5,\n  TimerRemove: 6,\n  TimerFire: 7,\n  XHRReadyStateChange: 8,\n  XHRLoad: 9,\n  EvaluateScript: 10,\n  Mark: 11,\n  ResourceSendRequest: 12,\n  ResourceReceiveResponse: 13,\n  ResourceFinish: 14,\n  FunctionCall: 15,\n  ReceiveResourceData: 16,\n  GCEvent: 17,\n  MarkDOMContent: 18,\n  MarkLoad: 19,\n  ScheduleResourceRequest: 20\n};\n\nmodule.exports = Timeline = (function() {\n  function Timeline() {}\n\n  Timeline.start = function() {\n    return Running = true;\n  };\n\n  Timeline.stop = function() {\n    return Running = false;\n  };\n\n  Timeline.isRunning = function() {\n    return Running;\n  };\n\n  Timeline.addRecord_Mark = function(message) {\n    var record;\n    if (!Timeline.isRunning()) {\n      return;\n    }\n    record = {};\n    record.type = TimelineRecordType.Mark;\n    record.category = {\n      name: "scripting"\n    };\n    record.startTime = Date.now();\n    record.data = {\n      message: message\n    };\n    addStackTrace(record, 3);\n    return Weinre.wi.TimelineNotify.addRecordToTimeline(record);\n  };\n\n  Timeline.addRecord_EventDispatch = function(event, name, category) {\n    var record;\n    if (!Timeline.isRunning()) {\n      return;\n    }\n    if (!category) {\n      category = "scripting";\n    }\n    record = {};\n    record.type = TimelineRecordType.EventDispatch;\n    record.category = {\n      name: category\n    };\n    record.startTime = Date.now();\n    record.data = {\n      type: event.type\n    };\n    return Weinre.wi.TimelineNotify.addRecordToTimeline(record);\n  };\n\n  Timeline.addRecord_TimerInstall = function(id, timeout, singleShot) {\n    var record;\n    if (!Timeline.isRunning()) {\n      return;\n    }\n    record = {};\n    record.type = TimelineRecordType.TimerInstall;\n    record.category = {\n      name: "scripting"\n    };\n    record.startTime = Date.now();\n    record.data = {\n      timerId: id,\n      timeout: timeout,\n      singleShot: singleShot\n    };\n    addStackTrace(record, 4);\n    return Weinre.wi.TimelineNotify.addRecordToTimeline(record);\n  };\n\n  Timeline.addRecord_TimerRemove = function(id, timeout, singleShot) {\n    var record;\n    if (!Timeline.isRunning()) {\n      return;\n    }\n    record = {};\n    record.type = TimelineRecordType.TimerRemove;\n    record.category = {\n      name: "scripting"\n    };\n    record.startTime = Date.now();\n    record.data = {\n      timerId: id,\n      timeout: timeout,\n      singleShot: singleShot\n    };\n    addStackTrace(record, 4);\n    return Weinre.wi.TimelineNotify.addRecordToTimeline(record);\n  };\n\n  Timeline.addRecord_TimerFire = function(id, timeout, singleShot) {\n    var record;\n    if (!Timeline.isRunning()) {\n      return;\n    }\n    record = {};\n    record.type = TimelineRecordType.TimerFire;\n    record.category = {\n      name: "scripting"\n    };\n    record.startTime = Date.now();\n    record.data = {\n      timerId: id,\n      timeout: timeout,\n      singleShot: singleShot\n    };\n    return Weinre.wi.TimelineNotify.addRecordToTimeline(record);\n  };\n\n  Timeline.addRecord_XHRReadyStateChange = function(method, url, id, xhr) {\n    var contentLength, contentType, e, record;\n    if (!Timeline.isRunning()) {\n      return;\n    }\n    try {\n      contentLength = xhr.getResponseHeader("Content-Length");\n      contentLength = parseInt(contentLength);\n      contentType = xhr.getResponseHeader("Content-Type");\n    } catch (_error) {\n      e = _error;\n      contentLength = 0;\n      contentType = "unknown";\n    }\n    record = {};\n    record.startTime = Date.now();\n    record.category = {\n      name: "loading"\n    };\n    if (xhr.readyState === XMLHttpRequest.OPENED) {\n      record.type = TimelineRecordType.ResourceSendRequest;\n      record.data = {\n        identifier: id,\n        url: url,\n        requestMethod: method\n      };\n    } else if (xhr.readyState === XMLHttpRequest.DONE) {\n      record.type = TimelineRecordType.ResourceReceiveResponse;\n      record.data = {\n        identifier: id,\n        statusCode: xhr.status,\n        mimeType: contentType,\n        url: url\n      };\n      if (!isNaN(contentLength)) {\n        record.data.expectedContentLength = contentLength;\n      }\n    } else {\n      return;\n    }\n    return Weinre.wi.TimelineNotify.addRecordToTimeline(record);\n  };\n\n  Timeline.installGlobalListeners = function() {\n    if (window.applicationCache) {\n      applicationCache.addEventListener("checking", (function(e) {\n        return Timeline.addRecord_EventDispatch(e, "applicationCache.checking", "loading");\n      }), false);\n      applicationCache.addEventListener("error", (function(e) {\n        return Timeline.addRecord_EventDispatch(e, "applicationCache.error", "loading");\n      }), false);\n      applicationCache.addEventListener("noupdate", (function(e) {\n        return Timeline.addRecord_EventDispatch(e, "applicationCache.noupdate", "loading");\n      }), false);\n      applicationCache.addEventListener("downloading", (function(e) {\n        return Timeline.addRecord_EventDispatch(e, "applicationCache.downloading", "loading");\n      }), false);\n      applicationCache.addEventListener("progress", (function(e) {\n        return Timeline.addRecord_EventDispatch(e, "applicationCache.progress", "loading");\n      }), false);\n      applicationCache.addEventListener("updateready", (function(e) {\n        return Timeline.addRecord_EventDispatch(e, "applicationCache.updateready", "loading");\n      }), false);\n      applicationCache.addEventListener("cached", (function(e) {\n        return Timeline.addRecord_EventDispatch(e, "applicationCache.cached", "loading");\n      }), false);\n      applicationCache.addEventListener("obsolete", (function(e) {\n        return Timeline.addRecord_EventDispatch(e, "applicationCache.obsolete", "loading");\n      }), false);\n    }\n    window.addEventListener("error", (function(e) {\n      return Timeline.addRecord_EventDispatch(e, "window.error");\n    }), false);\n    window.addEventListener("hashchange", (function(e) {\n      return Timeline.addRecord_EventDispatch(e, "window.hashchange");\n    }), false);\n    window.addEventListener("message", (function(e) {\n      return Timeline.addRecord_EventDispatch(e, "window.message");\n    }), false);\n    window.addEventListener("offline", (function(e) {\n      return Timeline.addRecord_EventDispatch(e, "window.offline");\n    }), false);\n    window.addEventListener("online", (function(e) {\n      return Timeline.addRecord_EventDispatch(e, "window.online");\n    }), false);\n    return window.addEventListener("scroll", (function(e) {\n      return Timeline.addRecord_EventDispatch(e, "window.scroll");\n    }), false);\n  };\n\n  Timeline.installNativeHooks = function() {\n    HookSites.window_setInterval.addHooks({\n      before: function(receiver, args) {\n        var code, interval;\n        code = args[0];\n        if (typeof code !== "function") {\n          return;\n        }\n        interval = args[1];\n        code = instrumentedTimerCode(code, interval, false);\n        args[0] = code;\n        this.userData = {};\n        this.userData.code = code;\n        return this.userData.interval = interval;\n      },\n      after: function(receiver, args, result) {\n        var code, id;\n        if (!this.userData) {\n          return;\n        }\n        code = this.userData.code;\n        if (typeof code !== "function") {\n          return;\n        }\n        id = result;\n        code.__timerId = id;\n        return addTimer(id, this.userData.interval, false);\n      }\n    });\n    HookSites.window_clearInterval.addHooks({\n      before: function(receiver, args) {\n        var id;\n        id = args[0];\n        return removeTimer(id, false);\n      }\n    });\n    HookSites.window_setTimeout.addHooks({\n      before: function(receiver, args) {\n        var code, interval;\n        code = args[0];\n        if (typeof code !== "function") {\n          return;\n        }\n        interval = args[1];\n        code = instrumentedTimerCode(code, interval, true);\n        args[0] = code;\n        this.userData = {};\n        this.userData.code = code;\n        return this.userData.interval = interval;\n      },\n      after: function(receiver, args, result) {\n        var code, id;\n        if (!this.userData) {\n          return;\n        }\n        code = this.userData.code;\n        if (typeof code !== "function") {\n          return;\n        }\n        id = result;\n        code.__timerId = id;\n        return addTimer(id, this.userData.interval, true);\n      }\n    });\n    HookSites.window_clearTimeout.addHooks({\n      before: function(receiver, args) {\n        var id;\n        id = args[0];\n        return removeTimer(id, true);\n      }\n    });\n    return HookSites.XMLHttpRequest_open.addHooks({\n      before: function(receiver, args) {\n        var xhr;\n        xhr = receiver;\n        IDGenerator.getId(xhr);\n        xhr.__weinre_method = args[0];\n        xhr.__weinre_url = args[1];\n        return xhr.addEventListener("readystatechange", getXhrEventHandler(xhr), false);\n      }\n    });\n  };\n\n  return Timeline;\n\n})();\n\ngetXhrEventHandler = function(xhr) {\n  return function(event) {\n    return Timeline.addRecord_XHRReadyStateChange(xhr.__weinre_method, xhr.__weinre_url, IDGenerator.getId(xhr), xhr);\n  };\n};\n\naddTimer = function(id, timeout, singleShot) {\n  var timerSet;\n  timerSet = (singleShot ? TimerTimeouts : TimerIntervals);\n  timerSet[id] = {\n    id: id,\n    timeout: timeout,\n    singleShot: singleShot\n  };\n  return Timeline.addRecord_TimerInstall(id, timeout, singleShot);\n};\n\nremoveTimer = function(id, singleShot) {\n  var timer, timerSet;\n  timerSet = (singleShot ? TimerTimeouts : TimerIntervals);\n  timer = timerSet[id];\n  if (!timer) {\n    return;\n  }\n  Timeline.addRecord_TimerRemove(id, timer.timeout, singleShot);\n  return delete timerSet[id];\n};\n\ninstrumentedTimerCode = function(code, timeout, singleShot) {\n  var instrumentedCode;\n  if (typeof code !== "function") {\n    return code;\n  }\n  instrumentedCode = function() {\n    var id, result;\n    result = code.apply(this, arguments);\n    id = arguments.callee.__timerId;\n    Timeline.addRecord_TimerFire(id, timeout, singleShot);\n    return result;\n  };\n  instrumentedCode.displayName = code.name || code.displayName;\n  return instrumentedCode;\n};\n\naddStackTrace = function(record, skip) {\n  var i, trace, _results;\n  if (!skip) {\n    skip = 1;\n  }\n  trace = new StackTrace(arguments).trace;\n  record.stackTrace = [];\n  i = skip;\n  _results = [];\n  while (i < trace.length) {\n    record.stackTrace.push({\n      functionName: trace[i],\n      scriptName: "",\n      lineNumber: ""\n    });\n    _results.push(i++);\n  }\n  return _results;\n};\n\nTimeline.installGlobalListeners();\n\nTimeline.installNativeHooks();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/Timeline.amd.js'),eval(";modjewel.define(\"weinre/target/WeinreExtraClientCommandsImpl\", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Console, Weinre, WeinreExtraClientCommandsImpl, WiDatabaseImpl;\n\nWeinre = require('../common/Weinre');\n\nWiDatabaseImpl = require('./WiDatabaseImpl');\n\nConsole = require('./Console');\n\nmodule.exports = WeinreExtraClientCommandsImpl = (function() {\n  function WeinreExtraClientCommandsImpl() {}\n\n  WeinreExtraClientCommandsImpl.prototype.getDatabases = function(callback) {\n    var result;\n    if (!callback) {\n      return;\n    }\n    result = WiDatabaseImpl.getDatabases();\n    return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n  };\n\n  return WeinreExtraClientCommandsImpl;\n\n})();\n\nrequire(\"../common/MethodNamer\").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WeinreExtraClientCommandsImpl.amd.js"),eval(';modjewel.define("weinre/target/WeinreTargetEventsImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Callback, Console, Weinre, WeinreTargetEventsImpl;\n\nWeinre = require(\'../common/Weinre\');\n\nCallback = require(\'../common/Callback\');\n\nConsole = require(\'./Console\');\n\nmodule.exports = WeinreTargetEventsImpl = (function() {\n  function WeinreTargetEventsImpl() {}\n\n  WeinreTargetEventsImpl.prototype.connectionCreated = function(clientChannel, targetChannel) {\n    var message;\n    message = ("weinre: target " + targetChannel + " connected to client ") + clientChannel;\n    Weinre.logInfo(message);\n    return Weinre.target.whenBodyReady(this, [], function() {\n      var oldValue;\n      oldValue = Console.useRemote(true);\n      Weinre.target.setDocument();\n      Weinre.wi.TimelineNotify.timelineProfilerWasStopped();\n      return Weinre.wi.DOMStorage.initialize();\n    });\n  };\n\n  WeinreTargetEventsImpl.prototype.connectionDestroyed = function(clientChannel, targetChannel) {\n    var message, oldValue;\n    message = ("weinre: target " + targetChannel + " disconnected from client ") + clientChannel;\n    Weinre.logInfo(message);\n    return oldValue = Console.useRemote(false);\n  };\n\n  WeinreTargetEventsImpl.prototype.sendCallback = function(callbackId, result) {\n    return Callback.invoke(callbackId, result);\n  };\n\n  return WeinreTargetEventsImpl;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WeinreTargetEventsImpl.amd.js'),eval(';modjewel.define("weinre/target/WiConsoleImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Weinre, WiConsoleImpl;\n\nWeinre = require(\'../common/Weinre\');\n\nmodule.exports = WiConsoleImpl = (function() {\n  function WiConsoleImpl() {\n    this.messagesEnabled = true;\n  }\n\n  WiConsoleImpl.prototype.setConsoleMessagesEnabled = function(enabled, callback) {\n    var oldValue;\n    oldValue = this.messagesEnabled;\n    this.messagesEnabled = enabled;\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [oldValue]);\n    }\n  };\n\n  WiConsoleImpl.prototype.clearConsoleMessages = function(callback) {\n    Weinre.wi.ConsoleNotify.consoleMessagesCleared();\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, []);\n    }\n  };\n\n  WiConsoleImpl.prototype.setMonitoringXHREnabled = function(enabled, callback) {\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, []);\n    }\n  };\n\n  return WiConsoleImpl;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WiConsoleImpl.amd.js'),eval(';modjewel.define("weinre/target/WiCSSImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Weinre, WiCSSImpl;\n\nWeinre = require(\'../common/Weinre\');\n\nmodule.exports = WiCSSImpl = (function() {\n  function WiCSSImpl() {\n    this.dummyComputedStyle = false;\n  }\n\n  WiCSSImpl.prototype.getStylesForNode = function(nodeId, callback) {\n    var computedStyle, node, parentNode, parentStyle, result;\n    result = {};\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    if (this.dummyComputedStyle) {\n      computedStyle = {\n        styleId: null,\n        properties: [],\n        shorthandValues: [],\n        cssProperties: []\n      };\n    } else {\n      computedStyle = Weinre.cssStore.getComputedStyle(node);\n    }\n    result = {\n      inlineStyle: Weinre.cssStore.getInlineStyle(node),\n      computedStyle: computedStyle,\n      matchedCSSRules: Weinre.cssStore.getMatchedCSSRules(node),\n      styleAttributes: Weinre.cssStore.getStyleAttributes(node),\n      pseudoElements: Weinre.cssStore.getPseudoElements(node),\n      inherited: []\n    };\n    parentNode = node.parentNode;\n    while (parentNode) {\n      parentStyle = {\n        inlineStyle: Weinre.cssStore.getInlineStyle(parentNode),\n        matchedCSSRules: Weinre.cssStore.getMatchedCSSRules(parentNode)\n      };\n      result.inherited.push(parentStyle);\n      parentNode = parentNode.parentNode;\n    }\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiCSSImpl.prototype.getComputedStyleForNode = function(nodeId, callback) {\n    var node, result;\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    result = Weinre.cssStore.getComputedStyle(node);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiCSSImpl.prototype.getInlineStyleForNode = function(nodeId, callback) {\n    var node, result;\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    result = Weinre.cssStore.getInlineStyle(node);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiCSSImpl.prototype.getAllStyles = function(callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiCSSImpl.prototype.getStyleSheet = function(styleSheetId, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiCSSImpl.prototype.getStyleSheetText = function(styleSheetId, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiCSSImpl.prototype.setStyleSheetText = function(styleSheetId, text, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiCSSImpl.prototype.setPropertyText = function(styleId, propertyIndex, text, overwrite, callback) {\n    var result;\n    result = Weinre.cssStore.setPropertyText(styleId, propertyIndex, text, overwrite);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiCSSImpl.prototype.toggleProperty = function(styleId, propertyIndex, disable, callback) {\n    var result;\n    result = Weinre.cssStore.toggleProperty(styleId, propertyIndex, disable);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiCSSImpl.prototype.setRuleSelector = function(ruleId, selector, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiCSSImpl.prototype.addRule = function(contextNodeId, selector, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiCSSImpl.prototype.querySelectorAll = function(documentId, selector, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  return WiCSSImpl;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WiCSSImpl.amd.js'),eval(';modjewel.define("weinre/target/WiDatabaseImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar HookSites, IDGenerator, SqlStepper, Weinre, WiDatabaseImpl, dbAdd, dbById, dbRecordById, dbRecordByName, executeSQL_error, executeSQL_step_1, executeSQL_step_2, getTableNames_step_1, getTableNames_step_2, id2db, logSqlError, name2db;\n\nWeinre = require(\'../common/Weinre\');\n\nIDGenerator = require(\'../common/IDGenerator\');\n\nHookSites = require(\'./HookSites\');\n\nSqlStepper = require(\'./SqlStepper\');\n\nid2db = {};\n\nname2db = {};\n\nmodule.exports = WiDatabaseImpl = (function() {\n  function WiDatabaseImpl() {\n    if (!window.openDatabase) {\n      return;\n    }\n    HookSites.window_openDatabase.addHooks({\n      after: function(receiver, args, db) {\n        var name, version;\n        if (!db) {\n          return;\n        }\n        name = args[0];\n        version = args[1];\n        return dbAdd(db, name, version);\n      }\n    });\n  }\n\n  WiDatabaseImpl.getDatabases = function() {\n    var id, result;\n    result = [];\n    for (id in id2db) {\n      result.push(id2db[id]);\n    }\n    return result;\n  };\n\n  WiDatabaseImpl.prototype.getDatabaseTableNames = function(databaseId, callback) {\n    var db, stepper;\n    db = dbById(databaseId);\n    if (!db) {\n      return;\n    }\n    stepper = SqlStepper([getTableNames_step_1, getTableNames_step_2]);\n    stepper.callback = callback;\n    return stepper.run(db, logSqlError);\n  };\n\n  WiDatabaseImpl.prototype.executeSQL = function(databaseId, query, callback) {\n    var db, stepper, txid;\n    db = dbById(databaseId);\n    if (!db) {\n      return;\n    }\n    txid = Weinre.targetDescription.channel + "-" + IDGenerator.next();\n    stepper = SqlStepper([executeSQL_step_1, executeSQL_step_2]);\n    stepper.txid = txid;\n    stepper.query = query;\n    stepper.callback = callback;\n    stepper.run(db, executeSQL_error);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [true, txid]);\n    }\n  };\n\n  return WiDatabaseImpl;\n\n})();\n\nlogSqlError = function(sqlError) {\n  return console.log(("SQL Error " + sqlError.code + ": ") + sqlError.message);\n};\n\ngetTableNames_step_1 = function() {\n  return this.executeSql("SELECT name FROM sqlite_master WHERE type=\'table\'");\n};\n\ngetTableNames_step_2 = function(resultSet) {\n  var i, name, result, rows;\n  rows = resultSet.rows;\n  result = [];\n  i = 0;\n  while (i < rows.length) {\n    name = rows.item(i).name;\n    if (name === "__WebKitDatabaseInfoTable__") {\n      i++;\n      continue;\n    }\n    result.push(name);\n    i++;\n  }\n  return Weinre.WeinreTargetCommands.sendClientCallback(this.callback, [result]);\n};\n\nexecuteSQL_step_1 = function() {\n  return this.executeSql(this.query);\n};\n\nexecuteSQL_step_2 = function(resultSet) {\n  var columnNames, i, j, propName, row, rows, values;\n  columnNames = [];\n  values = [];\n  rows = resultSet.rows;\n  i = 0;\n  while (i < rows.length) {\n    row = rows.item(i);\n    if (i === 0) {\n      for (propName in row) {\n        columnNames.push(propName);\n      }\n    }\n    j = 0;\n    while (j < columnNames.length) {\n      values.push(row[columnNames[j]]);\n      j++;\n    }\n    i++;\n  }\n  return Weinre.wi.DatabaseNotify.sqlTransactionSucceeded(this.txid, columnNames, values);\n};\n\nexecuteSQL_error = function(sqlError) {\n  var error;\n  error = {\n    code: sqlError.code,\n    message: sqlError.message\n  };\n  return Weinre.wi.DatabaseNotify.sqlTransactionFailed(this.txid, error);\n};\n\ndbById = function(id) {\n  var record;\n  record = id2db[id];\n  if (!record) {\n    return null;\n  }\n  return record.db;\n};\n\ndbRecordById = function(id) {\n  return id2db[id];\n};\n\ndbRecordByName = function(name) {\n  return name2db[name];\n};\n\ndbAdd = function(db, name, version) {\n  var payload, record;\n  record = dbRecordByName(name);\n  if (record) {\n    return record;\n  }\n  record = {};\n  record.id = IDGenerator.next();\n  record.domain = window.location.origin;\n  record.name = name;\n  record.version = version;\n  record.db = db;\n  id2db[record.id] = record;\n  name2db[name] = record;\n  payload = {};\n  payload.id = record.id;\n  payload.domain = record.domain;\n  payload.name = name;\n  payload.version = version;\n  return Weinre.WeinreExtraTargetEvents.databaseOpened(payload);\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WiDatabaseImpl.amd.js'),eval(';modjewel.define("weinre/target/WiDOMImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Weinre, WiDOMImpl;\n\nWeinre = require(\'../common/Weinre\');\n\nmodule.exports = WiDOMImpl = (function() {\n  function WiDOMImpl() {}\n\n  WiDOMImpl.prototype.getChildNodes = function(nodeId, callback) {\n    var children, node;\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    children = Weinre.nodeStore.serializeNodeChildren(node, 1);\n    Weinre.wi.DOMNotify.setChildNodes(nodeId, children);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiDOMImpl.prototype.setAttribute = function(elementId, name, value, callback) {\n    var element;\n    element = Weinre.nodeStore.getNode(elementId);\n    if (!element) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid elementId: " + elementId);\n      return;\n    }\n    element.setAttribute(name, value);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiDOMImpl.prototype.removeAttribute = function(elementId, name, callback) {\n    var element;\n    element = Weinre.nodeStore.getNode(elementId);\n    if (!element) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid elementId: " + elementId);\n      return;\n    }\n    element.removeAttribute(name);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiDOMImpl.prototype.setTextNodeValue = function(nodeId, value, callback) {\n    var node;\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    node.nodeValue = value;\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiDOMImpl.prototype.getEventListenersForNode = function(nodeId, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiDOMImpl.prototype.copyNode = function(nodeId, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiDOMImpl.prototype.removeNode = function(nodeId, callback) {\n    var node;\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    if (!node.parentNode) {\n      Weinre.logWarning(arguments.callee.signature + " passed a parentless node: " + node);\n      return;\n    }\n    node.parentNode.removeChild(node);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiDOMImpl.prototype.changeTagName = function(nodeId, newTagName, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiDOMImpl.prototype.getOuterHTML = function(nodeId, callback) {\n    var node, value;\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    value = node.outerHTML;\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [value]);\n    }\n  };\n\n  WiDOMImpl.prototype.setOuterHTML = function(nodeId, outerHTML, callback) {\n    var node;\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    node.outerHTML = outerHTML;\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiDOMImpl.prototype.addInspectedNode = function(nodeId, callback) {\n    Weinre.nodeStore.addInspectedNode(nodeId);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiDOMImpl.prototype.performSearch = function(query, runSynchronously, callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiDOMImpl.prototype.searchCanceled = function(callback) {\n    return Weinre.notImplemented(arguments.callee.signature);\n  };\n\n  WiDOMImpl.prototype.pushNodeByPathToFrontend = function(path, callback) {\n    var childNodeIds, curr, currId, i, index, nodeId, nodeName, parts, _i, _ref;\n    parts = path.split(",");\n    curr = document;\n    currId = null;\n    nodeId = Weinre.nodeStore.getNodeId(curr);\n    this.getChildNodes(nodeId);\n    for (i = _i = 0, _ref = parts.length; _i < _ref; i = _i += 2) {\n      index = parseInt(parts[i]);\n      nodeName = parts[i + 1];\n      if (isNaN(index)) {\n        return;\n      }\n      childNodeIds = Weinre.nodeStore.childNodeIds(curr);\n      currId = childNodeIds[index];\n      if (!currId) {\n        return;\n      }\n      this.getChildNodes(currId);\n      curr = Weinre.nodeStore.getNode(currId);\n      if (curr.nodeName !== nodeName) {\n        return;\n      }\n    }\n    if (callback && currId) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [currId]);\n    }\n  };\n\n  WiDOMImpl.prototype.resolveNode = function(nodeId, callback) {\n    var result;\n    result = Weinre.injectedScript.resolveNode(nodeId);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiDOMImpl.prototype.getNodeProperties = function(nodeId, propertiesArray, callback) {\n    var result;\n    propertiesArray = JSON.stringify(propertiesArray);\n    result = Weinre.injectedScript.getNodeProperties(nodeId, propertiesArray);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiDOMImpl.prototype.getNodePrototypes = function(nodeId, callback) {\n    var result;\n    result = Weinre.injectedScript.getNodePrototypes(nodeId);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiDOMImpl.prototype.pushNodeToFrontend = function(objectId, callback) {\n    var result;\n    objectId = JSON.stringify(objectId);\n    result = Weinre.injectedScript.pushNodeToFrontend(objectId);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  return WiDOMImpl;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WiDOMImpl.amd.js'),eval(';modjewel.define("weinre/target/WiDOMStorageImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar HookSites, Weinre, WiDOMStorageImpl, _getStorageArea, _storageEventHandler;\n\nWeinre = require(\'../common/Weinre\');\n\nHookSites = require(\'./HookSites\');\n\nmodule.exports = WiDOMStorageImpl = (function() {\n  function WiDOMStorageImpl() {}\n\n  WiDOMStorageImpl.prototype.getDOMStorageEntries = function(storageId, callback) {\n    var i, key, length, result, storageArea, val;\n    storageArea = _getStorageArea(storageId);\n    if (!storageArea) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid storageId: " + storageId);\n      return;\n    }\n    result = [];\n    length = storageArea.length;\n    i = 0;\n    while (i < length) {\n      key = storageArea.key(i);\n      val = storageArea.getItem(key);\n      result.push([key, val]);\n      i++;\n    }\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiDOMStorageImpl.prototype.setDOMStorageItem = function(storageId, key, value, callback) {\n    var e, result, storageArea;\n    storageArea = _getStorageArea(storageId);\n    if (!storageArea) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid storageId: " + storageId);\n      return;\n    }\n    result = true;\n    try {\n      HookLib.ignoreHooks(function() {\n        if (storageArea === window.localStorage) {\n          return localStorage.setItem(key, value);\n        } else if (storageArea === window.sessionStorage) {\n          return sessionStorage.setItem(key, value);\n        }\n      });\n    } catch (_error) {\n      e = _error;\n      result = false;\n    }\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiDOMStorageImpl.prototype.removeDOMStorageItem = function(storageId, key, callback) {\n    var e, result, storageArea;\n    storageArea = _getStorageArea(storageId);\n    if (!storageArea) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid storageId: " + storageId);\n      return;\n    }\n    result = true;\n    try {\n      HookLib.ignoreHooks(function() {\n        if (storageArea === window.localStorage) {\n          return localStorage.removeItem(key);\n        } else if (storageArea === window.sessionStorage) {\n          return sessionStorage.removeItem(key);\n        }\n      });\n    } catch (_error) {\n      e = _error;\n      result = false;\n    }\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiDOMStorageImpl.prototype.initialize = function() {\n    if (window.localStorage) {\n      Weinre.wi.DOMStorageNotify.addDOMStorage({\n        id: 1,\n        host: window.location.host,\n        isLocalStorage: true\n      });\n      HookSites.LocalStorage_setItem.addHooks({\n        after: function() {\n          return _storageEventHandler({\n            storageArea: window.localStorage\n          });\n        }\n      });\n      HookSites.LocalStorage_removeItem.addHooks({\n        after: function() {\n          return _storageEventHandler({\n            storageArea: window.localStorage\n          });\n        }\n      });\n      HookSites.LocalStorage_clear.addHooks({\n        after: function() {\n          return _storageEventHandler({\n            storageArea: window.localStorage\n          });\n        }\n      });\n    }\n    if (window.sessionStorage) {\n      Weinre.wi.DOMStorageNotify.addDOMStorage({\n        id: 2,\n        host: window.location.host,\n        isLocalStorage: false\n      });\n      HookSites.SessionStorage_setItem.addHooks({\n        after: function() {\n          return _storageEventHandler({\n            storageArea: window.sessionStorage\n          });\n        }\n      });\n      HookSites.SessionStorage_removeItem.addHooks({\n        after: function() {\n          return _storageEventHandler({\n            storageArea: window.sessionStorage\n          });\n        }\n      });\n      HookSites.SessionStorage_clear.addHooks({\n        after: function() {\n          return _storageEventHandler({\n            storageArea: window.sessionStorage\n          });\n        }\n      });\n    }\n    return document.addEventListener("storage", _storageEventHandler, false);\n  };\n\n  return WiDOMStorageImpl;\n\n})();\n\n_getStorageArea = function(storageId) {\n  if (storageId === 1) {\n    return window.localStorage;\n  } else if (storageId === 2) {\n    return window.sessionStorage;\n  }\n  return null;\n};\n\n_storageEventHandler = function(event) {\n  var storageId;\n  if (event.storageArea === window.localStorage) {\n    storageId = 1;\n  } else if (event.storageArea === window.sessionStorage) {\n    storageId = 2;\n  } else {\n    return;\n  }\n  return Weinre.wi.DOMStorageNotify.updateDOMStorage(storageId);\n};\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WiDOMStorageImpl.amd.js'),eval(';modjewel.define("weinre/target/WiInspectorImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Timeline, Weinre, WiInspectorImpl;\n\nWeinre = require(\'../common/Weinre\');\n\nTimeline = require(\'../target/Timeline\');\n\nmodule.exports = WiInspectorImpl = (function() {\n  function WiInspectorImpl() {}\n\n  WiInspectorImpl.prototype.reloadPage = function(callback) {\n    if (callback) {\n      Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n    return window.location.reload();\n  };\n\n  WiInspectorImpl.prototype.highlightDOMNode = function(nodeId, callback) {\n    var node;\n    node = Weinre.nodeStore.getNode(nodeId);\n    if (!node) {\n      Weinre.logWarning(arguments.callee.signature + " passed an invalid nodeId: " + nodeId);\n      return;\n    }\n    Weinre.elementHighlighter.on(node);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiInspectorImpl.prototype.hideDOMNodeHighlight = function(callback) {\n    Weinre.elementHighlighter.off();\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiInspectorImpl.prototype.startTimelineProfiler = function(callback) {\n    Timeline.start();\n    Weinre.wi.TimelineNotify.timelineProfilerWasStarted();\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  WiInspectorImpl.prototype.stopTimelineProfiler = function(callback) {\n    Timeline.stop();\n    Weinre.wi.TimelineNotify.timelineProfilerWasStopped();\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback);\n    }\n  };\n\n  return WiInspectorImpl;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WiInspectorImpl.amd.js'),eval(';modjewel.define("weinre/target/WiRuntimeImpl", function(require, exports, module) { // Generated by CoffeeScript 1.8.0\nvar Weinre, WiRuntimeImpl;\n\nWeinre = require(\'../common/Weinre\');\n\nmodule.exports = WiRuntimeImpl = (function() {\n  function WiRuntimeImpl() {}\n\n  WiRuntimeImpl.prototype.evaluate = function(expression, objectGroup, includeCommandLineAPI, callback) {\n    var result;\n    result = Weinre.injectedScript.evaluate(expression, objectGroup, includeCommandLineAPI);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiRuntimeImpl.prototype.getCompletions = function(expression, includeCommandLineAPI, callback) {\n    var result;\n    result = Weinre.injectedScript.getCompletions(expression, includeCommandLineAPI);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiRuntimeImpl.prototype.getProperties = function(objectId, ignoreHasOwnProperty, abbreviate, callback) {\n    var result;\n    objectId = JSON.stringify(objectId);\n    result = Weinre.injectedScript.getProperties(objectId, ignoreHasOwnProperty, abbreviate);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiRuntimeImpl.prototype.setPropertyValue = function(objectId, propertyName, expression, callback) {\n    var result;\n    objectId = JSON.stringify(objectId);\n    result = Weinre.injectedScript.setPropertyValue(objectId, propertyName, expression);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  WiRuntimeImpl.prototype.releaseWrapperObjectGroup = function(injectedScriptId, objectGroup, callback) {\n    var result;\n    result = Weinre.injectedScript.releaseWrapperObjectGroup(objectGroup);\n    if (callback) {\n      return Weinre.WeinreTargetCommands.sendClientCallback(callback, [result]);\n    }\n  };\n\n  return WiRuntimeImpl;\n\n})();\n\nrequire("../common/MethodNamer").setNamesForClass(module.exports);\n\n});\n\n//@ sourceURL=weinre/target/WiRuntimeImpl.amd.js'),eval('modjewel.require(\'weinre/common/Weinre\').addIDLs([{"interfaces": [{"name": "InjectedScriptHost", "methods": [{"name": "clearConsoleMessages", "parameters": []}, {"name": "copyText", "parameters": [{"name": "text"}]}, {"parameters": [{"name": "nodeId"}], "name": "nodeForId"}, {"parameters": [{"name": "node"}, {"name": "withChildren"}, {"name": "selectInUI"}], "name": "pushNodePathToFrontend"}, {"name": "inspectedNode", "parameters": [{"name": "num"}]}, {"parameters": [{"name": "object"}], "name": "internalConstructorName"}, {"parameters": [], "name": "currentCallFrame"}, {"parameters": [{"name": "database"}], "name": "selectDatabase"}, {"parameters": [{"name": "storage"}], "name": "selectDOMStorage"}, {"name": "didCreateWorker", "parameters": [{"name": "id"}, {"name": "url"}, {"name": "isFakeWorker"}]}, {"name": "didDestroyWorker", "parameters": [{"name": "id"}]}, {"name": "nextWorkerId", "parameters": []}]}], "name": "core"}, {"interfaces": [{"name": "Inspector", "methods": [{"name": "addScriptToEvaluateOnLoad", "parameters": [{"name": "scriptSource"}]}, {"name": "removeAllScriptsToEvaluateOnLoad", "parameters": []}, {"name": "reloadPage", "parameters": [{"name": "ignoreCache"}]}, {"name": "populateScriptObjects", "parameters": []}, {"name": "openInInspectedWindow", "parameters": [{"name": "url"}]}, {"name": "setSearchingForNode", "parameters": [{"name": "enabled"}]}, {"name": "didEvaluateForTestInFrontend", "parameters": [{"name": "testCallId"}, {"name": "jsonResult"}]}, {"name": "highlightDOMNode", "parameters": [{"name": "nodeId"}]}, {"name": "hideDOMNodeHighlight", "parameters": []}, {"name": "highlightFrame", "parameters": [{"name": "frameId"}]}, {"name": "hideFrameHighlight", "parameters": []}, {"name": "setUserAgentOverride", "parameters": [{"name": "userAgent"}]}, {"name": "getCookies", "parameters": []}, {"name": "deleteCookie", "parameters": [{"name": "cookieName"}, {"name": "domain"}]}, {"name": "startTimelineProfiler", "parameters": []}, {"name": "stopTimelineProfiler", "parameters": []}, {"name": "enableDebugger", "parameters": []}, {"name": "disableDebugger", "parameters": []}, {"name": "enableProfiler", "parameters": []}, {"name": "disableProfiler", "parameters": []}, {"name": "startProfiling", "parameters": []}, {"name": "stopProfiling", "parameters": []}]}, {"name": "Runtime", "methods": [{"name": "evaluate", "parameters": [{"name": "expression"}, {"name": "objectGroup"}, {"name": "includeCommandLineAPI"}]}, {"name": "getCompletions", "parameters": [{"name": "expression"}, {"name": "includeCommandLineAPI"}]}, {"name": "getProperties", "parameters": [{"name": "objectId"}, {"name": "ignoreHasOwnProperty"}, {"name": "abbreviate"}]}, {"name": "setPropertyValue", "parameters": [{"name": "objectId"}, {"name": "propertyName"}, {"name": "expression"}]}, {"name": "releaseWrapperObjectGroup", "parameters": [{"name": "injectedScriptId"}, {"name": "objectGroup"}]}]}, {"name": "InjectedScript", "methods": [{"name": "evaluateOnSelf", "parameters": [{"name": "functionBody"}, {"name": "argumentsArray"}]}]}, {"name": "Console", "methods": [{"name": "setConsoleMessagesEnabled", "parameters": [{"name": "enabled"}]}, {"name": "clearConsoleMessages", "parameters": []}, {"name": "setMonitoringXHREnabled", "parameters": [{"name": "enabled"}]}]}, {"name": "Network", "methods": [{"name": "cachedResources", "parameters": []}, {"name": "resourceContent", "parameters": [{"name": "frameId"}, {"name": "url"}, {"name": "base64Encode"}]}, {"name": "setExtraHeaders", "parameters": [{"name": "headers"}]}]}, {"name": "Database", "methods": [{"name": "getDatabaseTableNames", "parameters": [{"name": "databaseId"}]}, {"name": "executeSQL", "parameters": [{"name": "databaseId"}, {"name": "query"}]}]}, {"name": "DOMStorage", "methods": [{"name": "getDOMStorageEntries", "parameters": [{"name": "storageId"}]}, {"name": "setDOMStorageItem", "parameters": [{"name": "storageId"}, {"name": "key"}, {"name": "value"}]}, {"name": "removeDOMStorageItem", "parameters": [{"name": "storageId"}, {"name": "key"}]}]}, {"name": "ApplicationCache", "methods": [{"name": "getApplicationCaches", "parameters": []}]}, {"name": "DOM", "methods": [{"name": "getChildNodes", "parameters": [{"name": "nodeId"}]}, {"name": "setAttribute", "parameters": [{"name": "elementId"}, {"name": "name"}, {"name": "value"}]}, {"name": "removeAttribute", "parameters": [{"name": "elementId"}, {"name": "name"}]}, {"name": "setTextNodeValue", "parameters": [{"name": "nodeId"}, {"name": "value"}]}, {"name": "getEventListenersForNode", "parameters": [{"name": "nodeId"}]}, {"name": "copyNode", "parameters": [{"name": "nodeId"}]}, {"name": "removeNode", "parameters": [{"name": "nodeId"}]}, {"name": "changeTagName", "parameters": [{"name": "nodeId"}, {"name": "newTagName"}]}, {"name": "getOuterHTML", "parameters": [{"name": "nodeId"}]}, {"name": "setOuterHTML", "parameters": [{"name": "nodeId"}, {"name": "outerHTML"}]}, {"name": "addInspectedNode", "parameters": [{"name": "nodeId"}]}, {"name": "performSearch", "parameters": [{"name": "query"}, {"name": "runSynchronously"}]}, {"name": "searchCanceled", "parameters": []}, {"name": "pushNodeByPathToFrontend", "parameters": [{"name": "path"}]}, {"name": "resolveNode", "parameters": [{"name": "nodeId"}]}, {"name": "getNodeProperties", "parameters": [{"name": "nodeId"}, {"name": "propertiesArray"}]}, {"name": "getNodePrototypes", "parameters": [{"name": "nodeId"}]}, {"name": "pushNodeToFrontend", "parameters": [{"name": "objectId"}]}]}, {"name": "CSS", "methods": [{"name": "getStylesForNode", "parameters": [{"name": "nodeId"}]}, {"name": "getComputedStyleForNode", "parameters": [{"name": "nodeId"}]}, {"name": "getInlineStyleForNode", "parameters": [{"name": "nodeId"}]}, {"name": "getAllStyles", "parameters": []}, {"name": "getStyleSheet", "parameters": [{"name": "styleSheetId"}]}, {"name": "getStyleSheetText", "parameters": [{"name": "styleSheetId"}]}, {"name": "setStyleSheetText", "parameters": [{"name": "styleSheetId"}, {"name": "text"}]}, {"name": "setPropertyText", "parameters": [{"name": "styleId"}, {"name": "propertyIndex"}, {"name": "text"}, {"name": "overwrite"}]}, {"name": "toggleProperty", "parameters": [{"name": "styleId"}, {"name": "propertyIndex"}, {"name": "disable"}]}, {"name": "setRuleSelector", "parameters": [{"name": "ruleId"}, {"name": "selector"}]}, {"name": "addRule", "parameters": [{"name": "contextNodeId"}, {"name": "selector"}]}, {"name": "getSupportedCSSProperties", "parameters": []}, {"name": "querySelectorAll", "parameters": [{"name": "documentId"}, {"name": "selector"}]}]}, {"name": "Timeline", "methods": []}, {"name": "Debugger", "methods": [{"name": "activateBreakpoints", "parameters": []}, {"name": "deactivateBreakpoints", "parameters": []}, {"name": "setJavaScriptBreakpoint", "parameters": [{"name": "url"}, {"name": "lineNumber"}, {"name": "columnNumber"}, {"name": "condition"}, {"name": "enabled"}]}, {"name": "setJavaScriptBreakpointBySourceId", "parameters": [{"name": "sourceId"}, {"name": "lineNumber"}, {"name": "columnNumber"}, {"name": "condition"}, {"name": "enabled"}]}, {"name": "removeJavaScriptBreakpoint", "parameters": [{"name": "breakpointId"}]}, {"name": "continueToLocation", "parameters": [{"name": "sourceId"}, {"name": "lineNumber"}, {"name": "columnNumber"}]}, {"name": "stepOver", "parameters": []}, {"name": "stepInto", "parameters": []}, {"name": "stepOut", "parameters": []}, {"name": "pause", "parameters": []}, {"name": "resume", "parameters": []}, {"name": "editScriptSource", "parameters": [{"name": "sourceID"}, {"name": "newContent"}]}, {"name": "getScriptSource", "parameters": [{"name": "sourceID"}]}, {"name": "setPauseOnExceptionsState", "parameters": [{"name": "pauseOnExceptionsState"}]}, {"name": "evaluateOnCallFrame", "parameters": [{"name": "callFrameId"}, {"name": "expression"}, {"name": "objectGroup"}, {"name": "includeCommandLineAPI"}]}, {"name": "getCompletionsOnCallFrame", "parameters": [{"name": "callFrameId"}, {"name": "expression"}, {"name": "includeCommandLineAPI"}]}]}, {"name": "BrowserDebugger", "methods": [{"name": "setAllBrowserBreakpoints", "parameters": [{"name": "breakpoints"}]}, {"name": "setDOMBreakpoint", "parameters": [{"name": "nodeId"}, {"name": "type"}]}, {"name": "removeDOMBreakpoint", "parameters": [{"name": "nodeId"}, {"name": "type"}]}, {"name": "setEventListenerBreakpoint", "parameters": [{"name": "eventName"}]}, {"name": "removeEventListenerBreakpoint", "parameters": [{"name": "eventName"}]}, {"name": "setXHRBreakpoint", "parameters": [{"name": "url"}]}, {"name": "removeXHRBreakpoint", "parameters": [{"name": "url"}]}]}, {"name": "Profiler", "methods": [{"name": "getProfileHeaders", "parameters": []}, {"name": "getProfile", "parameters": [{"name": "type"}, {"name": "uid"}]}, {"name": "removeProfile", "parameters": [{"name": "type"}, {"name": "uid"}]}, {"name": "clearProfiles", "parameters": []}, {"name": "takeHeapSnapshot", "parameters": [{"name": "detailed"}]}]}, {"name": "InspectorNotify", "methods": [{"parameters": [], "name": "frontendReused"}, {"parameters": [{"name": "nodeIds"}], "name": "addNodesToSearchResult"}, {"parameters": [], "name": "bringToFront"}, {"parameters": [], "name": "disconnectFromBackend"}, {"parameters": [{"name": "url"}], "name": "inspectedURLChanged"}, {"parameters": [{"name": "time"}], "name": "domContentEventFired"}, {"parameters": [{"name": "time"}], "name": "loadEventFired"}, {"parameters": [], "name": "reset"}, {"parameters": [{"name": "panel"}], "name": "showPanel"}, {"parameters": [{"name": "testCallId"}, {"name": "script"}], "name": "evaluateForTestInFrontend"}, {"parameters": [{"name": "nodeId"}], "name": "updateFocusedNode"}]}, {"name": "ConsoleNotify", "methods": [{"parameters": [{"name": "messageObj"}], "name": "addConsoleMessage"}, {"parameters": [{"name": "count"}], "name": "updateConsoleMessageExpiredCount"}, {"parameters": [{"name": "count"}], "name": "updateConsoleMessageRepeatCount"}, {"parameters": [], "name": "consoleMessagesCleared"}]}, {"name": "NetworkNotify", "methods": [{"parameters": [{"name": "frameId"}], "name": "frameDetachedFromParent"}, {"parameters": [{"name": "identifier"}, {"name": "url"}, {"name": "loader"}, {"name": "callStack"}], "name": "identifierForInitialRequest"}, {"parameters": [{"name": "identifier"}, {"name": "time"}, {"name": "request"}, {"name": "redirectResponse"}], "name": "willSendRequest"}, {"parameters": [{"name": "identifier"}], "name": "markResourceAsCached"}, {"parameters": [{"name": "identifier"}, {"name": "time"}, {"name": "resourceType"}, {"name": "response"}], "name": "didReceiveResponse"}, {"parameters": [{"name": "identifier"}, {"name": "time"}, {"name": "lengthReceived"}], "name": "didReceiveContentLength"}, {"parameters": [{"name": "identifier"}, {"name": "finishTime"}], "name": "didFinishLoading"}, {"parameters": [{"name": "identifier"}, {"name": "time"}, {"name": "localizedDescription"}], "name": "didFailLoading"}, {"parameters": [{"name": "time"}, {"name": "resource"}], "name": "didLoadResourceFromMemoryCache"}, {"parameters": [{"name": "identifier"}, {"name": "sourceString"}, {"name": "type"}], "name": "setInitialContent"}, {"parameters": [{"name": "frame"}, {"name": "loader"}], "name": "didCommitLoadForFrame"}, {"parameters": [{"name": "identifier"}, {"name": "requestURL"}], "name": "didCreateWebSocket"}, {"parameters": [{"name": "identifier"}, {"name": "time"}, {"name": "request"}], "name": "willSendWebSocketHandshakeRequest"}, {"parameters": [{"name": "identifier"}, {"name": "time"}, {"name": "response"}], "name": "didReceiveWebSocketHandshakeResponse"}, {"parameters": [{"name": "identifier"}, {"name": "time"}], "name": "didCloseWebSocket"}]}, {"name": "DatabaseNotify", "methods": [{"parameters": [{"name": "database"}], "name": "addDatabase"}, {"parameters": [{"name": "databaseId"}], "name": "selectDatabase"}, {"parameters": [{"name": "transactionId"}, {"name": "columnNames"}, {"name": "values"}], "name": "sqlTransactionSucceeded"}, {"parameters": [{"name": "transactionId"}, {"name": "sqlError"}], "name": "sqlTransactionFailed"}]}, {"name": "DOMStorageNotify", "methods": [{"parameters": [{"name": "storage"}], "name": "addDOMStorage"}, {"parameters": [{"name": "storageId"}], "name": "updateDOMStorage"}, {"parameters": [{"name": "storageId"}], "name": "selectDOMStorage"}]}, {"name": "ApplicationCacheNotify", "methods": [{"parameters": [{"name": "status"}], "name": "updateApplicationCacheStatus"}, {"parameters": [{"name": "isNowOnline"}], "name": "updateNetworkState"}]}, {"name": "DOMNotify", "methods": [{"parameters": [{"name": "root"}], "name": "setDocument"}, {"parameters": [{"name": "id"}, {"name": "attributes"}], "name": "attributesUpdated"}, {"parameters": [{"name": "id"}, {"name": "newValue"}], "name": "characterDataModified"}, {"parameters": [{"name": "parentId"}, {"name": "nodes"}], "name": "setChildNodes"}, {"parameters": [{"name": "root"}], "name": "setDetachedRoot"}, {"parameters": [{"name": "id"}, {"name": "newValue"}], "name": "childNodeCountUpdated"}, {"parameters": [{"name": "parentId"}, {"name": "prevId"}, {"name": "node"}], "name": "childNodeInserted"}, {"parameters": [{"name": "parentId"}, {"name": "id"}], "name": "childNodeRemoved"}]}, {"name": "TimelineNotify", "methods": [{"parameters": [], "name": "timelineProfilerWasStarted"}, {"parameters": [], "name": "timelineProfilerWasStopped"}, {"parameters": [{"name": "record"}], "name": "addRecordToTimeline"}]}, {"name": "DebuggerNotify", "methods": [{"parameters": [], "name": "debuggerWasEnabled"}, {"parameters": [], "name": "debuggerWasDisabled"}, {"parameters": [{"name": "sourceID"}, {"name": "url"}, {"name": "lineOffset"}, {"name": "columnOffset"}, {"name": "length"}, {"name": "scriptWorldType"}], "name": "parsedScriptSource"}, {"parameters": [{"name": "url"}, {"name": "data"}, {"name": "firstLine"}, {"name": "errorLine"}, {"name": "errorMessage"}], "name": "failedToParseScriptSource"}, {"parameters": [{"name": "breakpointId"}, {"name": "sourceId"}, {"name": "lineNumber"}, {"name": "columnNumber"}], "name": "breakpointResolved"}, {"parameters": [{"name": "details"}], "name": "pausedScript"}, {"parameters": [], "name": "resumedScript"}, {"parameters": [{"name": "id"}, {"name": "url"}, {"name": "isShared"}], "name": "didCreateWorker"}, {"parameters": [{"name": "id"}], "name": "didDestroyWorker"}]}, {"name": "ProfilerNotify", "methods": [{"parameters": [], "name": "profilerWasEnabled"}, {"parameters": [], "name": "profilerWasDisabled"}, {"parameters": [{"name": "header"}], "name": "addProfileHeader"}, {"parameters": [{"name": "uid"}, {"name": "chunk"}], "name": "addHeapSnapshotChunk"}, {"parameters": [{"name": "uid"}], "name": "finishHeapSnapshot"}, {"parameters": [{"name": "isProfiling"}], "name": "setRecordingProfile"}, {"parameters": [], "name": "resetProfiles"}, {"parameters": [{"name": "done"}, {"name": "total"}], "name": "reportHeapSnapshotProgress"}]}], "name": "core"}, {"interfaces": [{"name": "InspectorFrontendHost", "methods": [{"name": "loaded", "parameters": []}, {"name": "closeWindow", "parameters": []}, {"name": "disconnectFromBackend", "parameters": []}, {"name": "bringToFront", "parameters": []}, {"name": "inspectedURLChanged", "parameters": [{"name": "newURL"}]}, {"name": "requestAttachWindow", "parameters": []}, {"name": "requestDetachWindow", "parameters": []}, {"name": "setAttachedWindowHeight", "parameters": [{"name": "height"}]}, {"name": "moveWindowBy", "parameters": [{"name": "x"}, {"name": "y"}]}, {"name": "setExtensionAPI", "parameters": [{"name": "script"}]}, {"name": "localizedStringsURL", "parameters": []}, {"name": "hiddenPanels", "parameters": []}, {"name": "copyText", "parameters": [{"name": "text"}]}, {"parameters": [], "name": "platform"}, {"parameters": [], "name": "port"}, {"parameters": [{"name": "event"}, {"name": "items"}], "name": "showContextMenu"}, {"name": "sendMessageToBackend", "parameters": [{"name": "message"}]}]}], "name": "core"}, {"interfaces": [{"name": "WeinreClientCommands", "methods": [{"name": "registerClient", "parameters": []}, {"name": "getTargets", "parameters": []}, {"name": "getClients", "parameters": []}, {"name": "connectTarget", "parameters": [{"name": "clientId"}, {"name": "targetId"}]}, {"name": "disconnectTarget", "parameters": [{"name": "clientId"}]}, {"name": "getExtensions", "parameters": []}, {"name": "logDebug", "parameters": [{"name": "message"}]}, {"name": "logInfo", "parameters": [{"name": "message"}]}, {"name": "logWarning", "parameters": [{"name": "message"}]}, {"name": "logError", "parameters": [{"name": "message"}]}]}], "name": "weinre"}, {"interfaces": [{"name": "WeinreClientEvents", "methods": [{"name": "clientRegistered", "parameters": [{"name": "client"}]}, {"name": "targetRegistered", "parameters": [{"name": "target"}]}, {"name": "clientUnregistered", "parameters": [{"name": "clientId"}]}, {"name": "targetUnregistered", "parameters": [{"name": "targetId"}]}, {"name": "connectionCreated", "parameters": [{"name": "clientId"}, {"name": "targetId"}]}, {"name": "connectionDestroyed", "parameters": [{"name": "clientId"}, {"name": "targetId"}]}, {"name": "sendCallback", "parameters": [{"name": "callbackId"}, {"name": "result"}]}, {"name": "serverProperties", "parameters": [{"name": "properties"}]}]}], "name": "weinre"}, {"interfaces": [{"name": "WeinreExtraClientCommands", "methods": [{"name": "getDatabases", "parameters": []}]}], "name": "weinre"}, {"interfaces": [{"name": "WeinreExtraTargetEvents", "methods": [{"name": "databaseOpened", "parameters": [{"name": "databaseRecord"}]}]}], "name": "weinre"}, {"interfaces": [{"name": "WeinreTargetCommands", "methods": [{"name": "registerTarget", "parameters": [{"name": "url"}]}, {"name": "sendClientCallback", "parameters": [{"name": "callbackId"}, {"name": "args"}]}, {"name": "logDebug", "parameters": [{"name": "message"}]}, {"name": "logInfo", "parameters": [{"name": "message"}]}, {"name": "logWarning", "parameters": [{"name": "message"}]}, {"name": "logError", "parameters": [{"name": "message"}]}]}], "name": "weinre"}, {"interfaces": [{"name": "WeinreTargetEvents", "methods": [{"name": "connectionCreated", "parameters": [{"name": "clientId"}, {"name": "targetId"}]}, {"name": "connectionDestroyed", "parameters": [{"name": "clientId"}, {"name": "targetId"}]}, {"name": "sendCallback", "parameters": [{"name": "callbackId"}, {"name": "result"}]}]}], "name": "weinre"}])\n//@ sourceURL=interfaces/all-json-idls-min.js'),modjewel.require("weinre/target/Target").main()})();