
$ErrorFormatString = "{0}`n{1}`n" +
                     "    + CategoryInfo          : {2}`n" +
                     "    + FullyQualifiedErrorId : {3}`n"

function Remove-DirItems {
  param (
    [Parameter(Mandatory = $True)]
    [string]$Path
  )

  If (Test-Path $Path) {
    Get-ChildItem -Recurse $Path | Remove-Item -Recurse -Force -Confirm:$false
  }
}

function Restore-ServiceFiles {
  param (
    [Parameter(Mandatory = $True)]
    [string]$BackupPath,

    [Parameter(Mandatory = $True)]
    [string]$RestorePath
  )
  Write-Debug "BackupPath:  $BackupPath"
  Write-Debug "RestorePath: $RestorePath"

  New-Item -Path $RestorePath -ItemType Directory -Force | Out-Null
  Copy-Item -Path "$BackupPath\*" -Destination $RestorePath -Recurse -Force
  Get-ChildItem -Path $RestorePath -Exclude *exe*, *xml* | Remove-Item -Force -Confirm:$false
}

function Write-ErrorToHost {
  param (
    [Parameter(Mandatory = $True, Position=0)]
    [string]$ErrorToWrite
  )
  Write-Host -Foreground Red -Background Black $ErrorToWrite
}

function Find-LockingProcesses([string] $LockedFile) {
  $processes = Get-Process
  [Int32[]] $lockingProcesses = @();

  $processes | ForEach-Object {
    $process = $_
    $modules = $process.Modules

    $modules | ForEach-Object {
      $module = $_
      if ($module.FileName -eq $LockedFile) {
        $lockingProcesses += $process.Id
      }
    }
  }

  return $lockingProcesses
}

function Stop-Processes([Int32[]] $Ids) {
  $Ids | ForEach-Object {
    $id = $_
    $stoppingProcess = Stop-Process -Id $id -Force -PassThru
    $stoppingProcess.WaitForExit()
  } 
}

function Stop-ServicesSafe([string[]] $Names) {
  $services = Get-Service

  $services | ForEach-Object {
    $service = $_
    $serviceName = $service.Name
  
    if ($serviceName -in $Names) {
      Stop-Service -Name $serviceName
    }
  }
}
