Param(
  [Parameter(Mandatory = $True)]
  [string]$upgradeDirPath,

  [Parameter(Mandatory = $True)]
  [string]$baseDirPath,

  [Parameter(Mandatory = $True)]
  [string]$upgradeServerDirPath
)

function Start-NodeUpgrade {
  $nodeExecutableDestinationDirectoryPath = (Join-Path $baseDirPath "node")
  $nodeExecutableSourcePath = (Join-Path $upgradeDirPath "1-Executables\node\x64\node.exe")
  $nodeExecutableDestinationPath = (Join-Path $nodeExecutableDestinationDirectoryPath "node.exe")
  $nodeLockingProcessesIds = Find-LockingProcesses -LockedFile $nodeExecutableDestinationPath
  if ($nodeLockingProcessesIds) {
    Stop-Processes -Ids $nodeLockingProcessesIds
  }
  New-Item -Path $nodeExecutableDestinationDirectoryPath -ItemType Directory -Force
  Copy-Item -Path $nodeExecutableSourcePath -Destination $nodeExecutableDestinationPath -Force
  Write-Debug "Node installed."
}

function Invoke-7ZipUpgrage([string] $upgradeDirPath, [string] $baseDirPath) {
  $destinationPath = Join-Path $baseDirPath "7zip"
  New-Item -Path $destinationPath -ItemType Directory -Force

  $destinationPathFiles = Get-ChildItem $destinationPath -File -Recurse
  ForEach ($filePath in $destinationPathFiles) {
    $lockingIds = Find-LockingProcesses -LockedFile $filePath
    if ($lockingIds) {
      Stop-Processes -Ids $lockingIds
    }
  }
  Get-ChildItem "$destinationPath\*" -Recurse | Remove-Item -Force

  $sourcePath = Join-Path $upgradeDirPath "1-Executables\7zip\x64"
  Copy-Item -Path "$sourcePath\*" -Destination $destinationPath -Recurse -Force
  Write-Debug "7Zip installed."
}

function Start-NodeUpgrade {
  $nodeExecutableDestinationDirectoryPath = (Join-Path $baseDirPath "node")
  $nodeExecutableSourcePath = (Join-Path $upgradeDirPath "1-Executables\node\x64\node.exe")
  $nodeExecutableDestinationPath = (Join-Path $nodeExecutableDestinationDirectoryPath "node.exe")
  $nodeLockingProcessesIds = Find-LockingProcesses -LockedFile $nodeExecutableDestinationPath
  if ($nodeLockingProcessesIds) {
    Stop-Processes -Ids $nodeLockingProcessesIds
  }
  New-Item -Path $nodeExecutableDestinationDirectoryPath -ItemType Directory -Force
  Copy-Item -Path $nodeExecutableSourcePath -Destination $nodeExecutableDestinationPath -Force
  Write-Debug "Node installed."
}

function Start-UpgradeTimezoneConvertor {
  $timeZoneExecutableDestinationDirectoryPath = (Join-Path $baseDirPath "Packages")
  $timeZoneExecutableSourcePath = (Join-Path $upgradeDirPath "1-Executables\timezoneconverter\timezoneconverter.nupkg")
  $timeZoneExecutableDestinationPath = (Join-Path $timeZoneExecutableDestinationDirectoryPath "timezoneconverter.nupkg")

  New-Item -Path $timeZoneExecutableDestinationDirectoryPath -ItemType Directory -Force
  Copy-Item -Path $timeZoneExecutableSourcePath -Destination $timeZoneExecutableDestinationPath -Force
  Write-Debug "TimeZone Convertor installed."
}

$isDebug = $DebugPreference -ne "SilentlyContinue"

$configFileName = "installation-definition.json"
$configFilePath = Join-Path $upgradeDirPath $configFileName
$global:Config = Get-Content $configFilePath -Raw | ConvertFrom-Json
$global:Config = $global:Config.config
$global:Config.PSObject.Properties | ForEach-Object {
  Write-Debug "Setting environment variable `"$($_.Name)`" to `"$($_.Value)`""
  Set-Item -Path "env:$($_.Name)" -Value $_.Value
}

. "$PSScriptRoot\Upgrade-ServerHelperFunctions.ps1"

$serviceInstallScriptPath = (Join-Path $upgradeDirPath "4-Powershell\Install-SignageOSAsService.ps1")
$installKioskScriptApp = (Join-Path $upgradeDirPath "4-Powershell\Install-KioskAppBundleAsKiosk.ps1")
$setFirewallAndProxy = (Join-Path $upgradeDirPath "4-Powershell\Set-FirewallAndProxyConfiguration.ps1")

Remove-DirItems -Path $serverDirPath
Write-Debug "Server directory cleared."

Copy-Item -Path "$upgradeServerDirPath\*" -Destination $serverDirPath -Recurse -Force
Write-Debug "Server upgrade copied."

Start-NodeUpgrade
Start-UpgradeTimezoneConvertor
Invoke-7ZipUpgrage -upgradeDirPath $upgradeDirPath -baseDirPath $baseDirPath

.$installKioskScriptApp
Write-Debug "New kiosk app installed."

.$serviceInstallScriptPath
Write-Debug "New services installed."

.$setFirewallAndProxy
Write-Debug "Firewall and proxy configuration set."

Restart-Computer -Force -WhatIf:$isDebug
if ($isDebug) {
  Exit
}
