param(
    [Parameter(Mandatory=$true)]
    [string]$Name
)

$ErrorActionPreference = "Stop"

# Define the path to the secret
$secretsDir = Join-Path -Path $env:ProgramData -ChildPath "SignageOS\Secrets"
$keyPath = Join-Path -Path $secretsDir -ChildPath "$Name.bin"

# Check if the key exists
if (!(Test-Path -Path $keyPath)) {
    @{
        Success = $false
        Message = "Key not found"
        KeyData = $null
    }
    exit
}

try {
    # Read the content
    $keyData = Get-Content -Path $keyPath -Raw
    
    @{
        Success = $true
        KeyData = $keyData
    }
} catch {
    @{
        Success = $false
        Message = $_.Exception.Message
        KeyData = $null
    }
} 