
$ALL_DISPLAYS_SAME_SCALING = 1;
$100_PERCENT_SCALING = 96;

function Set-DisplayScalingLevel([int] $Level) {
	[string] $desktopRegistry = 'HKCU:\Control Panel\Desktop';

	New-ItemProperty `
		-Path $desktopRegistry `
		-Name 'Win8DpiScaling' `
		-PropertyType "DWord" `
		-Value $ALL_DISPLAYS_SAME_SCALING `
		-Force `
		| Out-Null;
	
	New-ItemProperty `
		-Path $desktopRegistry `
		-Name 'DesktopDPIOverride' `
		-PropertyType "DWord" `
		-Value $Level `
		-Force `
		| Out-Null;
	
	New-ItemProperty `
		-Path $desktopRegistry `
		-Name 'LogPixels' `
		-PropertyType "DWord" `
		-Value $100_PERCENT_SCALING `
		-Force `
		| Out-Null;

}
