
function Get-DisplayResolutionList {
	$Model = "CIM_VideoControllerResolution"
	$Query = "SELECT * FROM $Model"
	$controllerResolutionlist = Get-WMIObject -query $Query | Select-Object HorizontalResolution, VerticalResolution, RefreshRate

	[System.Collections.ArrayList] $resolutionList = @()
	$controllerResolutionlist | ForEach-Object {
		$resolutionList.Add(@{
			width = $_.HorizontalResolution;
			height = $_.VerticalResolution;
			framerate = $_.RefreshRate;
		}) > $null
	}

	return $resolutionList
}
