
function Get-DisplayResolution {
	$Model = "CIM_VideoController"
	$Query = "SELECT * FROM $Model"
	$resolution = Get-WMIObject -query $Query | Select-Object CurrentHorizontalResolution, CurrentVerticalResolution, CurrentRefreshRate

	return @{
		width = $resolution.CurrentHorizontalResolution;
		height = $resolution.CurrentVerticalResolution;
		framerate = $resolution.CurrentRefreshRate;
	}
}
