
[Reflection.Assembly]::LoadFile("C:\signageos\Packages\TimeZoneConverter.3.2.0\lib\net45\TimeZoneConverter.dll") | Out-Null

# note that culture is dependent on user's preferences 
$cultureNameIdentifier = Get-Culture  | Select-Object -ExpandProperty "Name" # i.e cs-CZ, en-US
$regionInfo = New-Object System.Globalization.RegionInfo $cultureNameIdentifier
$regionTwoLetterName = $regionInfo.TwoLetterISORegionName # i.e CZ, US
$windowsTimezoneId = Get-TimeZone | Select-Object -ExpandProperty "Id"

$ianaTimeZoneFormat = [TimeZoneConverter.TzConvert]::WindowsToIana($windowsTimezoneId, $regionTwoLetterName)

@{
  TimeZoneId = $ianaTimeZoneFormat;
}
