
Param(
	[Parameter(
		Mandatory = $True,
		ParameterSetName = "Muted"
	)]
	[switch]
	$Muted,

	[Parameter(
		Mandatory = $True,
		ParameterSetName = "VolumeLevel"
	)]
	[ValidateRange(0, 100)]
	[Int]
	$VolumeLevel
)

Add-Type -Path $PSScriptRoot\COMAudio.cs

if ($Muted -ne $null) {
	[audio]::Mute = $Muted
}

[audio]::Volume = [math]::Round($VolumeLevel / 100, 2)

@{CurrentAudioLevel = ([math]::Round([audio]::Volume * 100)); Muted = [audio]::Mute }
