Param(
  [Parameter(Mandatory = $True)]
  [string]$upgradeArchiveUrl
)

$ErrorActionPreference = 'Stop'

$baseDir = Resolve-Path -Path "\signageos"

$upgradeScriptsSourceDirPath = (Join-Path $baseDir "server\powershell\upgrade")
$upgradeScriptsDestinationDirName = "upgrade_scripts"
$upgradeScriptsDestinationDirPath = (Join-Path $baseDir $upgradeScriptsDestinationDirName)

If (Test-Path $upgradeScriptsDestinationDirPath) {
  Get-ChildItem -Recurse $upgradeScriptsDestinationDirPath | Remove-Item -Recurse -Confirm:$false
}
Else {
  New-Item -Path $baseDir -ItemType Directory -Name $upgradeScriptsDestinationDirName -Force | Out-Null
}

Copy-Item -Path "$upgradeScriptsSourceDirPath\*" -Destination $upgradeScriptsDestinationDirPath -Recurse -Force

$createUpgradeProcessParams = @{
  Class = "Win32_Process";
  Name = "Create";
  ArgumentList = @(
    "powershell.exe $upgradeScriptsDestinationDirPath\Upgrade-ServerHelper.ps1 -upgradeArchiveUrl $upgradeArchiveUrl";
    "$baseDir";
  );
}
Invoke-WmiMethod @createUpgradeProcessParams
