Param(
  [Parameter(Mandatory = $true)]
  [string]
  $screenshotFilePath
)

[void][Reflection.Assembly]::LoadWithPartialName("System.Drawing")
[void][Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")

$dpi = Get-ItemProperty -Path "Registry::HKEY_CURRENT_USER\Control Panel\Desktop\WindowMetrics\" | Select-Object -ExpandProperty AppliedDPI
if ($null -eq $dpi) {
  $dpi = 96
}
$scaleFactor = $dpi / 96

$workingArea = [System.Windows.Forms.SystemInformation]::PrimaryMonitorSize
$drawingSize = [Drawing.Size]::new($workingArea.Width * $scaleFactor, $workingArea.Height * $scaleFactor)

$bmp = New-Object Drawing.Bitmap $drawingSize.Width, $drawingSize.Height
$graphics = [Drawing.Graphics]::FromImage($bmp)

Try {
  $graphics.CopyFromScreen($workingArea.Left, $workingArea.Top, 0, 0, $drawingSize)
  $bmp.Save("$screenshotFilePath")
} Finally {
  $graphics.Dispose()
  $bmp.Dispose()
}
