Param(
  [Parameter()]
  [string]
  $ApplicationName,

  [Parameter()]
  [string]
  $CommandLine
)

Add-Type -Path $PSScriptRoot\Create-ProcessAsUser.cs

$processInformation = New-Object PROCESS_INFORMATION
$hasUserPocessStarted = [Toolkit.ApplicationLoader]::StartProcessAndBypassUAC($ApplicationName, $CommandLine, [ref]$processInformation)

if (-Not $hasUserPocessStarted) {
  throw "Create process as currently active user failed. Session id: $sessionId"
}

$processCreatedAsUser = Get-Process | Where-Object { $_.Id -eq $processInformation.dwProcessId }
if ($processCreatedAsUser) {
  $processCreatedAsUser.WaitForExit()
}

$exitCode = $processCreatedAsUser.GetType().GetField('exitCode', 'NonPublic, Instance').GetValue($processCreatedAsUser)
if ($exitCode -ne 0) {
  throw "$ApplicationName $CommandLine exited with status code $exitCode"
}
