import fs from 'node:fs';
import os from 'node:os';
import process from 'node:process';
export function isWritable(path) {
    try {
        fs.accessSync(path, fs.constants.W_OK);
        return true;
    }
    catch (err) {
        return false;
    }
}
export function controlPath(host) {
    let c = 'ssh-' + host;
    if ('CI' in process.env && isWritable('/dev/shm')) {
        return `/dev/shm/${c}`;
    }
    return `${os.homedir()}/.ssh/${c}`;
}
export function escapeshellarg(arg) {
    if (/^[a-z0-9/_.\-@:=]+$/i.test(arg) || arg === '') {
        return arg;
    }
    return (`$'` +
        arg
            .replace(/\\/g, '\\\\')
            .replace(/'/g, '\\\'')
            .replace(/\f/g, '\\f')
            .replace(/\n/g, '\\n')
            .replace(/\r/g, '\\r')
            .replace(/\t/g, '\\t')
            .replace(/\v/g, '\\v')
            .replace(/\0/g, '\\0') +
        `'`);
}
