import { dealias, isFile, isSync, isSyncFile, } from './options.js';
import { WriteStream, WriteStreamSync } from '@isaacs/fs-minipass';
import path from 'node:path';
import { list } from './list.js';
import { Pack, PackSync } from './pack.js';
export function create(opt_, files, cb) {
    if (typeof files === 'function') {
        cb = files;
    }
    if (Array.isArray(opt_)) {
        ;
        (files = opt_), (opt_ = {});
    }
    if (!files || !Array.isArray(files) || !files.length) {
        throw new TypeError('no files or directories specified');
    }
    files = Array.from(files);
    const opt = dealias(opt_);
    if (opt.sync && typeof cb === 'function') {
        throw new TypeError('callback not supported for sync tar functions');
    }
    if (!opt.file && typeof cb === 'function') {
        throw new TypeError('callback only supported with file option');
    }
    return isSyncFile(opt)
        ? createFileSync(opt, files)
        : isFile(opt)
            ? createFile(opt, files, cb)
            : isSync(opt)
                ? createSync(opt, files)
                : create_(opt, files);
}
const createFileSync = (opt, files) => {
    const p = new PackSync(opt);
    const stream = new WriteStreamSync(opt.file, {
        mode: opt.mode || 0o666,
    });
    p.pipe(stream);
    addFilesSync(p, files);
};
const createFile = (opt, files, cb) => {
    const p = new Pack(opt);
    const stream = new WriteStream(opt.file, {
        mode: opt.mode || 0o666,
    });
    p.pipe(stream);
    const promise = new Promise((res, rej) => {
        stream.on('error', rej);
        stream.on('close', res);
        p.on('error', rej);
    });
    addFilesAsync(p, files);
    return cb ? promise.then(cb, cb) : promise;
};
const addFilesSync = (p, files) => {
    files.forEach(file => {
        if (file.charAt(0) === '@') {
            list({
                file: path.resolve(p.cwd, file.slice(1)),
                sync: true,
                noResume: true,
                onentry: entry => p.add(entry),
            });
        }
        else {
            p.add(file);
        }
    });
    p.end();
};
const addFilesAsync = async (p, files) => {
    for (let i = 0; i < files.length; i++) {
        const file = String(files[i]);
        if (file.charAt(0) === '@') {
            await list({
                file: path.resolve(String(p.cwd), file.slice(1)),
                noResume: true,
                onentry: entry => {
                    p.add(entry);
                },
            });
        }
        else {
            p.add(file);
        }
    }
    p.end();
};
const createSync = (opt, files) => {
    const p = new PackSync(opt);
    addFilesSync(p, files);
    return p;
};
const create_ = (opt, files) => {
    const p = new Pack(opt);
    addFilesAsync(p, files);
    return p;
};
//# sourceMappingURL=create.js.map