"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.list = void 0;
// tar -t
const fsm = __importStar(require("@isaacs/fs-minipass"));
const node_fs_1 = __importDefault(require("node:fs"));
const path_1 = require("path");
const options_js_1 = require("./options.js");
const parse_js_1 = require("./parse.js");
const strip_trailing_slashes_js_1 = require("./strip-trailing-slashes.js");
function list(opt_, files, cb) {
    if (typeof opt_ === 'function') {
        ;
        (cb = opt_), (files = undefined), (opt_ = {});
    }
    else if (Array.isArray(opt_)) {
        ;
        (files = opt_), (opt_ = {});
    }
    if (typeof files === 'function') {
        ;
        (cb = files), (files = undefined);
    }
    if (!files) {
        files = [];
    }
    else {
        files = Array.from(files);
    }
    const opt = (0, options_js_1.dealias)(opt_);
    if (opt.sync && typeof cb === 'function') {
        throw new TypeError('callback not supported for sync tar functions');
    }
    if (!opt.file && typeof cb === 'function') {
        throw new TypeError('callback only supported with file option');
    }
    if (files.length) {
        filesFilter(opt, files);
    }
    if (!opt.noResume) {
        onentryFunction(opt);
    }
    return (0, options_js_1.isSyncFile)(opt)
        ? listFileSync(opt)
        : (0, options_js_1.isFile)(opt)
            ? listFile(opt, cb)
            : list_(opt);
}
exports.list = list;
const onentryFunction = (opt) => {
    const onentry = opt.onentry;
    opt.onentry = onentry
        ? e => {
            onentry(e);
            e.resume();
        }
        : e => e.resume();
};
// construct a filter that limits the file entries listed
// include child entries if a dir is included
const filesFilter = (opt, files) => {
    const map = new Map(files.map(f => [(0, strip_trailing_slashes_js_1.stripTrailingSlashes)(f), true]));
    const filter = opt.filter;
    const mapHas = (file, r = '') => {
        const root = r || (0, path_1.parse)(file).root || '.';
        let ret;
        if (file === root)
            ret = false;
        else {
            const m = map.get(file);
            if (m !== undefined) {
                ret = m;
            }
            else {
                ret = mapHas((0, path_1.dirname)(file), root);
            }
        }
        map.set(file, ret);
        return ret;
    };
    opt.filter = filter
        ? (file, entry) => filter(file, entry) && mapHas((0, strip_trailing_slashes_js_1.stripTrailingSlashes)(file))
        : file => mapHas((0, strip_trailing_slashes_js_1.stripTrailingSlashes)(file));
};
const listFileSync = (opt) => {
    const p = list_(opt);
    const file = opt.file;
    let fd;
    try {
        const stat = node_fs_1.default.statSync(file);
        const readSize = opt.maxReadSize || 16 * 1024 * 1024;
        if (stat.size < readSize) {
            p.end(node_fs_1.default.readFileSync(file));
        }
        else {
            let pos = 0;
            const buf = Buffer.allocUnsafe(readSize);
            fd = node_fs_1.default.openSync(file, 'r');
            while (pos < stat.size) {
                const bytesRead = node_fs_1.default.readSync(fd, buf, 0, readSize, pos);
                pos += bytesRead;
                p.write(buf.subarray(0, bytesRead));
            }
            p.end();
        }
    }
    finally {
        if (typeof fd === 'number') {
            try {
                node_fs_1.default.closeSync(fd);
                /* c8 ignore next */
            }
            catch (er) { }
        }
    }
};
const listFile = (opt, cb) => {
    const parse = new parse_js_1.Parser(opt);
    const readSize = opt.maxReadSize || 16 * 1024 * 1024;
    const file = opt.file;
    const p = new Promise((resolve, reject) => {
        parse.on('error', reject);
        parse.on('end', resolve);
        node_fs_1.default.stat(file, (er, stat) => {
            if (er) {
                reject(er);
            }
            else {
                const stream = new fsm.ReadStream(file, {
                    readSize: readSize,
                    size: stat.size,
                });
                stream.on('error', reject);
                stream.pipe(parse);
            }
        });
    });
    return cb ? p.then(cb, cb) : p;
};
const list_ = (opt) => new parse_js_1.Parser(opt);
//# sourceMappingURL=list.js.map