import { isNil } from "../../util";
import { $push } from "../accumulator/push";
import { withMemo } from "./_internal";
function $locf(_, collection, expr, options) {
  return withMemo(
    collection,
    expr,
    () => {
      const values = $push(collection, expr.inputExpr, options);
      for (let i = 1; i < values.length; i++) {
        if (isNil(values[i]))
          values[i] = values[i - 1];
      }
      return values;
    },
    (series) => series[expr.documentNumber - 1]
  );
}
export {
  $locf
};
