import { RequestOpts, InitOverrideFunction, Configuration } from './models.js';
export * from './models.js';
/**
 * @private
 * This is the base class for all generated API classes.
 */
export declare class BaseAPI {
    protected configuration: Configuration;
    private middleware;
    private fetchApi;
    private parseError;
    private timeoutDuration;
    constructor(configuration: Configuration);
    protected request(context: RequestOpts, initOverrides?: RequestInit | InitOverrideFunction): Promise<Response>;
    private createFetchParams;
    private fetchWithTimeout;
    private fetch;
}
/**
 * @private
 */
export declare const COLLECTION_FORMATS: {
    csv: string;
    ssv: string;
    tsv: string;
    pipes: string;
};
/**
 * @private
 */
export type ModelPropertyNaming = 'camelCase' | 'snake_case' | 'PascalCase' | 'original';
/**
 * @private
 */
export interface Consume {
    contentType: string;
}
/**
 * @private
 */
export declare function validateRequiredRequestParams<TRequestParams extends {
    [key: string]: any;
}>(requestParameters: TRequestParams, keys: Array<Extract<keyof TRequestParams, string>>): void;
type QueryParamConfig = {
    isArray?: boolean;
    isCollectionFormatMulti?: boolean;
    collectionFormat?: keyof typeof COLLECTION_FORMATS;
};
/**
 * @private
 */
export declare function applyQueryParams<TRequestParams extends {
    [key: string]: any;
}, Key extends Extract<keyof TRequestParams, string>>(requestParameters: TRequestParams, keys: Array<{
    key: Key;
    config: QueryParamConfig;
}>): Pick<TRequestParams, Key>;
/**
 * @private
 */
export declare function parseFormParam(originalValue: number | boolean | string | Blob): Promise<string | Blob>;
