"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCacheUpdateStrategy = void 0;
/**
 * getCacheUpdateStrategy - This is the strategy to use for updating cached data, or a function to extract it
 *
 * @param passedInCacheStrategy The desired cache strategy, or function to build the cache Strategy based on arguments/context
 * @param args        The arguments the decorated method was called with
 * @param context     The instance whose method is being called
 * @param returnValue The result of the decorated method, used to calculate cache key
 *
 * @returns {String}
 */
const getCacheUpdateStrategy = (passedInCacheStrategy, args, context, returnValue) => passedInCacheStrategy instanceof Function
    ? passedInCacheStrategy(args, context, returnValue)
    : passedInCacheStrategy;
exports.getCacheUpdateStrategy = getCacheUpdateStrategy;
//# sourceMappingURL=getCacheUpdateStrategy.js.map