import { CacheKeyBuilder, CacheKeyDeleteBuilder } from '../interfaces';
import { PostRunKeyBuilder } from '../interfaces/PostRunKeyBuilder';
export declare type CacheClearKey = string | string[] | CacheKeyDeleteBuilder;
export declare type CacheableKey = string | CacheKeyBuilder;
export declare type CacheUpdateKey = string | CacheKeyBuilder | PostRunKeyBuilder;
/**
 * extractKey - If data should be stored in a hash, this would be the name of the hash
 *
 * @param passedInKey The desired key, or function to build the key based on arguments/context
 * @param args        The arguments the decorated method was called with
 * @param context     The instance whose method is being called
 *
 * @returns {String}
 */
export declare const extractKey: (passedInKey: string | string[] | CacheKeyBuilder<any[], any> | CacheKeyDeleteBuilder<any[], any> | PostRunKeyBuilder<any[], any, any> | undefined, args: any[], context?: any, returnValue?: any) => string | string[];
/**
 * getCacheKey - Determines the cache key to use. Either from an argument extractor function,
 *               string, or number that is passed in, or a hash based on args decorated function
 *               was called with (by default)
 *
 * @param methodName  The name of the method being called
 * @param passedInKey The desired key, or function to build the key based on arguments
 * @param args        The arguments the decorated method was called with
 * @param context     The instance whose method is being called
 *
 * @returns {String}
 */
export declare const getCacheKey: (passedInKey: string | string[] | CacheKeyBuilder<any[], any> | CacheKeyDeleteBuilder<any[], any> | PostRunKeyBuilder<any[], any, any> | undefined, methodName: string, args: any[], context?: any, returnValue?: any) => string | string[];
export declare const getFinalKey: (passedCacheKey: string | string[] | PostRunKeyBuilder<any[], any, any> | CacheKeyDeleteBuilder<any[], any> | CacheKeyBuilder<any[], any> | undefined, passedHashKey: string | CacheKeyBuilder<any[], any> | PostRunKeyBuilder<any[], any, any> | undefined, methodName: string, args: any[], context?: any, returnValue?: any) => string | string[];
