"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheUpdate = void 0;
const util_1 = require("../util");
const index_1 = require("../index");
const DefaultClearStrategy_1 = require("../strategies/DefaultClearStrategy");
const DefaultUpdateStrategy_1 = require("../strategies/DefaultUpdateStrategy");
/**
 * CacheUpdate - This decorator allows you to update a cached value
 *
 * @param options {CacheUpdateOptions}
 */
function CacheUpdate(options) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        return Object.assign(Object.assign({}, descriptor), { value: function (...args) {
                return __awaiter(this, void 0, void 0, function* () {
                    // Allow a client to be passed in directly for granularity, else use the connected
                    // client from the main CacheManager singleton.
                    const client = options && options.client ? options.client : index_1.default.client;
                    const fallbackClient = options && options.fallbackClient ? options.fallbackClient : index_1.default.fallbackClient;
                    if (options && options.noop && util_1.determineOp(options.noop, args, this)) {
                        return originalMethod.apply(this, args);
                    }
                    // If there is no client, no-op is enabled (else we would have thrown before),
                    // just return the result of the decorated method (no caching)
                    if (!client) {
                        // A caching client must exist if not set to noop, otherwise this library is doing nothing.
                        if (index_1.default.options.debug) {
                            console.warn('type-cacheable @CacheUpdate was not set up with a caching client. Without a client, type-cacheable is not serving a purpose.');
                        }
                        return originalMethod.apply(this, args);
                    }
                    const result = yield originalMethod.apply(this, args);
                    const contextToUse = !index_1.default.options.excludeContext ? this : undefined;
                    const finalKey = util_1.getFinalKey(options && options.cacheKey, options && options.hashKey, propertyKey, args, contextToUse, result);
                    // TTL in seconds should prioritize options set in the decorator first,
                    // the CacheManager options second, and be undefined if unset.
                    const ttl = options && options.ttlSeconds
                        ? util_1.getTTL(options.ttlSeconds, args, contextToUse)
                        : index_1.default.options.ttlSeconds || undefined;
                    const strategy = util_1.getCacheUpdateStrategy((options === null || options === void 0 ? void 0 : options.strategy) || index_1.default.options.updateStrategy || new DefaultUpdateStrategy_1.DefaultUpdateStrategy(), args, contextToUse, result);
                    const finalClearKey = util_1.getFinalKey(options && options.cacheKeysToClear, options && options.hashKey, propertyKey, args, contextToUse);
                    const clearStrategy = util_1.getCacheClearStrategy((options === null || options === void 0 ? void 0 : options.clearStrategy) ||
                        index_1.default.options.clearStrategy ||
                        new DefaultClearStrategy_1.DefaultClearStrategy(), args, contextToUse);
                    const cacheParams = {
                        debug: index_1.default.options.debug,
                        originalMethod,
                        originalMethodScope: this,
                        originalMethodArgs: args,
                        client,
                        fallbackClient,
                        key: finalKey,
                        ttl,
                        result,
                    };
                    const clearParams = {
                        debug: index_1.default.options.debug,
                        originalMethod,
                        originalMethodScope: this,
                        originalMethodArgs: args,
                        client,
                        fallbackClient,
                        key: finalClearKey,
                    };
                    if (options === null || options === void 0 ? void 0 : options.clearAndUpdateInParallel) {
                        const promises = [strategy.handle(cacheParams)];
                        if (finalClearKey.length) {
                            promises.push(clearStrategy.handle(clearParams));
                        }
                        const [strategyResult] = yield Promise.all(promises);
                        return strategyResult;
                    }
                    const strategyResult = yield strategy.handle(cacheParams);
                    if (finalClearKey.length) {
                        yield clearStrategy.handle(clearParams);
                    }
                    return strategyResult;
                });
            } });
    };
}
exports.CacheUpdate = CacheUpdate;
//# sourceMappingURL=CacheUpdate.js.map