"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strategies_1 = require("./strategies");
const DefaultClearStrategy_1 = require("./strategies/DefaultClearStrategy");
const DefaultUpdateStrategy_1 = require("./strategies/DefaultUpdateStrategy");
class CacheManager {
    constructor() {
        this.client = null;
        this.fallbackClient = null;
        this.options = {
            excludeContext: true,
            ttlSeconds: 0,
            debug: false,
            clearStrategy: new DefaultClearStrategy_1.DefaultClearStrategy(),
            strategy: new strategies_1.DefaultStrategy(),
            updateStrategy: new DefaultUpdateStrategy_1.DefaultUpdateStrategy(),
        };
    }
    setClient(client) {
        this.client = client;
        if (this.options && !this.options.ttlSeconds) {
            this.options.ttlSeconds = this.client.getClientTTL();
        }
    }
    setFallbackClient(client) {
        this.fallbackClient = client;
    }
    setOptions(options) {
        this.options = options;
    }
}
exports.default = CacheManager;
//# sourceMappingURL=CacheManager.js.map