export declare class TimeoutError extends Error {
    constructor(message?: string);
}
export declare function rejectAfterTimeout(timeout: number, errorMessage?: string): Promise<never>;
/**
 * Wraps promise and returns a new promise that will be rejected
 * after timeoutMs if the original promise is not resolved or rejected.
 */
export declare function withTimeout<R>(promise: Promise<R>, timeoutMs: number, errorMessage?: string): Promise<R>;
