"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dynamicPriority = dynamicPriority;
const helper_1 = require("../helper");
const timeout_1 = require("../../../Timer/timeout");
const GET_PRIORITY_TIMEOUT = 5e3;
const EXTRA_OPTIONS = ['proprietaryPriorityPath'];
function dynamicPriority(parsedDsn, originalDsn) {
    return __awaiter(this, void 0, void 0, function* () {
        const items = [];
        for (const host of parsedDsn.hosts) {
            try {
                const priority = yield (0, timeout_1.withTimeout)(getPriority(host, parsedDsn), GET_PRIORITY_TIMEOUT);
                items.push({ host, priority });
            }
            catch (error) {
                console.error('Not available host', host, error);
            }
        }
        const priorityItem = items.reduce((acc, item) => (!acc || item.priority > acc.priority ? item : acc), null);
        if (!priorityItem) {
            throw new Error(`No available connection string (DSN) found: ${originalDsn}`);
        }
        const selectedDsn = (0, helper_1.getDsn)(priorityItem.host, parsedDsn, EXTRA_OPTIONS);
        return selectedDsn;
    });
}
function getPriority(host, parameters) {
    return __awaiter(this, void 0, void 0, function* () {
        const simplifiedParameters = (0, helper_1.withoutOptions)(parameters, EXTRA_OPTIONS);
        return (0, helper_1.doConnectionCallback)(host, simplifiedParameters, (connection) => __awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c;
            const proprietaryPriorityPath = (_b = (_a = parameters.options) === null || _a === void 0 ? void 0 : _a.proprietaryPriorityPath) !== null && _b !== void 0 ? _b : 'proprietaryClusterSettings.priority';
            const [collectionName, key] = proprietaryPriorityPath.split('.');
            const settings = yield connection.db(parameters.endpoint).collection(collectionName).findOne({});
            return (_c = settings === null || settings === void 0 ? void 0 : settings[key]) !== null && _c !== void 0 ? _c : 0;
        }));
    });
}
//# sourceMappingURL=dynamicPriority.js.map