export interface IOptions {
    timeout?: number;
    maxPending?: number;
    domainReentrant?: boolean;
    /**
     * Defines whether async lock is scoped for global all instances of decorated class or only for single instance.
     * So for instance scope if there are more instances of class and the key of lock is same, they are not affecting each other.
     * Default is global.
     */
    scope?: 'global' | 'instance';
}
export declare function locked<TArgs extends unknown[], TThis extends object>(keyInitiator: string | string[] | ((this: TThis, ...args: TArgs) => string | string[]), options?: IOptions): (_target: unknown, _propertyKey: string, descriptor: PropertyDescriptor) => void;
