"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDayStart = getDayStart;
exports.getDayEnd = getDayEnd;
exports.getMonthStart = getMonthStart;
exports.getMonthEnd = getMonthEnd;
exports.getYearStart = getYearStart;
exports.getYearEnd = getYearEnd;
function getDayStart(year, month, day) {
    return new Date(year, month - 1, day, 0, 0, 0, 0);
}
function getDayEnd(year, month, day) {
    const d = getDayStart(year, month, day);
    d.setUTCHours(23, 59, 59, 999);
    return d;
}
function getMonthStart(year, month) {
    return getDayStart(year, month, 1);
}
function getMonthEnd(year, month) {
    const nextMonthStart = getMonthStart(year, month + 1);
    return new Date(nextMonthStart.getTime() - 1);
}
function getYearStart(year) {
    return getDayStart(year, 1, 1);
}
function getYearEnd(year) {
    return getDayEnd(year, 12, 31);
}
//# sourceMappingURL=statistics.js.map