"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.now = now;
exports.getCurrentTimezone = getCurrentTimezone;
exports.getCurrentTimezoneOffset = getCurrentTimezoneOffset;
const moment_timezone_1 = __importDefault(require("moment-timezone"));
function now(timezoneOffsetHours) {
    if (!timezoneOffsetHours) {
        timezoneOffsetHours = getCurrentTimezone();
    }
    return (0, moment_timezone_1.default)().subtract(getCurrentTimezone(), 'hour').add(timezoneOffsetHours, 'hour');
}
function getCurrentTimezone() {
    return -(new Date().getTimezoneOffset() / 60);
}
function getCurrentTimezoneOffset() {
    return new Date().getTimezoneOffset();
}
//# sourceMappingURL=dateTimeFactory.js.map