import { ApiResponse, Connection } from 'auth0';
import { GetConnections200ResponseOneOf } from 'auth0/dist/cjs/management/__generated/models';
type CreatePasswordChangeTicketParams = {
    email: string;
    resultUrl: string;
    connectionId: string;
};
type GetConnectionsParams = {
    perPage?: number;
    page?: number;
};
type GetAllConnectionsParams = GetConnectionsParams;
type IsSamlConnectionParams = {
    email: string;
};
type PasswordUrl = string;
export type Auth0Config = {
    domain: string;
    clientId: string;
    clientSecret: string;
};
export type OptionalAuth0Config = Partial<Auth0Config>;
export interface IAuth0ManagementClient {
    createPasswordChangeTicket: (params: CreatePasswordChangeTicketParams) => Promise<PasswordUrl>;
    getConnections: (params: GetConnectionsParams) => Promise<ApiResponse<GetConnections200ResponseOneOf>>;
    getAllConnections: (params: GetConnectionsParams) => Promise<Connection[]>;
    isSamlConnection: (params: IsSamlConnectionParams) => Promise<boolean>;
}
export declare class Auth0ManagementClient implements IAuth0ManagementClient {
    private managementClient;
    constructor({ domain, clientId, clientSecret, }: {
        domain: Auth0Config['domain'];
        clientId: Auth0Config['clientId'];
        clientSecret: Auth0Config['clientSecret'];
    });
    createPasswordChangeTicket: ({ email, resultUrl, connectionId }: CreatePasswordChangeTicketParams) => Promise<string>;
    getConnections: ({ perPage, page }: GetConnectionsParams) => Promise<ApiResponse<GetConnections200ResponseOneOf>>;
    getAllConnections: ({ perPage, page }: GetAllConnectionsParams) => Promise<Connection[]>;
    isSamlConnection: ({ email }: IsSamlConnectionParams) => Promise<boolean>;
}
export {};
