import { IAMQPConnection } from '../amqpConnectionFactory';
import IDeviceAction from './IDeviceAction';
import INackOptions from '../INackOptions';
import IConsumeOptions from '../IConsumeOptions';
import IQueueOptions from '../IQueueOptions';
export interface IToDeviceActionHeaders {
    deviceUid: string;
    sessionUid: string | undefined;
    actionType: string;
    postponable: boolean;
}
export type DeviceActionsQueueOptions = Pick<IQueueOptions, 'prefetchCount'>;
export type FromDeviceConsumeOptions = Pick<IConsumeOptions, 'durable' | 'queueType'>;
/**
 * @param postponable Postponable actions has to be delivered. When device is not connected at the time, it's postponed for later.
 * @param sessionUid Select a specific session (socket) to send message to. If specified, no other socket of single device get the action.
 * @param sendTimeout Specify how long it will wait for response until action is enqueued as not delivered action.
 */
export declare function sendToDevice<TAction extends string>(amqpConnection: IAMQPConnection, action: IDeviceAction<TAction>, deviceUid: string, postponable: boolean, sessionUid: string | undefined, sendTimeout: number): Promise<void>;
/**
 * @param timestamp of action when it was sent from the device
 */
export declare function sendFromDevice<TAction extends string>(amqpConnection: IAMQPConnection, action: IDeviceAction<TAction>, deviceUid: string, sessionUid: string, socketName: string, timestamp?: number): Promise<void>;
export declare function bindToDevice(amqpConnection: IAMQPConnection, consumerName: string, processUid: string, onAction: (deviceUid: string, sessionUid: string | undefined, action: IDeviceAction<string>, ack: () => void, nack: (options?: INackOptions) => void) => Promise<void>): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
/**
 * Binds action messages by a specific actionTypes to a single queue. The queue is named after the input group.
 * So, more action types are grouped together into single queue. This is preventing from stucking messages across more
 * priority leveled groups.
 * E.g.: The priority actions used for authentication, registration & verification should not be affected by telemetry actions in any way.
 * The priority actions has much more strict requirements on SLA.
 *
 * @param group the string name of group which will be used as a part of queue name.
 * @param actionTypes all types of actions which are bound to the queue.
 * @param onAction the callback which is called for every action bound above.
 */
export declare function bindSpecificFromDevice(amqpConnection: IAMQPConnection, group: string, actionTypes: string[], onAction: (action: IDeviceAction<string>, deviceUid: string, sessionUid: string, socketName: string, timestamp?: number) => Promise<void>, options?: FromDeviceConsumeOptions): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
/**
 * According to bindSpecificFromDevice, for all action types which were not bound there, the actions are fall backed to this consumption.
 * Those unspecific actions has self alternate exchange and appropriate single queue.
 * This consumption can be used for all not specifically bound actions, for example action logs of devices.
 *
 * @param onAction the callback which is called for every action ever not specifically bound by bindSpecificFromDevice.
 */
export declare function bindUnspecificFromDevice(amqpConnection: IAMQPConnection, onAction: (action: IDeviceAction<string>, deviceUid: string, sessionUid: string, socketName: string, timestamp?: number) => Promise<void>, options?: FromDeviceConsumeOptions): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
export declare function bindFailed(amqpConnection: IAMQPConnection, onAction: (action: IDeviceAction<string>, deviceUid: string, postponable: boolean, ack: () => void, nack: (options?: INackOptions) => void) => Promise<void>, options?: FromDeviceConsumeOptions): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
