"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.escapeObject = escapeObject;
exports.unescapeObject = unescapeObject;
exports.escape = escape;
exports.unescape = unescape;
var lodash_1 = require("lodash");
function escapeObject(object) {
    return recureObject(object, escape);
}
function unescapeObject(object) {
    return recureObject(object, unescape);
}
function recureObject(recuringObject, callback) {
    return (0, lodash_1.isPlainObject)(recuringObject)
        ? Object.keys(recuringObject).reduce(function (reductionObject, key) {
            var _a;
            var updatedKey = callback(key);
            var subObject = reductionObject[key];
            var updatedSubObject = recureObject(subObject, callback);
            if (key !== updatedKey || subObject !== updatedSubObject) {
                var omittedObject = (0, lodash_1.omit)(reductionObject, key);
                return __assign(__assign({}, omittedObject), (_a = {}, _a[updatedKey] = updatedSubObject, _a));
            }
            else {
                return reductionObject;
            }
        }, recuringObject)
        : recuringObject;
}
function escape(key) {
    return isEscapable(key) ? key.replace(/\$/g, '\uFF04').replace(/\./g, '\uFF0E') : key;
}
function unescape(key) {
    return isUnescapable(key) ? key.replace(/\uFF04/g, '$').replace(/\uFF0E/g, '.') : key;
}
function isEscapable(key) {
    return key.indexOf('$') !== -1 || key.indexOf('.') !== -1;
}
function isUnescapable(key) {
    return key.indexOf('\uFF04') !== -1 || key.indexOf('\uFF0E') !== -1;
}
//# sourceMappingURL=escape.js.map