"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEventProcessingMetrics = createEventProcessingMetrics;
var defaultOptions = {
    /**
     * Buckets for the event_duration_seconds_bucket metric.
     * Default buckets are [0.01, 0.05, 0.1, 0.5, 1, 2, 5, 10, 30, 60]
     */
    durationInSecondsHistogramBuckets: [0.01, 0.05, 0.1, 0.5, 1, 2, 5, 10, 30, 60],
};
function createEventProcessingMetrics(metricsClient, options) {
    var client = metricsClient.getClient();
    options = __assign(__assign({}, defaultOptions), options);
    var eventCount = new client.Counter({
        name: 'event_consumer_events_total',
        help: 'Number of all events',
        labelNames: ['eventType'],
    });
    var eventDurationSum = new client.Counter({
        name: 'event_consumer_event_duration_seconds_total',
        help: 'Total duration of all events in seconds',
        labelNames: ['eventType', 'phase'],
    });
    var eventDurationHistogram = new client.Histogram({
        name: 'event_consumer_event_duration_seconds',
        help: 'Duration of all events in seconds',
        buckets: options.durationInSecondsHistogramBuckets,
    });
    function recordMetrics(_a) {
        var event = _a.event, stats = _a.stats;
        eventCount.labels({ eventType: event.type }).inc();
        eventDurationHistogram.observe(stats.duration / 1e3);
        eventDurationSum.labels({ eventType: event.type, phase: 'processing' }).inc(stats.duration / 1e3);
        var eventStartDuration = stats.start - event.receivedAt.valueOf();
        eventDurationSum.labels({ eventType: event.type, phase: 'eventStart' }).inc(Math.max(eventStartDuration, 0) / 1e3);
        var commandStartDuration = event.receivedAt.valueOf() - event.dispatchedAt.valueOf();
        if (commandStartDuration !== 0) {
            eventDurationSum.labels({ eventType: event.type, phase: 'commandStart' }).inc(Math.max(commandStartDuration, 0) / 1e3);
        }
    }
    return {
        recordMetrics: recordMetrics,
        eventCount: eventCount,
        eventDurationSum: eventDurationSum,
        eventDurationHistogram: eventDurationHistogram,
    };
}
//# sourceMappingURL=amqpEventConsumerExporter.js.map