"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendStatusResponse = sendStatusResponse;
var time = __importStar(require("../DateTime/dateTimeFactory"));
var os = __importStar(require("os"));
var http_status_1 = __importDefault(require("http-status"));
function sendStatusResponse(req, res, name, uid, timeout, statusRequestedAt, serviceGroupResponses, additionalDataCallback) {
    if (additionalDataCallback === void 0) { additionalDataCallback = function () { return undefined; }; }
    var serviceNames = Object.keys(serviceGroupResponses);
    var failedServices = serviceNames.filter(function (serviceName) { return 'error' in serviceGroupResponses[serviceName]; });
    var succeededServices = serviceNames.filter(function (serviceName) { return 'response' in serviceGroupResponses[serviceName]; });
    var success = failedServices.length === 0;
    var statusResponse = {
        name: name,
        status: success ? 'OK' : 'FAILED',
        process: {
            uid: uid,
            pid: process.pid,
            version: process.version,
            uptime: process.uptime(),
            cpuUsage: process.cpuUsage(),
            memoryUsage: process.memoryUsage(),
        },
        hostname: os.hostname(),
        failedServices: failedServices,
        succeededServices: succeededServices,
        timeout: timeout,
        requestedAt: statusRequestedAt.valueOf(),
        respondedAt: time.now().valueOf(),
    };
    var response = __assign(__assign(__assign({}, statusResponse), additionalDataCallback(req)), serviceGroupResponses);
    res.status(success ? http_status_1.default.OK : http_status_1.default.SERVICE_UNAVAILABLE).send(response);
}
//# sourceMappingURL=sendStatusResponse.js.map