import * as http from 'http';
import { IGetStatus } from './status';
export type IHttpServerGetStatus = () => IGetStatus;
interface IUniversalHttpServer {
    http: http.Server;
    listen: () => void;
    close: () => void;
}
export interface IHttpServer extends IUniversalHttpServer {
    getConnections: () => Promise<number>;
    getStatus: IHttpServerGetStatus;
    setStatus: (isReady: boolean) => void;
}
export default function enrichHttpServerWithStatus(httpServer: IUniversalHttpServer): IHttpServer;
export {};
