/**
 * Copied from https://www.npmjs.com/package/generic-pool
 */
export interface IOptions {
    /**
     * int between 1 and x - if set, borrowers can specify their relative priority in the queue if no resources are available.
     * see example. (default 1)
     */
    priorityRange?: number;
    /**
     * if true the oldest resources will be first to be allocated. If false the most recently released resources will be the first
     * to be allocated. This in effect turns the pool's behaviour from a queue into a stack. boolean, (default true)
     */
    fifo?: boolean;
    /**
     * minimum number of resources to keep in pool at any given time. If this is set >= max,
     * the pool will silently set the min to equal max. (default=0)
     */
    min?: number;
    /** maximum number of resources to create at any given time. (default=1) */
    max?: number;
    /**
     * maximum number of queued requests allowed, additional acquire calls will be callback with an err in a future cycle of the event loop.
     */
    maxWaitingClients?: number;
    /**
     * should the pool start creating resources, initialize the evictor, etc once the constructor is called. If false,
     * the pool can be started by calling pool.start, otherwise the first call to acquire will start the pool. (default true)
     */
    autostart?: boolean;
    /**
     * max milliseconds a destroy call will wait for a resource before timing out. (default no limit),
     * if supplied should non-zero positive integer.
     */
    destroyTimeoutMillis?: number;
    /**
     * max milliseconds an acquire call will wait for a resource before timing out. (default no limit),
     * if supplied should non-zero positive integer.
     */
    acquireTimeoutMillis?: number;
    /**
     * should the pool validate resources before giving them to clients. Requires that factory.validate is specified.
     */
    testOnBorrow?: boolean;
    /** How often to run eviction checks. Default: 0 (does not run). */
    evictionRunIntervalMillis?: number;
    /** Number of resources to check each eviction run. Default: 3. */
    numTestsPerEvictionRun?: number;
    /**
     * amount of time an object may sit idle in the pool before it is eligible for eviction by the idle object evictor (if any),
     * with the extra condition that at least "min idle" object instances remain in the pool. Default -1 (nothing can get evicted)
     */
    softIdleTimeoutMillis?: number;
    /**
     * the minimum amount of time that an object may sit idle in the pool before it is eligible for eviction due to idle time.
     * Supercedes softIdleTimeoutMillis Default: 30000
     */
    idleTimeoutMillis?: number;
    /**
     * Promise lib, a Promises/A+ implementation that the pool should use. Defaults to whatever global.Promise is (usually native promises).
     */
    Promise?: PromiseConstructor;
}
