"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmqpEventConsumer = void 0;
var lockedDecorator_1 = require("../../../Lock/lockedDecorator");
var logging_1 = require("../../../Logging/logging");
var eventQueue_1 = require("../eventQueue");
var amqpEventConsumerExporter_1 = require("../../../Metrics/amqpEventConsumerExporter");
var consumerLogger = logging_1.logger.createNamespace('EventConsumer');
var DEFAULT_DOMAIN = 'default';
var LOCK_NAMESPACE = 'AmqpEventConsumer';
/**
 * High level abstraction of event consumption
 *
 * This implementation uses AMQP queues to consume events.
 *
 * It abstracts all the implementation details of setting up consumption of events
 * and provides a simple interface so that the consumer can focus on just handling the events.
 *
 * All events are consumed from a single queue in a sequential order.
 * The name of the queue will be constructed from the consumer name and the domain as "<consumerName>_<domain>".
 */
var AmqpEventConsumer = /** @class */ (function () {
    /**
     * @param amqpConnection The AMQP connection to use
     * @param consumerName The name of the consumer. This is used to identify the consumer in the AMQP queue
     * @param domain The domain to consume events from. Defaults to 'default'
     * @param options Additional options for the consumer
     */
    function AmqpEventConsumer(_a) {
        var amqpConnection = _a.amqpConnection, consumerName = _a.consumerName, domain = _a.domain, options = _a.options, metricsClient = _a.metricsClient;
        this.consumerCallbacks = {};
        this.stopCallback = null;
        this.started = false;
        this.amqpConnection = amqpConnection;
        this.consumerName = consumerName;
        this.domain = domain || DEFAULT_DOMAIN;
        this.options = options;
        this.metrics = metricsClient ? (0, amqpEventConsumerExporter_1.createEventProcessingMetrics)(metricsClient) : undefined;
    }
    /**
     * Add a consumer for a specific event type
     *
     * Has to be called before calling listen(), otherwise it will throw an error.
     */
    AmqpEventConsumer.prototype.addEventConsumer = function (eventType, callback, option) {
        if (this.consumerCallbacks[eventType]) {
            throw new Error("Consumer for event type ".concat(eventType, " already registered"));
        }
        if (this.started) {
            throw new Error('Cannot add event consumer after consumer has started');
        }
        this.consumerCallbacks[eventType] = {
            callback: callback,
            schema: option === null || option === void 0 ? void 0 : option.schema,
        };
    };
    AmqpEventConsumer.prototype.listen = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.started) {
                            throw new Error('Event consumer already started');
                        }
                        return [4 /*yield*/, this.bindEvents()];
                    case 1:
                        _a.sent();
                        this.started = true;
                        return [2 /*return*/];
                }
            });
        });
    };
    AmqpEventConsumer.prototype.close = function () {
        return __awaiter(this, void 0, void 0, function () {
            var closeChannel;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.stopCallback) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.stopCallback()];
                    case 1:
                        closeChannel = _a.sent();
                        return [4 /*yield*/, closeChannel()];
                    case 2:
                        _a.sent();
                        this.stopCallback = null;
                        _a.label = 3;
                    case 3:
                        this.started = false;
                        return [2 /*return*/];
                }
            });
        });
    };
    AmqpEventConsumer.prototype.bindEvents = function () {
        return __awaiter(this, void 0, void 0, function () {
            var eventTypes, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        eventTypes = Object.keys(this.consumerCallbacks);
                        _a = this;
                        return [4 /*yield*/, (0, eventQueue_1.bindMany)(this.amqpConnection, eventTypes, this.domain, this.consumerName, this.consumeEvent.bind(this), this.options)];
                    case 1:
                        _a.stopCallback = _b.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    AmqpEventConsumer.prototype.shouldConsumeEvent = function (options) {
        if (options.schema) {
            return options.schema.safeParse(options.event).success;
        }
        return true;
    };
    AmqpEventConsumer.prototype.consumeEvent = function (event) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, callback, schema, start;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.consumerCallbacks[event.type] || {}, callback = _a.callback, schema = _a.schema;
                        if (!callback) {
                            throw new Error("Event ".concat(event.type, " received but no consumer registered"));
                        }
                        if (!this.shouldConsumeEvent({ schema: schema, event: event })) return [3 /*break*/, 2];
                        start = new Date().getTime();
                        return [4 /*yield*/, callback(event)];
                    case 1:
                        _b.sent();
                        if (this.metrics) {
                            this.metrics.recordMetrics({
                                event: event,
                                stats: { start: start, duration: new Date().getTime() - start },
                            });
                        }
                        consumerLogger.info("Event ".concat(event.type, " consumed"), { event: event });
                        _b.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    __decorate([
        (0, lockedDecorator_1.locked)(LOCK_NAMESPACE, { scope: 'instance' }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], AmqpEventConsumer.prototype, "listen", null);
    __decorate([
        (0, lockedDecorator_1.locked)(LOCK_NAMESPACE, { scope: 'instance' }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], AmqpEventConsumer.prototype, "close", null);
    return AmqpEventConsumer;
}());
exports.AmqpEventConsumer = AmqpEventConsumer;
//# sourceMappingURL=AmqpEventConsumer.js.map