import { z } from 'zod';
export declare const AppletSettingsSchema: z.ZodObject<{
    appletUid: z.ZodString;
    appletVersion: z.ZodString;
    /** @deprecated don't use anymore; will be removed in the future */
    startsAt: z.ZodOptional<z.ZodDate>;
    /** @deprecated don't use anymore; will be removed in the future */
    endsAt: z.ZodOptional<z.ZodDate>;
    configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
    /** @deprecated don't use anymore; will be removed in the future */
    finishEvent: z.ZodOptional<z.ZodObject<{
        type: z.ZodNativeEnum<typeof import("./FinishEventType").FinishEventType>;
        data: z.ZodOptional<z.ZodAny>;
    }, "strip", z.ZodTypeAny, {
        type: import("./FinishEventType").FinishEventType;
        data?: any;
    }, {
        type: import("./FinishEventType").FinishEventType;
        data?: any;
    }>>;
    /** @deprecated don't use anymore; will be removed in the future */
    position: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    appletUid: string;
    appletVersion: string;
    configuration: Record<string, unknown>;
    position?: number | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    finishEvent?: {
        type: import("./FinishEventType").FinishEventType;
        data?: any;
    } | undefined;
}, {
    appletUid: string;
    appletVersion: string;
    configuration: Record<string, unknown>;
    position?: number | undefined;
    startsAt?: Date | undefined;
    endsAt?: Date | undefined;
    finishEvent?: {
        type: import("./FinishEventType").FinishEventType;
        data?: any;
    } | undefined;
}>;
export type AppletSettings = z.infer<typeof AppletSettingsSchema>;
