"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidEnabled = exports.validKeys = void 0;
exports.default = validateScreenshotCaptureSettings;
exports.isValidEnabledValue = isValidEnabledValue;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    enabled: true,
};
function validateScreenshotCaptureSettings(settings) {
    var _a;
    const { enabled } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notEnabledValid = !isValidEnabledValue(enabled);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notEnabledValid) {
        validation.addError(new InvalidEnabled(enabled));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
function isValidEnabledValue(enabled) {
    const isEnabledBoolean = typeof enabled === 'boolean';
    if (isEnabledBoolean) {
        return true;
    }
    else {
        return false;
    }
}
class InvalidEnabled extends Error {
    constructor(enabled) {
        super(`Enabled has to be true or false: ${enabled}`);
    }
}
exports.InvalidEnabled = InvalidEnabled;
