"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidVideoOrientation = exports.InvalidOrientation = exports.validKeys = void 0;
exports.default = validateOrientationSetting;
const isValidOrientation_1 = require("../../Resolution/Validation/isValidOrientation");
const isValidVideoOrientation_1 = require("../../Resolution/Validation/isValidVideoOrientation");
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    orientation: true,
    videoOrientation: true,
};
function validateOrientationSetting(settings) {
    var _a;
    const { orientation, videoOrientation } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notOrientationValid = !(0, isValidOrientation_1.default)(orientation);
    const notVideoOrientationValid = !(videoOrientation === undefined || (0, isValidVideoOrientation_1.default)(videoOrientation));
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notOrientationValid) {
        validation.addError(new InvalidOrientation(orientation));
    }
    if (notVideoOrientationValid) {
        validation.addError(new InvalidVideoOrientation(videoOrientation));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidOrientation extends Error {
    constructor(orientation) {
        super(`Orientation is not valid: ${orientation}`);
    }
}
exports.InvalidOrientation = InvalidOrientation;
class InvalidVideoOrientation extends Error {
    constructor(videoOrientation) {
        super(`Video Orientation is not valid: ${videoOrientation}`);
    }
}
exports.InvalidVideoOrientation = InvalidVideoOrientation;
