"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SocketDriver = exports.LongWeekdayEnum = exports.ShortWeekdayEnum = exports.DeviceSettingsSchemas = void 0;
const DeviceSettingsType_1 = require("./DeviceSettingsType");
const ResolutionList_1 = require("../Resolution/ResolutionList");
const Orientation_1 = require("../Resolution/Orientation");
const VideoOrientation_1 = require("../Resolution/VideoOrientation");
const PowerActionType_1 = require("../Power/PowerActionType");
const Weekday_1 = require("../Time/Weekday");
const NativeTimerType_1 = require("../Timer/NativeTimerType");
const socketDriver_1 = require("../socketDriver");
const zod_1 = require("zod");
const TelemetryIntervals_1 = require("../../Device/MonitoringLog/TelemetryIntervals");
const PowerTimerWeekdayEnum_1 = require("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum");
Object.defineProperty(exports, "ShortWeekdayEnum", { enumerable: true, get: function () { return PowerTimerWeekdayEnum_1.ShortWeekdayEnum; } });
Object.defineProperty(exports, "LongWeekdayEnum", { enumerable: true, get: function () { return PowerTimerWeekdayEnum_1.LongWeekdayEnum; } });
const NetworkInterface_1 = require("../Network/NetworkInterface");
const AppletSettings_1 = require("../../Timing/AppletSettings");
const ProprietaryTimerType_1 = require("../Timer/ProprietaryTimerType");
const DevicePackageInstallation_1 = require("../Package/DevicePackageInstallation");
const DevicePackageUninstallation_1 = require("../Package/DevicePackageUninstallation");
exports.DeviceSettingsSchemas = {
    [DeviceSettingsType_1.DeviceSettingsType.VOLUME]: zod_1.z.strictObject({
        volume: zod_1.z.number().min(0).max(100),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.BRIGHTNESS]: zod_1.z.strictObject({
        brightness: zod_1.z.number().min(0).max(100),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.TIMERS]: zod_1.z.array(
    // TODO Migrate data as `NativeTimer`
    zod_1.z.strictObject({
        type: zod_1.z.nativeEnum(NativeTimerType_1.NativeTimerType),
        weekdays: zod_1.z.array(zod_1.z.nativeEnum(PowerTimerWeekdayEnum_1.LongWeekdayEnum)),
        timeOn: zod_1.z.string().nullable(),
        timeOff: zod_1.z.string().nullable(),
        volume: zod_1.z.number().min(0).max(100),
    })),
    [DeviceSettingsType_1.DeviceSettingsType.PROPRIETARY_TIMERS]: zod_1.z.array(
    // TODO Migrate data as `ProprietaryTimer`
    zod_1.z.object({
        // Allow extra properties (like volume) to be backward compatible
        type: ProprietaryTimerType_1.ProprietaryTimerTypeSchema,
        weekdays: zod_1.z.array(zod_1.z.nativeEnum(PowerTimerWeekdayEnum_1.LongWeekdayEnum)),
        timeOn: zod_1.z.string().nullable(),
        timeOff: zod_1.z.string().nullable(),
        keepAppletRunning: zod_1.z.boolean().optional(),
    })),
    [DeviceSettingsType_1.DeviceSettingsType.RESOLUTION]: ResolutionList_1.ResolutionItemSchema,
    [DeviceSettingsType_1.DeviceSettingsType.ORIENTATION]: zod_1.z.strictObject({
        orientation: zod_1.z.nativeEnum(Orientation_1.default),
        videoOrientation: zod_1.z.nativeEnum(VideoOrientation_1.default).optional(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.REMOTE_CONTROL]: zod_1.z.strictObject({
        enabled: zod_1.z.boolean(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.APPLICATION_VERSION]: zod_1.z.strictObject({
        version: zod_1.z.string(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.FIRMWARE_VERSION]: zod_1.z.strictObject({
        version: zod_1.z.string(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.DEBUG]: zod_1.z.strictObject({
        appletEnabled: zod_1.z.boolean(),
        nativeEnabled: zod_1.z.boolean(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.DATETIME]: zod_1.z.strictObject({
        timezone: zod_1.z.string().nullable(),
        ntpServer: zod_1.z.string().nullable(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.POWER_ACTIONS_SCHEDULE]: zod_1.z.array(zod_1.z.strictObject({
        uid: zod_1.z.string(),
        powerType: zod_1.z.nativeEnum(PowerActionType_1.default),
        weekdays: zod_1.z.array(zod_1.z.nativeEnum(Weekday_1.default)),
        time: zod_1.z.string(),
    })),
    [DeviceSettingsType_1.DeviceSettingsType.TEMPERATURE]: zod_1.z.strictObject({
        temperatureLimit: zod_1.z.number(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.AUTO_RECOVERY]: zod_1.z.strictObject({
        enabled: zod_1.z.boolean(),
        healthcheckIntervalMs: zod_1.z.number().optional(),
        autoEnableTimeoutMs: zod_1.z.number().optional(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.PEER_RECOVERY]: zod_1.z.strictObject({
        enabled: zod_1.z.boolean(),
        urlLauncherAddress: zod_1.z.string().optional(),
        autoEnableTimeoutMs: zod_1.z.number().optional(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.PROXY]: zod_1.z.strictObject({
        enabled: zod_1.z.boolean(),
        uri: zod_1.z.string().nullable(),
    }),
    /**
     * Connection method is a special case of device settings type and it's only enum value or null
     * instead of interface definition as it is in other cases. Null value represents 'auto' connection method.
     */
    [DeviceSettingsType_1.DeviceSettingsType.CONNECTION_METHOD]: zod_1.z.nativeEnum(socketDriver_1.SocketDriver).nullable(),
    [DeviceSettingsType_1.DeviceSettingsType.PACKAGES]: zod_1.z.object({
        toInstall: zod_1.z.array(DevicePackageInstallation_1.DevicePackageInstallationSchema),
        toUninstall: zod_1.z.array(DevicePackageUninstallation_1.DevicePackageUninstallationSchema),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.TELEMETRY_INTERVALS]: zod_1.z.object({
        telemetryIntervals: TelemetryIntervals_1.TelemetryCheckIntervalsSchema,
    }),
    [DeviceSettingsType_1.DeviceSettingsType.APPLET]: AppletSettings_1.AppletSettingsSchema,
    [DeviceSettingsType_1.DeviceSettingsType.EXTENDED_MANAGEMENT]: zod_1.z.strictObject({
        url: zod_1.z.string().nullable(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.NETWORK_INTERFACES]: zod_1.z.array(NetworkInterface_1.NetworkInterfacesSchema),
    [DeviceSettingsType_1.DeviceSettingsType.DISPLAY_POWER_ON]: zod_1.z.strictObject({
        powerOn: zod_1.z.boolean(),
    }),
    [DeviceSettingsType_1.DeviceSettingsType.SCREENSHOT_CAPTURE]: zod_1.z.strictObject({
        enabled: zod_1.z.boolean(),
    }),
};
exports.SocketDriver = socketDriver_1.SocketDriver;
