import { DeviceSettingsType } from './DeviceSettingsType';
import Orientation from '../Resolution/Orientation';
import VideoOrientation from '../Resolution/VideoOrientation';
import PowerActionType from '../Power/PowerActionType';
import { NativeTimerType } from '../Timer/NativeTimerType';
import { SocketDriver as SocketDriverInternal } from '../socketDriver';
import { z } from 'zod';
import { ILongWeekdayTimer, IShortWeekdayTimer } from '@signageos/lib/dist/Timer/Power/PowerTimerSettings';
import { ShortWeekdayEnum, LongWeekdayEnum } from '@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum';
import { AppletSettings } from '../../Timing/AppletSettings';
export declare const DeviceSettingsSchemas: {
    readonly VOLUME: z.ZodObject<{
        volume: z.ZodNumber;
    }, "strict", z.ZodTypeAny, {
        volume: number;
    }, {
        volume: number;
    }>;
    readonly BRIGHTNESS: z.ZodObject<{
        brightness: z.ZodNumber;
    }, "strict", z.ZodTypeAny, {
        brightness: number;
    }, {
        brightness: number;
    }>;
    readonly TIMERS: z.ZodArray<z.ZodObject<{
        type: z.ZodNativeEnum<typeof NativeTimerType>;
        weekdays: z.ZodArray<z.ZodNativeEnum<typeof LongWeekdayEnum>, "many">;
        timeOn: z.ZodNullable<z.ZodString>;
        timeOff: z.ZodNullable<z.ZodString>;
        volume: z.ZodNumber;
    }, "strict", z.ZodTypeAny, {
        type: NativeTimerType;
        volume: number;
        weekdays: LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
    }, {
        type: NativeTimerType;
        volume: number;
        weekdays: LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
    }>, "many">;
    readonly PROPRIETARY_TIMERS: z.ZodArray<z.ZodObject<{
        type: z.ZodType<`TIMER_${number}`, z.ZodTypeDef, `TIMER_${number}`>;
        weekdays: z.ZodArray<z.ZodNativeEnum<typeof LongWeekdayEnum>, "many">;
        timeOn: z.ZodNullable<z.ZodString>;
        timeOff: z.ZodNullable<z.ZodString>;
        keepAppletRunning: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        type: `TIMER_${number}`;
        weekdays: LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
        keepAppletRunning?: boolean | undefined;
    }, {
        type: `TIMER_${number}`;
        weekdays: LongWeekdayEnum[];
        timeOn: string | null;
        timeOff: string | null;
        keepAppletRunning?: boolean | undefined;
    }>, "many">;
    readonly RESOLUTION: z.ZodObject<{
        width: z.ZodNumber;
        height: z.ZodNumber;
        framerate: z.ZodOptional<z.ZodNumber>;
    }, "strict", z.ZodTypeAny, {
        height: number;
        width: number;
        framerate?: number | undefined;
    }, {
        height: number;
        width: number;
        framerate?: number | undefined;
    }>;
    readonly ORIENTATION: z.ZodObject<{
        orientation: z.ZodNativeEnum<typeof Orientation>;
        videoOrientation: z.ZodOptional<z.ZodNativeEnum<typeof VideoOrientation>>;
    }, "strict", z.ZodTypeAny, {
        orientation: Orientation;
        videoOrientation?: VideoOrientation | undefined;
    }, {
        orientation: Orientation;
        videoOrientation?: VideoOrientation | undefined;
    }>;
    readonly REMOTE_CONTROL: z.ZodObject<{
        enabled: z.ZodBoolean;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
    }, {
        enabled: boolean;
    }>;
    readonly APPLICATION_VERSION: z.ZodObject<{
        version: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        version: string;
    }, {
        version: string;
    }>;
    readonly FIRMWARE_VERSION: z.ZodObject<{
        version: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        version: string;
    }, {
        version: string;
    }>;
    readonly DEBUG: z.ZodObject<{
        appletEnabled: z.ZodBoolean;
        nativeEnabled: z.ZodBoolean;
    }, "strict", z.ZodTypeAny, {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    }, {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    }>;
    readonly DATETIME: z.ZodObject<{
        timezone: z.ZodNullable<z.ZodString>;
        ntpServer: z.ZodNullable<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        timezone: string | null;
        ntpServer: string | null;
    }, {
        timezone: string | null;
        ntpServer: string | null;
    }>;
    readonly POWER_ACTIONS_SCHEDULE: z.ZodArray<z.ZodObject<{
        uid: z.ZodString;
        powerType: z.ZodNativeEnum<typeof PowerActionType>;
        weekdays: z.ZodArray<z.ZodNativeEnum<typeof LongWeekdayEnum>, "many">;
        time: z.ZodString;
    }, "strict", z.ZodTypeAny, {
        time: string;
        weekdays: LongWeekdayEnum[];
        uid: string;
        powerType: PowerActionType;
    }, {
        time: string;
        weekdays: LongWeekdayEnum[];
        uid: string;
        powerType: PowerActionType;
    }>, "many">;
    readonly TEMPERATURE: z.ZodObject<{
        temperatureLimit: z.ZodNumber;
    }, "strict", z.ZodTypeAny, {
        temperatureLimit: number;
    }, {
        temperatureLimit: number;
    }>;
    readonly AUTO_RECOVERY: z.ZodObject<{
        enabled: z.ZodBoolean;
        healthcheckIntervalMs: z.ZodOptional<z.ZodNumber>;
        autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
        healthcheckIntervalMs?: number | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }, {
        enabled: boolean;
        healthcheckIntervalMs?: number | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }>;
    readonly PEER_RECOVERY: z.ZodObject<{
        enabled: z.ZodBoolean;
        urlLauncherAddress: z.ZodOptional<z.ZodString>;
        autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
        autoEnableTimeoutMs?: number | undefined;
        urlLauncherAddress?: string | undefined;
    }, {
        enabled: boolean;
        autoEnableTimeoutMs?: number | undefined;
        urlLauncherAddress?: string | undefined;
    }>;
    readonly PROXY: z.ZodObject<{
        enabled: z.ZodBoolean;
        uri: z.ZodNullable<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
        uri: string | null;
    }, {
        enabled: boolean;
        uri: string | null;
    }>;
    /**
     * Connection method is a special case of device settings type and it's only enum value or null
     * instead of interface definition as it is in other cases. Null value represents 'auto' connection method.
     */
    readonly CONNECTION_METHOD: z.ZodNullable<z.ZodNativeEnum<typeof SocketDriverInternal>>;
    readonly PACKAGES: z.ZodObject<{
        toInstall: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<{
            applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
            packageName: z.ZodString;
            ownerOrganizationUid: z.ZodString;
            buildHash: z.ZodString;
            version: z.ZodString;
            build: z.ZodNullable<z.ZodString>;
            specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
        }, {
            applicationType: z.ZodLiteral<"android">;
            specs: z.ZodObject<{
                packageName: z.ZodString;
                sdkVersion: z.ZodNumber;
                supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
                multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
                versionCode: z.ZodOptional<z.ZodNumber>;
                targetSdkVersion: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            }, {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            }>;
        }>, "strict", z.ZodTypeAny, {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }, {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }>, "many">;
        toUninstall: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<{
            applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
            packageName: z.ZodString;
            specs: z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>;
        }, {
            applicationType: z.ZodLiteral<"android">;
            specs: z.ZodObject<{
                packageName: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                packageName: string;
            }, {
                packageName: string;
            }>;
        }>, "strict", z.ZodTypeAny, {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }, {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }>, "many">;
    }, "strip", z.ZodTypeAny, {
        toInstall: {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }[];
        toUninstall: {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }[];
    }, {
        toInstall: {
            version: string;
            packageName: string;
            applicationType: "android";
            ownerOrganizationUid: string;
            buildHash: string;
            build: string | null;
            specs: {
                packageName: string;
                sdkVersion: number;
                supportedAbis?: string[] | undefined;
                multiArch?: boolean | null | undefined;
                versionCode?: number | undefined;
                targetSdkVersion?: number | undefined;
            };
        }[];
        toUninstall: {
            packageName: string;
            applicationType: "android";
            specs: {
                packageName: string;
            };
        }[];
    }>;
    readonly TELEMETRY_INTERVALS: z.ZodObject<{
        telemetryIntervals: z.ZodObject<{
            screenshots: z.ZodOptional<z.ZodNumber>;
            temperature: z.ZodOptional<z.ZodNumber>;
            applicationVersion: z.ZodOptional<z.ZodNumber>;
            frontDisplayVersion: z.ZodOptional<z.ZodNumber>;
            brightness: z.ZodOptional<z.ZodNumber>;
            datetime: z.ZodOptional<z.ZodNumber>;
            debug: z.ZodOptional<z.ZodNumber>;
            firmwareVersion: z.ZodOptional<z.ZodNumber>;
            orientation: z.ZodOptional<z.ZodNumber>;
            powerActionsSchedule: z.ZodOptional<z.ZodNumber>;
            proprietaryTimers: z.ZodOptional<z.ZodNumber>;
            remoteControl: z.ZodOptional<z.ZodNumber>;
            resolution: z.ZodOptional<z.ZodNumber>;
            timers: z.ZodOptional<z.ZodNumber>;
            volume: z.ZodOptional<z.ZodNumber>;
            storage: z.ZodOptional<z.ZodNumber>;
            battery: z.ZodOptional<z.ZodNumber>;
            policy: z.ZodOptional<z.ZodNumber>;
            peerRecovery: z.ZodOptional<z.ZodNumber>;
            autoRecovery: z.ZodOptional<z.ZodNumber>;
            extendedManagement: z.ZodOptional<z.ZodNumber>;
            appModules: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        }, {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        telemetryIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        };
    }, {
        telemetryIntervals: {
            screenshots?: number | undefined;
            temperature?: number | undefined;
            applicationVersion?: number | undefined;
            frontDisplayVersion?: number | undefined;
            brightness?: number | undefined;
            datetime?: number | undefined;
            debug?: number | undefined;
            firmwareVersion?: number | undefined;
            orientation?: number | undefined;
            powerActionsSchedule?: number | undefined;
            proprietaryTimers?: number | undefined;
            remoteControl?: number | undefined;
            resolution?: number | undefined;
            timers?: number | undefined;
            volume?: number | undefined;
            storage?: number | undefined;
            battery?: number | undefined;
            policy?: number | undefined;
            peerRecovery?: number | undefined;
            autoRecovery?: number | undefined;
            extendedManagement?: number | undefined;
            appModules?: number | undefined;
            default?: number | undefined;
        };
    }>;
    readonly APPLET: z.ZodObject<{
        appletUid: z.ZodString;
        appletVersion: z.ZodString;
        startsAt: z.ZodOptional<z.ZodDate>;
        endsAt: z.ZodOptional<z.ZodDate>;
        configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
        finishEvent: z.ZodOptional<z.ZodObject<{
            type: z.ZodNativeEnum<typeof import("../../Timing/FinishEventType").FinishEventType>;
            data: z.ZodOptional<z.ZodAny>;
        }, "strip", z.ZodTypeAny, {
            type: import("../../Timing/FinishEventType").FinishEventType;
            data?: any;
        }, {
            type: import("../../Timing/FinishEventType").FinishEventType;
            data?: any;
        }>>;
        position: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        appletUid: string;
        appletVersion: string;
        configuration: Record<string, unknown>;
        position?: number | undefined;
        startsAt?: Date | undefined;
        endsAt?: Date | undefined;
        finishEvent?: {
            type: import("../../Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
    }, {
        appletUid: string;
        appletVersion: string;
        configuration: Record<string, unknown>;
        position?: number | undefined;
        startsAt?: Date | undefined;
        endsAt?: Date | undefined;
        finishEvent?: {
            type: import("../../Timing/FinishEventType").FinishEventType;
            data?: any;
        } | undefined;
    }>;
    readonly EXTENDED_MANAGEMENT: z.ZodObject<{
        url: z.ZodNullable<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        url: string | null;
    }, {
        url: string | null;
    }>;
    readonly NETWORK_INTERFACES: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
        disabled: z.ZodOptional<z.ZodBoolean>;
        gateway: z.ZodOptional<z.ZodString>;
        localAddress: z.ZodOptional<z.ZodString>;
        netmask: z.ZodOptional<z.ZodString>;
        dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, {
        type: z.ZodLiteral<"wifi">;
        wifiStrength: z.ZodOptional<z.ZodNumber>;
        wifiSsid: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        type: "wifi";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
        wifiStrength?: number | undefined;
        wifiSsid?: string | undefined;
    }, {
        name: string;
        type: "wifi";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
        wifiStrength?: number | undefined;
        wifiSsid?: string | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
        disabled: z.ZodOptional<z.ZodBoolean>;
        gateway: z.ZodOptional<z.ZodString>;
        localAddress: z.ZodOptional<z.ZodString>;
        netmask: z.ZodOptional<z.ZodString>;
        dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, {
        type: z.ZodLiteral<"ethernet">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        type: "ethernet";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }, {
        name: string;
        type: "ethernet";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
        disabled: z.ZodOptional<z.ZodBoolean>;
        gateway: z.ZodOptional<z.ZodString>;
        localAddress: z.ZodOptional<z.ZodString>;
        netmask: z.ZodOptional<z.ZodString>;
        dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, {
        type: z.ZodLiteral<"vpn">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        type: "vpn";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }, {
        name: string;
        type: "vpn";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
        disabled: z.ZodOptional<z.ZodBoolean>;
        gateway: z.ZodOptional<z.ZodString>;
        localAddress: z.ZodOptional<z.ZodString>;
        netmask: z.ZodOptional<z.ZodString>;
        dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, {
        type: z.ZodLiteral<"mobile">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        type: "mobile";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }, {
        name: string;
        type: "mobile";
        macAddress: string;
        disabled?: boolean | undefined;
        gateway?: string | undefined;
        localAddress?: string | undefined;
        netmask?: string | undefined;
        dns?: string[] | undefined;
    }>]>, "many">;
    readonly DISPLAY_POWER_ON: z.ZodObject<{
        powerOn: z.ZodBoolean;
    }, "strict", z.ZodTypeAny, {
        powerOn: boolean;
    }, {
        powerOn: boolean;
    }>;
    readonly SCREENSHOT_CAPTURE: z.ZodObject<{
        enabled: z.ZodBoolean;
    }, "strict", z.ZodTypeAny, {
        enabled: boolean;
    }, {
        enabled: boolean;
    }>;
};
export interface NativeTimer extends IShortWeekdayTimer {
    type: NativeTimerType;
    volume: number;
}
export interface ProprietaryTimer extends IShortWeekdayTimer {
    keepAppletRunning?: boolean;
}
export { IShortWeekdayTimer, ShortWeekdayEnum, ILongWeekdayTimer, LongWeekdayEnum, AppletSettings };
export type SocketDriver = SocketDriverInternal;
export declare const SocketDriver: typeof SocketDriverInternal;
/**
 * Device settings data is a generic type used to manage settings on devices.
 * All of them should be reported as a DeviceMonitoringLog of DeviceTelemetryType with the same name as the setting.
 * All data here should be strictly compatible with the data reported in DeviceMonitoringLog (MonitoringLogData).
 */
export type IDeviceSettings = {
    [K in DeviceSettingsType]?: z.infer<(typeof DeviceSettingsSchemas)[K]>;
};
/**
 * A special type that gives you ability to get any DeviceSettings value type by DeviceSettingsType enum.
 * It's much more convenient than importing specific types called by prefix (e.g.: Instead of {@link VolumeSettings} use {@link DeviceSettingsValue<DeviceSettingsType.VOLUME>})
 */
export type DeviceSettingsValue<T extends DeviceSettingsType> = T extends keyof IDeviceSettings ? Required<IDeviceSettings>[T] : never;
/**
 * @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType>} instead for all settings or {@link DeviceSettingsValue<DeviceSettingsType.VOLUME>} for a specific setting.
 */
export type DeviceSettings = Required<IDeviceSettings>[keyof IDeviceSettings];
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.VOLUME>} instead */
export type VolumeSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.VOLUME]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.BRIGHTNESS>} instead */
export type BrightnessSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.BRIGHTNESS]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.TIMERS>[number]} instead */
export type TimerSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.TIMERS]>[number];
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.PROPRIETARY_TIMERS>[number]} instead */
export type ProprietaryTimerSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.PROPRIETARY_TIMERS]>[number];
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.RESOLUTION>} instead */
export type ResolutionSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.RESOLUTION]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.ORIENTATION>} instead */
export type OrientationSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.ORIENTATION]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.REMOTE_CONTROL>} instead */
export type RemoteControlSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.REMOTE_CONTROL]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.APPLICATION_VERSION>} instead */
export type ApplicationVersionSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.APPLICATION_VERSION]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.FIRMWARE_VERSION>} instead */
export type FirmwareVersionSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.FIRMWARE_VERSION]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.DEBUG>} instead */
export type DebugSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.DEBUG]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.DATETIME>} instead */
export type DateTimeSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.DATETIME]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.POWER_ACTIONS_SCHEDULE>[number]} instead */
export type PowerActionsScheduleSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.POWER_ACTIONS_SCHEDULE]>[number];
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.AUTO_RECOVERY>} instead */
export type AutoRecoverySettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.AUTO_RECOVERY]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.PEER_RECOVERY>} instead */
export type PeerRecoverySettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.PEER_RECOVERY]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.PROXY>} instead */
export type ProxySettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.PROXY]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.CONNECTION_METHOD>} instead */
export type ConnectionMethod = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.CONNECTION_METHOD]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.PACKAGES>} instead */
export type PackageSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.PACKAGES]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.TELEMETRY_INTERVALS>} instead */
export type TelemetryIntervalsSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.TELEMETRY_INTERVALS]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.EXTENDED_MANAGEMENT>} instead */
export type ExtendedManagementSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.EXTENDED_MANAGEMENT]>;
/** @deprecated Use {@link DeviceSettingsValue<DeviceSettingsType.SCREENSHOT_CAPTURE>} instead */
export type ScreenshotCaptureSettings = z.infer<(typeof DeviceSettingsSchemas)[DeviceSettingsType.SCREENSHOT_CAPTURE]>;
/**
 * @deprecated use NativeTimer instead
 */
export interface LongWeekdayNativeTimer extends ILongWeekdayTimer {
    type: NativeTimerType;
    volume: number;
}
/**
 * @deprecated use ProprietaryTimer instead
 */
export interface LongWeekdayProprietaryTimer extends ILongWeekdayTimer {
    keepAppletRunning?: boolean;
}
