export declare enum Message {
    ScreenshotRecorded = "ScreenshotRecorded",
    MouseEvent = "MouseEvent",
    KeyEvent = "KeyEvent",
    ButtonEvent = "ButtonEvent",
    BrowserConnected = "BrowserConnected",
    BrowserDisconnected = "BrowserDisconnected",
    DeviceConnected = "DeviceConnected",
    DeviceDisconnected = "DeviceDisconnected"
}
export declare const FromDeviceMessages: Message[];
export interface ScreenshotRecordedPayload {
    screenshotUri: string;
    width: number;
    height: number;
}
export declare const FromBrowserMessages: Message[];
export declare const MouseEventTypes: readonly ["mousedown", "mouseup", "click", "dblclick", "mousemove", "cancel"];
export type MouseEventType = (typeof MouseEventTypes)[number];
export interface MouseEventPayload {
    type: MouseEventType;
    x: number;
    y: number;
}
export declare const ButtonEventTypes: readonly ["up", "down", "left", "right", "back", "home", "recentapps", "accept"];
export type ButtonEventType = (typeof ButtonEventTypes)[number];
export interface ButtonEventPayload {
    type: ButtonEventType;
}
export declare const KeyEventTypes: readonly ["down", "up"];
export type KeyEventType = (typeof KeyEventTypes)[number];
export interface KeyEventPayload {
    type: KeyEventType;
    key: string;
    code: string;
    repeat: boolean;
}
export type EventType = MouseEventType | ButtonEventType | KeyEventType;
export type EventPayload = MouseEventPayload | ButtonEventPayload | KeyEventPayload;
export type EventMessage = Message.MouseEvent | Message.ButtonEvent | Message.KeyEvent;
