import { z } from 'zod';
export type ITelemetryConfigurationCheckIntervals = {
    [intervalType in TelemetryConfigurationCheckInterval]: number;
};
/**
 * `DeviceTelemetryType` loosely corresponts with with `TelemetryConfigurationCheckInterval`
 */
export declare enum TelemetryConfigurationCheckInterval {
    SCREENSHOTS = "screenshots",
    TEMPERATURE = "temperature",
    APPLICATION_VERSION = "applicationVersion",
    FRONT_DISPLAY_VERSION = "frontDisplayVersion",
    BRIGHTNESS = "brightness",
    DATETIME = "datetime",
    DEBUG = "debug",
    FIRMWARE_VERSION = "firmwareVersion",
    ORIENTATION = "orientation",
    POWER_ACTIONS_SCHEDULE = "powerActionsSchedule",
    PROPRIETARY_TIMERS = "proprietaryTimers",
    REMOTE_CONTROL = "remoteControl",
    RESOLUTION = "resolution",
    TIMERS = "timers",
    VOLUME = "volume",
    STORAGE = "storage",
    BATTERY = "battery",
    POLICY = "policy",
    PEER_RECOVERY = "peerRecovery",
    AUTO_RECOVERY = "autoRecovery",
    EXTENDED_MANAGEMENT = "extendedManagement",
    APP_MODULES = "appModules",
    DEFAULT = "default"
}
export declare const PositiveNumberOptionalSchema: z.ZodOptional<z.ZodNumber>;
export declare const TelemetryCheckIntervalsSchema: z.ZodObject<{
    screenshots: z.ZodOptional<z.ZodNumber>;
    temperature: z.ZodOptional<z.ZodNumber>;
    applicationVersion: z.ZodOptional<z.ZodNumber>;
    frontDisplayVersion: z.ZodOptional<z.ZodNumber>;
    brightness: z.ZodOptional<z.ZodNumber>;
    datetime: z.ZodOptional<z.ZodNumber>;
    debug: z.ZodOptional<z.ZodNumber>;
    firmwareVersion: z.ZodOptional<z.ZodNumber>;
    orientation: z.ZodOptional<z.ZodNumber>;
    powerActionsSchedule: z.ZodOptional<z.ZodNumber>;
    proprietaryTimers: z.ZodOptional<z.ZodNumber>;
    remoteControl: z.ZodOptional<z.ZodNumber>;
    resolution: z.ZodOptional<z.ZodNumber>;
    timers: z.ZodOptional<z.ZodNumber>;
    volume: z.ZodOptional<z.ZodNumber>;
    storage: z.ZodOptional<z.ZodNumber>;
    battery: z.ZodOptional<z.ZodNumber>;
    policy: z.ZodOptional<z.ZodNumber>;
    peerRecovery: z.ZodOptional<z.ZodNumber>;
    autoRecovery: z.ZodOptional<z.ZodNumber>;
    extendedManagement: z.ZodOptional<z.ZodNumber>;
    appModules: z.ZodOptional<z.ZodNumber>;
    default: z.ZodOptional<z.ZodNumber>;
}, "strict", z.ZodTypeAny, {
    screenshots?: number | undefined;
    temperature?: number | undefined;
    applicationVersion?: number | undefined;
    frontDisplayVersion?: number | undefined;
    brightness?: number | undefined;
    datetime?: number | undefined;
    debug?: number | undefined;
    firmwareVersion?: number | undefined;
    orientation?: number | undefined;
    powerActionsSchedule?: number | undefined;
    proprietaryTimers?: number | undefined;
    remoteControl?: number | undefined;
    resolution?: number | undefined;
    timers?: number | undefined;
    volume?: number | undefined;
    storage?: number | undefined;
    battery?: number | undefined;
    policy?: number | undefined;
    peerRecovery?: number | undefined;
    autoRecovery?: number | undefined;
    extendedManagement?: number | undefined;
    appModules?: number | undefined;
    default?: number | undefined;
}, {
    screenshots?: number | undefined;
    temperature?: number | undefined;
    applicationVersion?: number | undefined;
    frontDisplayVersion?: number | undefined;
    brightness?: number | undefined;
    datetime?: number | undefined;
    debug?: number | undefined;
    firmwareVersion?: number | undefined;
    orientation?: number | undefined;
    powerActionsSchedule?: number | undefined;
    proprietaryTimers?: number | undefined;
    remoteControl?: number | undefined;
    resolution?: number | undefined;
    timers?: number | undefined;
    volume?: number | undefined;
    storage?: number | undefined;
    battery?: number | undefined;
    policy?: number | undefined;
    peerRecovery?: number | undefined;
    autoRecovery?: number | undefined;
    extendedManagement?: number | undefined;
    appModules?: number | undefined;
    default?: number | undefined;
}>;
export type TelemetryCheckIntervals = z.infer<typeof TelemetryCheckIntervalsSchema>;
export declare const MinTelemetryIntervals: ITelemetryConfigurationCheckIntervals;
export declare const DEFAULT_MIN_TELEMETRY_INTERVAL: number;
export declare const MinTelemetryIntervalsByPlan: {
    readonly open: number;
    readonly basic: number;
    readonly medium: number;
    readonly all: number;
    readonly platform: number;
};
export declare const MinScreenshotIntervalsByPlan: {
    readonly open: number;
    readonly basic: number;
    readonly medium: number;
    readonly all: number;
    readonly platform: number;
};
/** @deprecated Use MinScreenshotIntervalsByPlan */
export declare const MinScreenthotIntervalsByPlan: {
    readonly open: number;
    readonly basic: number;
    readonly medium: number;
    readonly all: number;
    readonly platform: number;
};
